/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaofintelsgo.integracao.impl;

import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.integracaofintelsgo.FiltroIntegracaoFintelSgoDTO;
import br.com.elotech.tributos.dto.integracaofintelsgo.OperacaoFintelSgoIntegracaoDTO;
import br.com.elotech.tributos.service.integracaofintelsgo.integracao.ClassificacaoIntegracaoFintelSgo;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.openl.util.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.RowMapper;

public class IntegracaoEstornoDevolucaoFintelSgoService
implements ClassificacaoIntegracaoFintelSgo<OperacaoFintelSgoIntegracaoDTO> {
    private static final String SQLPATH = "br/com/elotech/tributos/repository/integracaofintelsgo/find-estornodevolucao-fintel-sgo.sql";

    private String sourceSqlFile() {
        return FileUtils.readResourceAsString((String)SQLPATH);
    }

    private String getFiltroOperacoes(FiltroIntegracaoFintelSgoDTO filtro, String sql) {
        String sqlWithFilter = sql;
        String sqlFiltro = this.getBuildFiltro(filtro.getDataInicial(), filtro.getDataFinal());
        sqlWithFilter = sqlWithFilter.replace(":filtroestornodevolucoes", sqlFiltro);
        return sqlWithFilter;
    }

    public String getCountSql(FiltroIntegracaoFintelSgoDTO filtro) {
        String sql = this.sourceSqlFile();
        sql = sql.replace(":pageable", "");
        String sqlFinal = this.getFiltroOperacoes(filtro, sql);
        return String.format(" WITH totalregistros AS ( %s ) SELECT COUNT(*) FROM totalregistros ", sqlFinal);
    }

    public String getSql(FiltroIntegracaoFintelSgoDTO filtro, Pageable pageable) {
        String sql = this.sourceSqlFile();
        String sqlWithFilter = this.getFiltroOperacoes(filtro, sql);
        String sqlPagination = this.getSqlPagination(pageable);
        return sqlWithFilter.replace(":pageable", sqlPagination);
    }

    public RowMapper<OperacaoFintelSgoIntegracaoDTO> getMapper() {
        return (rs, rowNum) -> {
            OperacaoFintelSgoIntegracaoDTO operacao = new OperacaoFintelSgoIntegracaoDTO();
            Optional.ofNullable(rs.getString("DataBaixa")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setDataBaixa(arg_0));
            Optional.ofNullable(rs.getString("Exercicio")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setExercicio(arg_0));
            Optional.ofNullable(rs.getString("ExercicioReferencia")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setExercicioReferencia(arg_0));
            Optional.ofNullable(rs.getString("TipoPagto")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setTipoPagto(arg_0));
            Optional.ofNullable(rs.getString("TipoCadastro")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setTipoCadastro(arg_0));
            Optional.ofNullable(rs.getString("CadastroGeral")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setCadastroGeral(arg_0));
            Optional.ofNullable(rs.getString("GuiaRecolhimento")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setGuiaRecolhimento(arg_0));
            Optional.ofNullable(rs.getString("SubDivida")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setSubDivida(arg_0));
            Optional.ofNullable(rs.getString("ParcelaOriginal")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setParcelaOriginal(arg_0));
            Optional.ofNullable(rs.getString("Parcela")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setParcela(arg_0));
            Optional.ofNullable(rs.getString("ExercicioLote")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setExercicioLote(arg_0));
            Optional.ofNullable(rs.getString("Lote")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setLote(arg_0));
            Optional.ofNullable(rs.getString("SequenciaLote")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setSequenciaLote(arg_0));
            Optional.ofNullable(rs.getString("DataPagamento")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setDataPagamento(arg_0));
            Optional.ofNullable(rs.getString("DataMovimento")).map(arg_0 -> this.parseStringToLocalDate(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setDataMovimento(arg_0));
            Optional.ofNullable(rs.getString("SituacaoBaixa")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setSituacaoBaixa(arg_0));
            Optional.ofNullable(rs.getString("ContaBancaria")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setContaBancaria(arg_0));
            Optional.ofNullable(rs.getString("ContaBancariaDescr")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setContaBancariaDescr(arg_0));
            Optional.ofNullable(rs.getString("Banco")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setBanco(arg_0));
            Optional.ofNullable(rs.getString("Agencia")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setAgencia(arg_0));
            Optional.ofNullable(rs.getString("Ocorrencia")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setOcorrencia(arg_0));
            Optional.ofNullable(rs.getString("TipoBloqueto")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setTipoBloqueto(arg_0));
            Optional.ofNullable(rs.getString("NossoNumero")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setNossoNumero(arg_0));
            Optional.ofNullable(rs.getString("CodigoBarras")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setCodigoBarras(arg_0));
            Optional.ofNullable(rs.getString("TipoDebito")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setTipoDebito(arg_0));
            Optional.ofNullable(rs.getString("AutoInfracaoFiscal")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setAutoInfracaoFiscal(arg_0));
            Optional.ofNullable(rs.getString("ExercicioAutoInfracao")).map(arg_0 -> this.parseLong(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setExercicioAutoInfracao(arg_0));
            Optional.ofNullable(rs.getString("TipoDocumento")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setTipoDocumento(arg_0));
            Optional.ofNullable(rs.getString("MesReferencia")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setMesReferencia(arg_0));
            Optional.ofNullable(rs.getString("SistemaGeracao")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setSistemaGeracao(arg_0));
            Optional.ofNullable(rs.getString("ChavePagamentoAise")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setChavePagamentoAise(arg_0));
            Optional.ofNullable(rs.getString("CodigoDas")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setCodigoDas(arg_0));
            Optional.ofNullable(rs.getString("CodigoGuiaIsse")).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setCodigoGuiaIsse(arg_0));
            Optional.ofNullable(rs.getString("ValorPago")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setValorPago(arg_0));
            Optional.ofNullable(rs.getString("ValorPrincipal")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setValorPrincipal(arg_0));
            Optional.ofNullable(rs.getString("ValorMulta")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setValorMulta(arg_0));
            Optional.ofNullable(rs.getString("ValorJuros")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setValorJuros(arg_0));
            Optional.ofNullable(rs.getString("ValorCorrecao")).map(arg_0 -> this.parseBigDecimal(arg_0)).ifPresent(arg_0 -> ((OperacaoFintelSgoIntegracaoDTO)operacao).setValorCorrecao(arg_0));
            return operacao;
        };
    }

    private BigDecimal parseBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Long parseLong(String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? Long.valueOf(value) : null;
    }

    private LocalDate parseStringToLocalDate(String data) {
        return Objects.nonNull(data) ? LocalDate.parse(data) : null;
    }

    private String getBuildFiltro(LocalDate dataInicial, LocalDate dataFinal) {
        if (Objects.nonNull(dataInicial) && Objects.nonNull(dataFinal)) {
            String filtro = " where tdc.data between ':dataInicial' and ':dataFinal' ";
            filtro = filtro.replace(":dataInicial", DateUtils.localDateToString((LocalDate)dataInicial));
            filtro = filtro.replace(":dataFinal", DateUtils.localDateToString((LocalDate)dataFinal));
            return filtro;
        }
        return "";
    }

    private String getSqlPagination(Pageable pageable) {
        return "LIMIT " + pageable.getPageSize() + " OFFSET " + pageable.getOffset();
    }
}

