/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoelogeo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.camposdinamicos.Alternativa;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.dto.integracaoelogeo.BoletimElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroGeralElogeoDTO;
import br.com.elotech.tributos.dto.integracaoelogeo.CadastroGeralPostElogeoDTO;
import br.com.elotech.tributos.repository.SolicitacaoAlvaraRepository;
import br.com.elotech.tributos.repository.camposdinamicos.CampoAlternativaRepository;
import br.com.elotech.tributos.repository.camposdinamicos.CampoRepository;
import br.com.elotech.tributos.repository.camposdinamicos.RespostaRepository;
import br.com.elotech.tributos.repository.solicitacaotestada.SolicitacaoTestadaLogRepository;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroImobiliarioService;
import br.com.elotech.tributos.service.CondominioService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.service.integracaoelogeo.CadastroImobiliarioElogeoServiceAbstract;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!onpremise"})
public class OxyCadastroImobiliarioElogeoService
extends CadastroImobiliarioElogeoServiceAbstract {
    private final RespostaRepository respostaRepository;
    private final CampoAlternativaRepository campoAlternativaRepository;
    private final CampoRepository campoRepository;

    public OxyCadastroImobiliarioElogeoService(CadastroGeralService cadastroGeralService, CadastroImobiliarioService cadastroImobiliarioService, DistritoService distritoService, SetorService setorService, BairroService bairroService, SetorQuadraService setorQuadraService, SolicitacaoTestadaLogRepository solicitacaoTestadaLogRepository, SolicitacaoAlvaraRepository solicitacaoAlvaraRepository, LogradouroService logradouroService, LoteamentoService loteamentoService, CondominioService condominioService, ParametroGeralService parametroGeralService, RespostaRepository respostaRepository, CampoAlternativaRepository campoAlternativaRepository, CampoRepository campoRepository) {
        super(cadastroGeralService, cadastroImobiliarioService, distritoService, setorService, bairroService, setorQuadraService, solicitacaoTestadaLogRepository, solicitacaoAlvaraRepository, logradouroService, loteamentoService, condominioService, parametroGeralService);
        this.respostaRepository = respostaRepository;
        this.campoAlternativaRepository = campoAlternativaRepository;
        this.campoRepository = campoRepository;
    }

    protected void mergeBoletins(CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO, CadastroImobiliario saved) {
        this.mergeBoletimTerreno(cadastroGeralPostElogeoDTO.getImobiliario().getBoletim(), saved);
        cadastroGeralPostElogeoDTO.getImobiliario().getSegmentos().forEach(segmentoDTO -> {
            try {
                CadastroImobiliarioSegmento cadastroImobiliarioSegmento = saved.getSegmentos().stream().filter(segmento -> segmento.getSequencia().equals(segmentoDTO.getSequencia())).findFirst().orElseThrow();
                this.mergeBoletimSegmento(segmentoDTO.getCaracteristicas(), cadastroImobiliarioSegmento);
            }
            catch (NoSuchElementException e) {
                throw new EloValidationException(String.format("Segmento n\u00e3o encontrado para o Cadastro Imobili\u00e1rio %d", saved.getCadastroGeral()));
            }
        });
    }

    protected CadastroGeralElogeoDTO entityToElogeoDTO(CadastroImobiliario cadastroImobiliario) {
        List boletimImobiliarioTerrenos = this.respostaRepository.getRespostasFromTerrenoOnlyAnswered(cadastroImobiliario.getId());
        CadastroGeralElogeoDTO cadastroGeralElogeoDTO = CadastroGeralElogeoDTO.oxyFrom((CadastroImobiliario)cadastroImobiliario, (List)boletimImobiliarioTerrenos);
        cadastroGeralElogeoDTO.getImobiliario().getSegmentos().forEach(segmentoDTO -> {
            List boletimSegmento = this.respostaRepository.getRespostasFromSegmentoOnlyAnswered(segmentoDTO.getId()).stream().map(respostaDTO -> BoletimElogeoDTO.from((Resposta)respostaDTO.getResposta())).collect(Collectors.toList());
            segmentoDTO.setCaracteristicas(boletimSegmento);
        });
        cadastroGeralElogeoDTO.getImobiliario().getTestadas().forEach(logradouroTestadaDTO -> {
            List boletimLogradouroTestada = this.respostaRepository.getRespostasFromLogradouroOnlyAnswered(logradouroTestadaDTO.getSecaoId()).stream().map(respostaDTO -> BoletimElogeoDTO.from((Resposta)respostaDTO.getResposta())).collect(Collectors.toList());
            logradouroTestadaDTO.getSecao().setCaracteristicas(boletimLogradouroTestada);
        });
        return cadastroGeralElogeoDTO;
    }

    protected CadastroImobiliario prepareElogeoToSave(CadastroImobiliario cadastroImobiliarioToSave, Boolean novoCadastro, CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO) {
        if (!novoCadastro.booleanValue() && cadastroImobiliarioToSave.getCadastroGeral() != null) {
            CadastroImobiliario cadastroImobiliarioFound = Optional.ofNullable(this.cadastroImobiliarioService.findByTipoCadastroAndCadastroGeral(TipoCadastro.IMOBILIARIO, cadastroImobiliarioToSave.getCadastroGeral())).orElseThrow(() -> new EloValidationException(String.format("Cadastro Imobili\u00e1rio %s n\u00e3o encontrado", cadastroImobiliarioToSave.getCadastroGeral())));
            cadastroImobiliarioFound.getSegmentos().forEach(segmento -> {
                if (cadastroGeralPostElogeoDTO.getImobiliario().getSegmentos().stream().noneMatch(v -> segmento.getSequencia().equals(v.getSequencia()))) {
                    this.respostaRepository.deleteAll((Iterable)this.respostaRepository.getRespostasSegmento(segmento.getId()));
                }
            });
            return cadastroImobiliarioFound.mergeElogeo(cadastroImobiliarioToSave);
        }
        return cadastroImobiliarioToSave;
    }

    public void mergeBoletimTerreno(List<BoletimElogeoDTO> respostas, CadastroImobiliario cadastroImobiliario) {
        ArrayList boletimAlterado = new ArrayList();
        respostas.stream().map(respostaBoletim -> {
            Alternativa alternativa = null;
            Campo campo = null;
            if (Objects.nonNull(respostaBoletim.getResposta().getCodigo())) {
                alternativa = this.findAlternativa(respostaBoletim);
            }
            if (Objects.nonNull(respostaBoletim.getResposta().getCampo())) {
                campo = this.findCampo(respostaBoletim);
            }
            return respostaBoletim.toEntityRespostaTerreno(cadastroImobiliario, alternativa, campo, respostaBoletim.getResposta().getId());
        }).forEach(boletimAlterado::add);
        cadastroImobiliario.mergeRespostasTerreno(boletimAlterado);
        this.respostaRepository.saveAll(boletimAlterado);
    }

    public void mergeBoletimSegmento(List<BoletimElogeoDTO> respostas, CadastroImobiliarioSegmento cadastroImobiliarioSegmento) {
        cadastroImobiliarioSegmento.getRespostasSegmento().clear();
        cadastroImobiliarioSegmento.getRespostasSegmento().addAll(this.respostaRepository.getRespostasSegmento(cadastroImobiliarioSegmento.getId()));
        ArrayList boletimAlterado = new ArrayList();
        respostas.stream().map(respostaBoletim -> {
            Alternativa alternativa = null;
            Campo campo = null;
            if (Objects.nonNull(respostaBoletim.getResposta().getCodigo())) {
                alternativa = this.findAlternativa(respostaBoletim);
            }
            if (Objects.nonNull(respostaBoletim.getResposta().getCampo())) {
                campo = this.findCampo(respostaBoletim);
            }
            return respostaBoletim.toEntityRespotaSegmento(cadastroImobiliarioSegmento, alternativa, campo, respostaBoletim.getResposta().getId());
        }).forEach(boletimAlterado::add);
        cadastroImobiliarioSegmento.mergeRespostasSegmento(boletimAlterado);
        this.respostaRepository.saveAll(boletimAlterado);
    }

    protected Campo findCampo(BoletimElogeoDTO respostaBoletim) {
        return (Campo)this.campoRepository.findById((Object)respostaBoletim.getResposta().getCampo().getId()).orElseThrow(() -> new EloValidationException(String.format("Campo %s do Boletim n\u00e3o encontrado.", respostaBoletim.getResposta().getCampo().getCodigo())));
    }

    protected Alternativa findAlternativa(BoletimElogeoDTO respostaBoletim) {
        return (Alternativa)this.campoAlternativaRepository.findById((Object)respostaBoletim.getResposta().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Alternativa %s do Boletim n\u00e3o encontrado.", respostaBoletim.getResposta().getCodigo())));
    }
}

