/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.santander;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.ParametroPix;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.dto.integracaoboleto.DadosCertificadoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.DadosIntegracaoOauth;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.santander.QrCodePixSantanderRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.santander.QrCodePixSantanderResponseDTO;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.enums.TipoIntegracaoToken;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.ParametroPixRepository;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoleto;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.AmbienteUtils;
import br.com.elotech.tributos.util.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class IntegracaoBoletoSantanderService
extends IntegracaoBoleto
implements IntegracaoPix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoSantanderService.class);
    private static final String AUTHORIZATION = "Authorization";
    private static final String BEARER = "Bearer %s";
    private final ParametroPixRepository parametroPixRepository;
    private final ObjectMapper mapper;
    private final ConfigurableEnvironment configurableEnvironment;

    public IntegracaoBoletoSantanderService(List<IntegracaoTokenService> integracaoTokenServices, ParametroGeralService parametroGeralService, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ParametroPixRepository parametroPixRepository, ObjectMapper mapper, ConfigurableEnvironment configurableEnvironment) {
        super(integracaoTokenServices, parametroGeralService, integracaoBoletoPixLogRepository, transactionManager, (TransactionDefinition)new DefaultTransactionDefinition(3));
        this.parametroPixRepository = parametroPixRepository;
        this.mapper = mapper;
        this.configurableEnvironment = configurableEnvironment;
    }

    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto boleto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_PIX);
        try {
            if (Objects.isNull(boleto)) {
                throw new EloValidationException("Boleto n\u00e3o informado para a integra\u00e7\u00e3o pix.");
            }
            boleto.setTxidPix(boleto.generateTxIdPix());
            String url = this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_API_PIX_URL);
            String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_OAUTH_URL);
            String clienId = this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_CLIENTID);
            String clientSecret = this.getParametro(ParametroGeralEnum.BOLETO_SANTANDER_CLIENTSECRET);
            String finalUrl = url.concat(String.format("/cob/%s", boleto.getTxidPix()));
            DadosIntegracaoOauth dadosOauth = DadosIntegracaoOauth.builder().oauthUrl(oauthUrl).clientId(clienId).clientSecret(clientSecret).build();
            ParametroPix parametroPix = this.parametroPixRepository.getByEntidade(boleto.getEntidade());
            DadosCertificadoDTO certificadoSantander = Optional.ofNullable(parametroPix).map(ParametroPix::getCertificadoSantander).map(DadosCertificadoDTO::from).orElse(null);
            QrCodePixSantanderRequestDTO dto = QrCodePixSantanderRequestDTO.from((Bloqueto)boleto);
            HttpHeaders headers = new HttpHeaders();
            String token = this.getAccessToken(this.getCodigoBanco(), IntegracaoTokenOperation.BOLETO, dadosOauth, certificadoSantander, this.authBodyBuilder(dadosOauth), TipoIntegracaoToken.DEFAULT.name());
            headers.set(AUTHORIZATION, String.format(BEARER, token));
            headers.set("Content-Type", "application/json");
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            integracaoBoletoPixLog.setTxid(boleto.getTxidPix());
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(finalUrl);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.PUT);
            QrCodePixSantanderResponseDTO response = (QrCodePixSantanderResponseDTO)this.getHttpClientTemplate(certificadoSantander).exchange(finalUrl, HttpMethod.PUT, requestEntity, QrCodePixSantanderResponseDTO.class, new Object[0]).getBody();
            if (Objects.nonNull(response)) {
                integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
                IntegracaoPixResponseDTO resultDto = new IntegracaoPixResponseDTO();
                resultDto.setTextoQrCode(this.geraPixCopiaECola(AmbienteUtils.getTenant(), response.getValor().getOriginal(), response.getLocation()));
                resultDto.setTxid(response.getTxid());
                IntegracaoPixResponseDTO integracaoPixResponseDTO = resultDto;
                return integracaoPixResponseDTO;
            }
            IntegracaoPixResponseDTO integracaoPixResponseDTO = null;
            return integracaoPixResponseDTO;
        }
        catch (RestException ex) {
            integracaoBoletoPixLog.setDescricaoErro(ex.getMessage());
            throw new RestException(ex.getStatus(), ex.getMessage(), (Throwable)ex);
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public Long getCodigoBanco() {
        return Banco.CODIGO_SANTANDER;
    }

    protected MultiValueMap<String, String> authBodyBuilder(DadosIntegracaoOauth dadosOauth) {
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)dadosOauth.getClientId());
        body.add((Object)"client_secret", (Object)dadosOauth.getClientSecret());
        return body;
    }

    private String geraPixCopiaECola(String tenant, String valor, String location) {
        StringBuilder urlBuilder = new StringBuilder("00020101021226");
        urlBuilder.append(this.obterTamanhoTotalLocation());
        urlBuilder.append("0014br.gov.bcb.pix25");
        urlBuilder.append(this.obterTamanhoLocation());
        urlBuilder.append(location);
        urlBuilder.append("52040000530398654");
        this.adicionarValor(urlBuilder, valor);
        urlBuilder.append("5802BR59");
        this.adicionarRecebedor(urlBuilder, tenant);
        urlBuilder.append("60");
        this.adicionarCidade(urlBuilder, tenant);
        urlBuilder.append("62070503***");
        urlBuilder.append("6304");
        this.adicionarCrc(urlBuilder);
        return urlBuilder.toString();
    }

    private String obterTamanhoTotalLocation() {
        return AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equals("oxy") ? "85" : "87";
    }

    private String obterTamanhoLocation() {
        return AmbienteUtils.getAmbiente((ConfigurableEnvironment)this.configurableEnvironment).equals("oxy") ? "63" : "65";
    }

    private void adicionarValor(StringBuilder urlBuilder, String valor) {
        urlBuilder.append(String.format("%02d", valor.length()));
        urlBuilder.append(valor);
    }

    private void adicionarRecebedor(StringBuilder urlBuilder, String tenant) {
        String cidade = StringUtils.retiraAcentos((String)tenant.toUpperCase());
        String recebedor = "PREFEITURA " + cidade;
        String recebedorFinal = recebedor.length() > 25 ? recebedor.substring(0, 24) : recebedor;
        urlBuilder.append(recebedorFinal.length());
        urlBuilder.append(recebedorFinal);
    }

    private void adicionarCidade(StringBuilder urlBuilder, String tenant) {
        String cidade = StringUtils.retiraAcentos((String)tenant.toUpperCase());
        String cidadeFinal = cidade.length() > 15 ? cidade.substring(0, 14) : cidade;
        urlBuilder.append(String.format("%02d", cidadeFinal.length()));
        urlBuilder.append(cidadeFinal);
    }

    private void adicionarCrc(StringBuilder urlBuilder) {
        String crc = String.format("%X", this.calculateCRC16CCITT(urlBuilder.toString().getBytes()));
        urlBuilder.append(crc);
    }
}

