/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.delbank;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCodigoBarras;
import br.com.elotech.tributos.domain.cnab240.ParametroCNAB240;
import br.com.elotech.tributos.domain.integracaoboleto.IntegracaoBoletoPixLog;
import br.com.elotech.tributos.domain.registroboletoonline.ErroBoletoRegistroOnline;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.integracaoboleto.ConsultaPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.IntegracaoPixResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.ResultadoCancelamentoBoletoDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.CertificadoDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.EmissaoBoletoDelBankDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.EmissaoBoletoDelBankResponseDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.GerarQrCodePixDelBankRequestDTO;
import br.com.elotech.tributos.dto.integracaoboleto.delbank.GerarQrCodePixDelBankResponseDTO;
import br.com.elotech.tributos.enums.integracaoboleto.TipoIntegracaoBoletoPix;
import br.com.elotech.tributos.repository.integracaoboleto.IntegracaoBoletoPixLogRepository;
import br.com.elotech.tributos.repository.registroboletoonline.ErroBoletoRegistradoOnlineRepository;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistrado;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPix;
import br.com.elotech.tributos.service.integracaoboleto.delbank.DelBankService;
import br.com.elotech.tributos.util.GeradorDigitoVerificador;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.MultiValueMap;

@Service
public class IntegracaoBoletoDelBankService
implements IntegracaoBoletoRegistrado,
IntegracaoPix {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegracaoBoletoDelBankService.class);
    private final ObjectMapper mapper;
    private final IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository;
    private final PlatformTransactionManager transactionManager;
    private final TransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
    private final ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository;
    private final DelBankService delBankService;
    private static String END_BOLETO = "/v1/charges";
    private static String END_QR_CODE_DINAMICO = "/baas/api/v2/pix/qrcode/dynamic";

    public ParametroCNAB240 getParametroCnab240ByBanco() {
        return this.delBankService.getParametroCnab240ByBanco();
    }

    public CodigoBarrasDTO generateBoleto(Bloqueto boleto, ParametroCNAB240 parametroCNAB240) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_BOLETO);
        HttpEntity request = null;
        try {
            CodigoBarrasDTO codigoBarrasDTO;
            this.validarModeloBoletoEntidadeRegistro(boleto);
            integracaoBoletoPixLog.setBloqueto(boleto.getId());
            integracaoBoletoPixLog.setDataIntegracao(LocalDateTime.now());
            EmissaoBoletoDelBankDTO dto = EmissaoBoletoDelBankDTO.from((Bloqueto)boleto, (ParametroCNAB240)parametroCNAB240);
            boleto.setObservacao(dto.getCorrelationId());
            HttpHeaders headers = this.delBankService.criarHeaders();
            request = new HttpEntity((Object)dto, (MultiValueMap)headers);
            String url = String.format("%s%s", this.delBankService.getParametro(ParametroGeralEnum.BOLETO_DELBANK_URL), END_BOLETO);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)request));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
            CertificadoDelBankDTO certificadoDelBankDTO = this.delBankService.getCertificado();
            JsonNode response = (JsonNode)this.delBankService.getRestTemplate(certificadoDelBankDTO.getArquivoCertificado(), certificadoDelBankDTO.getSenhaCertificado(), certificadoDelBankDTO.getNomeArquivo()).exchange(url, HttpMethod.POST, request, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            EmissaoBoletoDelBankResponseDTO boletoResponse = (EmissaoBoletoDelBankResponseDTO)this.mapper.readValue(response.toString(), EmissaoBoletoDelBankResponseDTO.class);
            if (boletoResponse.getOurNumber() != null) {
                boleto.setNossoNumeroGeradoBanco(boletoResponse.getOurNumber());
            }
            CodigoBarrasDTO codigoBarrasDTO2 = codigoBarrasDTO = this.getCodigoBarrasDTO(boleto, boletoResponse);
            return codigoBarrasDTO2;
        }
        catch (RestException e) {
            String stackTrace = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            this.saveRespostaErro(request, e.getMessage(), boleto, stackTrace);
            integracaoBoletoPixLog = this.delBankService.builderErrorRegistro(integracaoBoletoPixLog, e);
            throw new RestException(e.getStatus(), "Erro ao enviar o boleto registrado para o Delbank: " + integracaoBoletoPixLog.getDescricaoErro(), (Throwable)e);
        }
        catch (Exception e) {
            log.error("Erro ao integrar o boleto com o Delbank", (Throwable)e);
            String stackTrace = Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n"));
            this.saveRespostaErro(request, e.getMessage(), boleto, stackTrace);
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    public IntegracaoPixResponseDTO generateQrCodePix(Bloqueto bloqueto) {
        IntegracaoBoletoPixLog integracaoBoletoPixLog = new IntegracaoBoletoPixLog(TipoIntegracaoBoletoPix.GERA_PIX);
        try {
            this.validarModeloBoletoEntidadeRegistro(bloqueto);
            Validate.notNull((Object)bloqueto);
            integracaoBoletoPixLog.setBloqueto(bloqueto.getId());
            String url = String.format("%s%s", this.delBankService.getParametro(ParametroGeralEnum.BOLETO_DELBANK_URL), END_QR_CODE_DINAMICO);
            ParametroCNAB240 parametroCNAB240 = this.getParametroCnab240ByBanco();
            GerarQrCodePixDelBankRequestDTO dto = GerarQrCodePixDelBankRequestDTO.from((Bloqueto)bloqueto, (ParametroCNAB240)parametroCNAB240);
            HttpHeaders headers = this.delBankService.criarHeaders();
            HttpEntity requestEntity = new HttpEntity((Object)dto, (MultiValueMap)headers);
            integracaoBoletoPixLog.setJsonRequest(this.mapper.writeValueAsString((Object)requestEntity));
            integracaoBoletoPixLog.setUrlRequest(url);
            integracaoBoletoPixLog.setHttpMethod(HttpMethod.POST);
            CertificadoDelBankDTO certificadoDelBankDTO = this.delBankService.getCertificado();
            JsonNode response = (JsonNode)this.delBankService.getRestTemplate(certificadoDelBankDTO.getArquivoCertificado(), certificadoDelBankDTO.getSenhaCertificado(), certificadoDelBankDTO.getNomeArquivo()).exchange(url, HttpMethod.POST, requestEntity, JsonNode.class, new Object[0]).getBody();
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            GerarQrCodePixDelBankResponseDTO boletoResponse = (GerarQrCodePixDelBankResponseDTO)this.mapper.readValue(this.mapper.writeValueAsString((Object)response), GerarQrCodePixDelBankResponseDTO.class);
            integracaoBoletoPixLog.setJsonResponse(this.mapper.writeValueAsString((Object)response));
            IntegracaoPixResponseDTO resultDto = new IntegracaoPixResponseDTO();
            resultDto.setTextoQrCode(boletoResponse.getPayloadPix());
            resultDto.setTxid(boletoResponse.getCorrelationId());
            IntegracaoPixResponseDTO integracaoPixResponseDTO = resultDto;
            return integracaoPixResponseDTO;
        }
        catch (RestException e) {
            integracaoBoletoPixLog = this.delBankService.builderErrorRegistro(integracaoBoletoPixLog, e);
            throw new RestException(e.getStatus(), integracaoBoletoPixLog.getDescricaoErro());
        }
        catch (Exception e) {
            integracaoBoletoPixLog.setDescricaoErro(e.getMessage());
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), (Throwable)e);
        }
        finally {
            this.salvarIntegracaoBoletoPixLog(integracaoBoletoPixLog);
        }
    }

    @NotNull
    public CodigoBarrasDTO getCodigoBarrasDTO(Bloqueto boleto, EmissaoBoletoDelBankResponseDTO emissaoBoletoDelBankResponseDTO) {
        CodigoBarrasDTO codigoBarrasDTO = new CodigoBarrasDTO();
        codigoBarrasDTO.setCodigoBarras(emissaoBoletoDelBankResponseDTO.getBarCode());
        codigoBarrasDTO.setLinhaDigitavel(emissaoBoletoDelBankResponseDTO.getDigitableLine());
        codigoBarrasDTO.setCampo1(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)0, (int)10));
        codigoBarrasDTO.setCampo2(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)10, (int)21));
        codigoBarrasDTO.setCampo3(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)21, (int)32));
        codigoBarrasDTO.setCampo4(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)32, (int)33));
        codigoBarrasDTO.setCampo5(StringUtils.substring((String)codigoBarrasDTO.getLinhaDigitavel(), (int)33, (int)47));
        codigoBarrasDTO.setNossoNumero(boleto.getNossoNumero());
        codigoBarrasDTO.setDvNossoNumero(boleto.getDvNossoNumero());
        codigoBarrasDTO.generateCodigoBarrasFormatadoIntervalo2Of5();
        if (Objects.nonNull(emissaoBoletoDelBankResponseDTO.getQrCode())) {
            boleto.setTextoQrCode(emissaoBoletoDelBankResponseDTO.getQrCode());
            boleto.setTxidPix(emissaoBoletoDelBankResponseDTO.getCorrelationId());
        }
        return codigoBarrasDTO;
    }

    private void salvarIntegracaoBoletoPixLog(IntegracaoBoletoPixLog integracaoBoletoPixLog) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                return (IntegracaoBoletoPixLog)this.integracaoBoletoPixLogRepository.save((Object)integracaoBoletoPixLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public void saveRespostaErro(HttpEntity<EmissaoBoletoDelBankDTO> request, String response, Bloqueto boleto, String observacao) {
        new TransactionTemplate(this.transactionManager, this.transactionDefinition).execute(status -> {
            try {
                ErroBoletoRegistroOnline erroRegistroBoletoOnlineEntity = new ErroBoletoRegistroOnline();
                erroRegistroBoletoOnlineEntity.setRequest(Objects.nonNull(request) ? this.mapper.writeValueAsBytes((Object)request) : null);
                erroRegistroBoletoOnlineEntity.setResponse((byte[])Optional.ofNullable(response).map(String::getBytes).orElse(null));
                erroRegistroBoletoOnlineEntity.setDataHoraIntegracao(LocalDateTime.now());
                erroRegistroBoletoOnlineEntity.setIdBoleto(boleto.getId());
                erroRegistroBoletoOnlineEntity.setDetalhes(observacao);
                return (ErroBoletoRegistroOnline)this.erroBoletoRegistradoOnlineRepository.save((Object)erroRegistroBoletoOnlineEntity);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        });
    }

    public void beforeGenerateBoleto(Bloqueto boleto) {
        if (Objects.isNull(boleto.getExercicioBloqueto())) {
            throw new EloValidationException("\u00c9 necess\u00e1rio o exerc\u00edcio do bloqueto para gerar o nosso n\u00famero.");
        }
        if (Objects.isNull(boleto.getNossoNumero()) || StringUtils.isBlank((String)boleto.getNossoNumero())) {
            String nossoNumero = this.gerarNossoNumero(boleto);
            String dv = this.gerarDVNossoNumero(nossoNumero);
            boleto.setNossoNumero(nossoNumero);
            boleto.setDvNossoNumero(dv);
        }
    }

    public String gerarNossoNumero(Bloqueto boleto) {
        return boleto.getEntidade() + boleto.getExercicioBloqueto().toString().substring(2, 4) + StringUtils.leftPad((String)StringUtils.substring((String)boleto.getBloqueto().toString(), (int)0, (int)7), (int)7, (String)"0");
    }

    public String gerarDVNossoNumero(String nossoNumero) {
        Integer nossoNumeroDV = GeradorDigitoVerificador.geradorDigitoVerificadorMod11((String)nossoNumero);
        if (nossoNumeroDV > 9) {
            nossoNumeroDV = 0;
        }
        return String.valueOf(nossoNumeroDV);
    }

    public TipoCodigoBarras getTipoCodigoBarras() {
        return TipoCodigoBarras.BOLETO_BANCARIO_DELBANK_COM_REGISTRO;
    }

    public Long getCodigoBanco() {
        return Banco.CODIGO_DELBANK;
    }

    public ConsultaPixResponseDTO getPagamentoByE2E(String endToendIdentification) {
        return null;
    }

    public ConsultaPixResponseDTO getPagamentoByTxid(String txid, String numeroConvenio) {
        return null;
    }

    public ConsultaPixResponseDTO getPagamento(Optional<String> txid, Optional<String> endToendIdentification, Convenio convenio) {
        return null;
    }

    public ResultadoCancelamentoBoletoDTO cancelarBoleto(Bloqueto boleto) {
        return null;
    }

    private void validarModeloBoletoEntidadeRegistro(Bloqueto boleto) {
        Convenio convenio = Optional.ofNullable(boleto).map(Bloqueto::getModeloBloqueto).map(ModeloBoleto::getConvenio).orElseThrow(() -> new EloValidationException("N\u00e3o existe um conv\u00eanio vinculado ao modelo de bloqueto!"));
        Optional.ofNullable(convenio.getEntidadeRegistro()).orElseThrow(() -> new EloValidationException(String.format("Necess\u00e1rio vincular a entidade para registro do boleto ao conv\u00eanio %s!", convenio.getNumeroConvenio())));
    }

    @Generated
    public IntegracaoBoletoDelBankService(ObjectMapper mapper, IntegracaoBoletoPixLogRepository integracaoBoletoPixLogRepository, PlatformTransactionManager transactionManager, ErroBoletoRegistradoOnlineRepository erroBoletoRegistradoOnlineRepository, DelBankService delBankService) {
        this.mapper = mapper;
        this.integracaoBoletoPixLogRepository = integracaoBoletoPixLogRepository;
        this.transactionManager = transactionManager;
        this.erroBoletoRegistradoOnlineRepository = erroBoletoRegistradoOnlineRepository;
        this.delBankService = delBankService;
    }
}

