/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.impl;

import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.core.common.dto.RegistroDTO;
import br.com.elotech.core.common.license.rest.License;
import br.com.elotech.core.common.license.rest.LicenseClientRest;
import br.com.elotech.core.common.service.EntidadeService;
import br.com.elotech.core.common.service.ValidaRegistroService;
import br.com.elotech.core.crypto.EloCrypto;
import br.com.elotech.tributos.domain.Registro;
import br.com.elotech.tributos.dto.converter.RegistroDTOConverter;
import br.com.elotech.tributos.repository.RegistroDomainRepository;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class ValidaRegistroServiceImpl
implements ValidaRegistroService {
    private final EntidadeService entidadeService;
    private final RegistroDomainRepository registroRepository;
    private final String urlBlueMix;
    private final LicenseClientRest licenseClientRest;
    private final RegistroDTOConverter registroDTOConverter;

    private Boolean validaRegistroServidorExterno() {
        return !StringUtils.isEmpty((String)this.urlBlueMix);
    }

    @Autowired(required=true)
    public ValidaRegistroServiceImpl(EntidadeService entidadeService, RegistroDomainRepository registroRepository, LicenseClientRest licenseClientRest, RegistroDTOConverter registroDTOConverter, @Value(value="${elotech.licenca.url:}") String urlBlueMix) {
        this.entidadeService = entidadeService;
        this.registroRepository = registroRepository;
        this.urlBlueMix = urlBlueMix;
        this.licenseClientRest = licenseClientRest;
        this.registroDTOConverter = registroDTOConverter;
    }

    public Boolean isValid(String modulo, String nome) {
        Registro registro = null;
        Boolean result = false;
        registro = this.registroRepository.loadLastRegistro(modulo, nome);
        if (Objects.nonNull(registro)) {
            result = this.isValid(this.registroDTOConverter.to(registro));
        }
        if (!result.booleanValue() && this.validaRegistroServidorExterno().booleanValue()) {
            result = this.isValidServiceLicenses(registro, modulo, nome);
        }
        return result;
    }

    private Boolean isValidServiceLicenses(Registro reg, String modulo, String nome) {
        Registro registro = reg;
        if (Objects.nonNull(registro)) {
            Boolean expirado = registro.getValidade().compareTo(LocalDate.now()) < 0;
            if (expirado.booleanValue()) {
                registro.setSituacao("E");
                this.registroRepository.save((Object)registro);
                registro = this.getRegistroServidor(registro.getModulo(), registro.getNome());
            }
        } else {
            registro = this.getRegistroServidor(modulo, nome);
        }
        if (Objects.nonNull(registro)) {
            return this.isValid(this.registroDTOConverter.to(registro));
        }
        return false;
    }

    private Registro getRegistroServidor(String modulo, String nome) {
        Optional license = this.licenseClientRest.getLicense(modulo, nome);
        if (license.isPresent()) {
            Registro registro = new Registro();
            EntidadeInfo entidade = this.entidadeService.findEntidadePrincipal();
            registro.setModulo(modulo);
            registro.setNome(nome);
            registro.setValidade(((License)license.get()).getDate());
            registro.setEntidade(entidade.getId());
            registro.setCodigo(((License)license.get()).getCode());
            registro.setSenha(((License)license.get()).getPassword());
            registro.setDataLiberacao(LocalDate.now());
            registro.setSituacao("R");
            String hash = EloCrypto.cifra((String)registro.getCalculatedHash());
            registro.setHash(hash);
            return (Registro)this.registroRepository.save((Object)registro);
        }
        return null;
    }

    public Boolean isValid(RegistroDTO registro) {
        if (Objects.isNull(registro) || !registro.isValid()) {
            return false;
        }
        return registro.getValidade().compareTo(LocalDate.now()) >= 0;
    }
}

