/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.edicaoemmassa;

import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioProfissional;
import br.com.elotech.tributos.dto.CamposEdicaoMassa;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.dto.edicaomassa.ValorProfissional;
import br.com.elotech.tributos.service.edicaoemmassa.EdicaoEmMassaMobiliarioService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EdicaoEmMassaMobiliarioService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EdicaoEmMassaMobiliarioService.class);

    public void handleChangeCadastro(EdicaoEmMassaFiltroDTO filtro, CadastroMobiliario cadastro) {
        Map profissionaisParaManter = filtro.getProfissionaisParaManter(cadastro.getId());
        filtro.getCamposValues().forEach(campoValor -> this.handleChangeCadastro(cadastro, campoValor, profissionaisParaManter));
    }

    private void handleChangeCadastro(CadastroMobiliario cadastro, CamposEdicaoMassa campoValor, Map<Long, List<Long>> profissionaisParaManter) {
        if (Objects.nonNull(campoValor.getCampo().getOrigemCampo())) {
            switch (1.$SwitchMap$br$com$elotech$tributos$enums$OrigemCampo[campoValor.getCampo().getOrigemCampo().ordinal()]) {
                case 1: {
                    this.prepareToSaveMobiliarioProfissionais(campoValor, cadastro, profissionaisParaManter);
                    break;
                }
                default: {
                    log.info("Origem do campo n\u00e3o encontrada, para o cadastro de id: {} e campo: {}", (Object)cadastro.getId(), (Object)campoValor.getCampo().getId());
                }
            }
        }
    }

    private void prepareToSaveMobiliarioProfissionais(CamposEdicaoMassa campoValor, CadastroMobiliario cadastro, Map<Long, List<Long>> profissionaisParaManter) {
        ValorProfissional valorEdicaoMassa = (ValorProfissional)campoValor.getValorEdicaoMassa();
        CadastroMobiliarioProfissional profissional = CadastroMobiliarioProfissional.from((CadastroMobiliario)cadastro, (Long)valorEdicaoMassa.getId(), (Long)valorEdicaoMassa.getCbo());
        cadastro.getCadastroMobiliarioProfissionais().forEach(p -> {
            if (p.dontExistIn(profissionaisParaManter)) {
                p.setToRemove(Boolean.TRUE);
            }
        });
        cadastro.getCadastroMobiliarioProfissionais().add(profissional);
        profissionaisParaManter.get(cadastro.getId()).add(profissional.getProfissional());
    }

    @Generated
    public EdicaoEmMassaMobiliarioService() {
    }
}

