/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento.peticao;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticao;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItem;
import br.com.elotech.tributos.domain.documento.peticao.LotePeticaoItemDetalhe;
import br.com.elotech.tributos.domain.documento.peticao.SituacaoLotePeticao;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.documento.peticao.CdaGeracaoPeticaoDTO;
import br.com.elotech.tributos.dto.documento.peticao.GeracaoLotePeticaoDTO;
import br.com.elotech.tributos.report.loader.PeticaoDividaAtivaParamLoader;
import br.com.elotech.tributos.repository.documento.peticao.LotePeticaoItemRepository;
import br.com.elotech.tributos.repository.documento.peticao.LotePeticaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ArquivoUnicoService;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.documento.peticao.LotePeticaoItemService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.tributos.util.UsuarioUtils;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import javax.transaction.Transactional;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class LotePeticaoService
extends CrudService<LotePeticao, Long> {
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final LotePeticaoItemRepository lotePeticaoItemRepository;
    private final Logger logger = LoggerFactory.getLogger(LotePeticaoService.class);
    private final TarefaAssincronaService tarefaAssincronaService;
    private final LotePeticaoItemService lotePeticaoItemService;
    private final DocumentoService documentoService;
    private final PeticaoDividaAtivaParamLoader peticaoDividaAtivaParamLoader;
    private final AiseRelatorioService aiseRelatorioService;
    private final ArquivoUnicoService arquivoUnicoService;
    private final ResolversHandler resolversHandler;
    private final LotePeticaoRepository lotePeticaoRepository;
    private final NotificacaoService notificacaoService;

    protected void beforeSave(LotePeticao entity, Authentication authentication) {
        super.beforeSave((EloEntity)entity, authentication);
        entity.setChildrenId();
    }

    public LotePeticao gerarSimulacao(GeracaoLotePeticaoDTO geracaoLotePeticaoDTO) {
        if (!geracaoLotePeticaoDTO.isValid().booleanValue()) {
            throw new EloValidationException("Filtros invalidos. Informe pelo menos um filtro");
        }
        if (!geracaoLotePeticaoDTO.isDateValid().booleanValue()) {
            throw new EloValidationException("Filtro de data inv\u00e1lido. Deve ser passado ou os dois valores ou nenhum.");
        }
        LotePeticao lotePeticao = new LotePeticao();
        lotePeticao.setDataSimulacao(LocalDate.now());
        lotePeticao.setFiltro(geracaoLotePeticaoDTO.filtro());
        lotePeticao.setAjuizarDebitos(geracaoLotePeticaoDTO.getAjuizarDebitos());
        lotePeticao.setUsuario(UsuarioUtils.getUsuarioAise());
        List itens = this.certidaoDividaAtivaService.findCdaGeracaoPeticao(geracaoLotePeticaoDTO);
        if (itens.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi encontrada nenhuma CDA com os filtros informados.");
        }
        lotePeticao.setSituacao(SituacaoLotePeticao.SIMULACAO_GERADA);
        lotePeticao.setAgruparPorContribuinte(geracaoLotePeticaoDTO.getAgruparPorContribuinte());
        lotePeticao.setItens(this.agruparItens(geracaoLotePeticaoDTO, itens));
        return (LotePeticao)this.save((EloEntity)lotePeticao, null);
    }

    private List<LotePeticaoItem> agruparItens(GeracaoLotePeticaoDTO geracaoLotePeticaoDTO, List<CdaGeracaoPeticaoDTO> cdas) {
        ArrayList<LotePeticaoItem> itensGerados = new ArrayList<LotePeticaoItem>();
        AtomicLong sequencia = new AtomicLong(1L);
        if (geracaoLotePeticaoDTO.getAgruparPorContribuinte().booleanValue()) {
            Map<Long, List<CdaGeracaoPeticaoDTO>> itensAgrupados = cdas.stream().collect(Collectors.groupingBy(CdaGeracaoPeticaoDTO::getPessoa));
            itensAgrupados.forEach((pessoaId, itensAgrupadosPorContribuinte) -> {
                LotePeticaoItem itemGerado = this.buildPeticaoItem(itensAgrupadosPorContribuinte);
                itemGerado.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
                itensGerados.add(itemGerado);
            });
        } else {
            List itensNaoAgrupados = cdas.stream().map(itemNaoAgrupado -> {
                LotePeticaoItem itemGerado = this.buildPeticaoItem(Collections.singletonList(itemNaoAgrupado));
                itemGerado.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
                return itemGerado;
            }).collect(Collectors.toList());
            itensGerados.addAll(itensNaoAgrupados);
        }
        return itensGerados;
    }

    private LotePeticaoItem buildPeticaoItem(List<CdaGeracaoPeticaoDTO> itens) {
        LotePeticaoItem lotePeticaoItem = new LotePeticaoItem();
        lotePeticaoItem.setDetalhes(itens.stream().map(item -> {
            LotePeticaoItemDetalhe lotePeticaoItemDetalhe = new LotePeticaoItemDetalhe();
            Documento documento = new Documento();
            documento.setId(item.getIdDocumento());
            lotePeticaoItemDetalhe.setDocumento(documento);
            return lotePeticaoItemDetalhe;
        }).collect(Collectors.toList()));
        return lotePeticaoItem;
    }

    public Page<LotePeticaoItem> searchItens(Long idLote, String search, Pageable pageable) {
        String idClause = String.format("lote.id==%d", idLote);
        String searchWithIdClause = search.isEmpty() ? idClause : String.format("(%s) and (%s)", idClause, search);
        Specification subQuerySpecification = RsqlUtils.createSpecFrom((EntityManager)this.getEm(), LotePeticaoItem.class, (String)searchWithIdClause);
        Specification & Serializable specification = (Specification & Serializable)(root, query, criteriaBuilder) -> {
            Subquery subquery = query.subquery(LotePeticaoItem.class);
            Root subQueryRoot = subquery.from(LotePeticaoItem.class);
            subquery.select((Expression)subQueryRoot).where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get("id"), (Expression)subQueryRoot.get("id")), (Expression)subQuerySpecification.toPredicate(subQueryRoot, query, criteriaBuilder)));
            return criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)root.get("lote").get("id"), (Object)idLote), (Expression)criteriaBuilder.exists(subquery));
        };
        return this.lotePeticaoItemRepository.findAll((Specification)specification, pageable);
    }

    public List<LotePeticaoItem> getItensValidos(Long idLotePeticao) {
        return this.lotePeticaoItemRepository.getItensValidos(idLotePeticao);
    }

    protected void beforeDelete(LotePeticao entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        if (!SituacaoLotePeticao.SIMULACAO_GERADA.equals((Object)entity.getSituacao())) {
            throw new EloValidationException(String.format("N\u00e3o \u00e9 permitido remover lote com situa\u00e7\u00e3o diferente de %s", SituacaoLotePeticao.SIMULACAO_GERADA.getDescricao()));
        }
    }

    @Async
    @Transactional
    public void printPeticaoLoteAgrupado(Long idLotePeticao, String search, Sort sort, Integer totalPeticoes) {
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaASsincronaImpressaoAgrupadaLotePeticao(idLotePeticao);
        Long tarefa = execucao.getTarefaAssincrona().getId();
        UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
        Optional notificacaoId = this.notificacaoService.send("Iniciando Gera\u00e7\u00e3o Peti\u00e7\u00f5es em Lote", String.format("Iniciando a gera\u00e7\u00e3o do PDF das Peti\u00e7\u00f5es em Lote %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        this.groupArquivosPeticao(idLotePeticao, search, sort, execucao, tarefa, totalPeticoes, userSecurityDTO, notificacaoId);
    }

    private void groupArquivosPeticao(Long idLote, String search, Sort sort, TarefaAssincronaExecucao execucao, Long tarefa, Integer totalPeticoes, UserSecurityDTO userSecurityDTO, Optional<UUID> notificacaoId) {
        LotePeticao lotePeticao = (LotePeticao)this.getEm().getReference(LotePeticao.class, (Object)idLote);
        if (Objects.isNull(lotePeticao)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o Lote de Peti\u00e7\u00f5es de id %d.", idLote));
        }
        try {
            this.logger.info("Iniciando agrupamento das Peti\u00e7\u00f5es");
            Page lotePeticaoItens = this.lotePeticaoItemService.getItensPeticaoLote(lotePeticao.getId(), search, sort, totalPeticoes);
            ArquivoNovoRequest arquivoNovoRequest = this.getArquivoNovoRequest(lotePeticao.getId(), lotePeticaoItens);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            lotePeticao.setIdArquivoImpressao(arquivo.getId());
            lotePeticao.setDataImpressao(arquivo.getDataCriacao().toLocalDate());
            lotePeticao.setUsuarioImpressao(SecurityUtils.getUserAise());
            this.lotePeticaoRepository.save((Object)lotePeticao);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Finalizada Gera\u00e7\u00e3o Peti\u00e7\u00f5es em Lote", String.format("Finalizada com sucesso a gera\u00e7\u00e3o das Peti\u00e7\u00f5es em Lote da tarefa %s.", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
            this.logger.info("Finalizada a gera\u00e7\u00e3o do arquivo de Peti\u00e7\u00f5es em Lote e disponibilizado no S3");
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            this.logger.error("Erro ao agrupar arquivos de Peti\u00e7\u00f5es {} ", (Object)e.getMessage(), (Object)e);
            this.notificacaoService.send("Finalizada Gera\u00e7\u00e3o Peti\u00e7\u00f5es em Lote", String.format("Ocorreu um erro na gera\u00e7\u00e3o do PDF de Peti\u00e7\u00f5es Agrupadas da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
        }
    }

    private ArquivoNovoRequest getArquivoNovoRequest(Long idLote, Page<LotePeticaoItem> lotePeticaoItens) throws IOException {
        InputStream inputStream = this.groupArquivoLotePeticao(lotePeticaoItens);
        return this.uploadArquivoAgrupado(idLote, inputStream);
    }

    private ArquivoNovoRequest uploadArquivoAgrupado(Long idLote, InputStream inputStream) {
        String nomeArquivo = String.format("Lote_Peticoes_Agrupadas_Numero_Lote_%d_%s", idLote, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
        return arquivoNovoRequest;
    }

    private InputStream groupArquivoLotePeticao(Page<LotePeticaoItem> lotePeticaoItens) throws IOException {
        PDDocument document = new PDDocument();
        for (LotePeticaoItem lotePeticaoItem : lotePeticaoItens) {
            PDFMergerUtility pdfMerge = new PDFMergerUtility();
            byte[] arquivoTemp = this.printPeticao(lotePeticaoItem.getDocumento().getId());
            PDDocument pdfDocument = PDDocument.load((byte[])arquivoTemp);
            pdfMerge.appendDocument(document, pdfDocument);
            pdfDocument.close();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save((OutputStream)byteArrayOutputStream);
        document.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public String getUrlArquivoLotePeticao(String idArquivo) {
        try {
            UUID uuid = UUID.fromString(idArquivo);
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + uuid));
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception ex) {
            throw new EloValidationException("Falha ao fazer o download do arquivo." + ex.getMessage());
        }
    }

    public byte[] printPeticao(Long id) {
        Documento documento = (Documento)this.documentoService.findOne((Serializable)id);
        if (Objects.isNull(documento.getIdArquivoUnico())) {
            ImprimirRelatorioDTO imprimirRelatorioDTO = this.buildImpressaoPeticao(documento);
            byte[] arquivo = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
            if (Objects.isNull(arquivo)) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O relat\u00f3rio est\u00e1 inv\u00e1lido");
            }
            return arquivo;
        }
        return this.arquivoUnicoService.baixarPDF(documento.getIdArquivoUnico());
    }

    public ImprimirRelatorioDTO buildImpressaoPeticao(Documento documento) {
        if (Objects.isNull(documento)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Documento de Peti\u00e7\u00e3o n\u00e3o encontrado");
        }
        Relatorio relatorio = documento.getDocumentoTipo().getRelatorio();
        if (Objects.isNull(relatorio)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Relat\u00f3rio n\u00e3o encontrado");
        }
        String filtro = String.format(" td.Exercicio = %d and td.Documento = %d ", documento.getExercicio(), documento.getDocumento());
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio.getId().getRelatorio());
        dto.setModulo(relatorio.getId().getModulo());
        dto.setTipoRelatorio(relatorio.getId().getTipoRelatorio());
        dto.setFiltro(filtro);
        dto.setListParametros(this.peticaoDividaAtivaParamLoader.load(documento.getExercicio()));
        dto.setListVariaveisAmbienteTela(String.format("TabelaCDADebito=%s%n", "tribdocumentoitemdividaativa"));
        dto.setSubReports(this.buildSubReports(filtro));
        return dto;
    }

    private SubReportDTO buildSubReports(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Certidao", filtro), new SubReportItemDTO("CertidaoProprietario", filtro)}));
        return subReportDTO;
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Generated
    public LotePeticaoService(CertidaoDividaAtivaService certidaoDividaAtivaService, LotePeticaoItemRepository lotePeticaoItemRepository, TarefaAssincronaService tarefaAssincronaService, LotePeticaoItemService lotePeticaoItemService, DocumentoService documentoService, PeticaoDividaAtivaParamLoader peticaoDividaAtivaParamLoader, AiseRelatorioService aiseRelatorioService, ArquivoUnicoService arquivoUnicoService, ResolversHandler resolversHandler, LotePeticaoRepository lotePeticaoRepository, NotificacaoService notificacaoService) {
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.lotePeticaoItemRepository = lotePeticaoItemRepository;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.lotePeticaoItemService = lotePeticaoItemService;
        this.documentoService = documentoService;
        this.peticaoDividaAtivaParamLoader = peticaoDividaAtivaParamLoader;
        this.aiseRelatorioService = aiseRelatorioService;
        this.arquivoUnicoService = arquivoUnicoService;
        this.resolversHandler = resolversHandler;
        this.lotePeticaoRepository = lotePeticaoRepository;
        this.notificacaoService = notificacaoService;
    }
}

