/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.procuradoria.client.feign.EnviaPeticaoProcuradoriaFeignClient;
import br.com.elotech.procuradoria.dto.CertidaoProcuradoriaDTO;
import br.com.elotech.procuradoria.dto.PeticaoProcuradoriaDTO;
import br.com.elotech.procuradoria.dto.PeticaoProcuradoriaRequestDTO;
import br.com.elotech.procuradoria.dto.PeticaoProcuradoriaResponseDTO;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.documento.peticao.LotePeticaoService;
import br.com.elotech.tributos.service.exception.EnvioArquivoProcuradoriaException;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnviarPeticaoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnviarPeticaoService.class);
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final LotePeticaoService lotePeticaoService;
    private final DocumentoService documentoService;
    private final ResolversHandler resolversHandler;
    private final Optional<EnviaPeticaoProcuradoriaFeignClient> enviaPeticaoProcuradoriaFeignClient;

    private void verificarQuantidadePeticoes(List<Long> idsPeticoes) {
        if (idsPeticoes == null || idsPeticoes.isEmpty()) {
            throw new EnvioArquivoProcuradoriaException("Peti\u00e7\u00f5es para envio n\u00e3o informadas");
        }
    }

    public Map<String, Object> enviarPeticoesProcuradoria(List<Long> idsPeticoes) {
        this.verificarQuantidadePeticoes(idsPeticoes);
        HashMap erros = new HashMap();
        ArrayList sucessos = new ArrayList();
        idsPeticoes.forEach(idPeticao -> {
            try {
                LOGGER.info("Agrupando peti\u00e7\u00e3o de ID: {}", idPeticao);
                Documento documento = this.agruparArquivoPeticaoLoteCda(idPeticao);
                sucessos.add(String.format("%s/%s", documento.getDocumento(), documento.getExercicio()));
                LOGGER.info("Peti\u00e7\u00e3o {} processada com sucesso", idPeticao);
            }
            catch (Exception e) {
                String mensagem = "Erro ao processar peti\u00e7\u00e3o: " + e.getMessage();
                LOGGER.error("Peti\u00e7\u00e3o {}: {} ({})", new Object[]{idPeticao, mensagem, e.getClass().getSimpleName(), e});
                Documento documento = this.getDocumento(idPeticao);
                erros.put(String.format("%s/%s", documento.getDocumento(), documento.getExercicio()), mensagem);
            }
        });
        LOGGER.info("Processamento de lote conclu\u00eddo. Total: {}, Sucesso: {}, Erro: {}", new Object[]{idsPeticoes.size(), sucessos.size(), erros.size()});
        return Map.of("erros", erros);
    }

    private Documento getDocumento(Long id) {
        return (Documento)this.documentoService.findOne((Serializable)id);
    }

    @Transactional(noRollbackFor={EnvioArquivoProcuradoriaException.class})
    public Documento agruparArquivoPeticaoLoteCda(Long idPeticao) throws IOException {
        if (this.enviaPeticaoProcuradoriaFeignClient.isEmpty()) {
            throw new EloValidationException("O client de envio de peti\u00e7\u00e3o do procuradoria n\u00e3o est\u00e1 disponivel no ambiente onpremise.");
        }
        PDDocument document = new PDDocument();
        Documento documento = (Documento)this.documentoService.findOne((Serializable)idPeticao);
        if (documento.getEnviadoProcuradoria().booleanValue()) {
            throw new EnvioArquivoProcuradoriaException(String.format("A Peti\u00e7\u00e3o do documento %d j\u00e1 foi enviado para Procuradoria!", idPeticao));
        }
        LOGGER.info("Iniciando impress\u00e3o do documento da Peti\u00e7\u00e3o: {}", (Object)idPeticao);
        byte[] peticaoInfo = this.lotePeticaoService.printPeticao(idPeticao);
        this.mergeInfoToDocument(document, peticaoInfo);
        LOGGER.info("Iniciando impress\u00e3o do documento das CDA da Peti\u00e7\u00e3o: {}", (Object)idPeticao);
        for (Documento documentoCda : documento.getCertidoesDividaAtivaPeticao()) {
            byte[] certidaoDividaAtivaInfo = this.certidaoDividaAtivaService.printCertidaoDividaAtiva(documentoCda.getId());
            this.mergeInfoToDocument(document, certidaoDividaAtivaInfo);
        }
        InputStream fileStream = this.saveDocument(document);
        ArquivoNovoRequest arquivoNovoRequest = this.createNewFileRequest(idPeticao, fileStream);
        LOGGER.info("Salvando arquivo agrupado no S3");
        Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
        PeticaoProcuradoriaRequestDTO peticaoProcuradoriaRequestDTO = this.createBodyRequestArquivoAgrupado(documento, arquivo);
        LOGGER.info("Enviando arquivo para o sistema de Procuradoria.");
        PeticaoProcuradoriaResponseDTO PeticaoProcuradoriaResponseDTO2 = ((EnviaPeticaoProcuradoriaFeignClient)this.enviaPeticaoProcuradoriaFeignClient.get()).saveArquivoPeticaoCdaAgrupado(peticaoProcuradoriaRequestDTO);
        if (Objects.nonNull(PeticaoProcuradoriaResponseDTO2) && Objects.nonNull(PeticaoProcuradoriaResponseDTO2.getIdPeticaoProcuradoria())) {
            documento.setEnviadoProcuradoria(Boolean.TRUE);
            documento.setDataEnvioProcuradoria(LocalDateTime.now());
            this.documentoService.save((EloEntity)documento, null);
        }
        return documento;
    }

    private PeticaoProcuradoriaRequestDTO createBodyRequestArquivoAgrupado(Documento documento, Arquivo arquivo) {
        PeticaoProcuradoriaDTO peticaoProcuradoriaDTO = new PeticaoProcuradoriaDTO();
        peticaoProcuradoriaDTO.setDocumento(documento.getDocumento());
        peticaoProcuradoriaDTO.setExercicio(documento.getExercicio());
        peticaoProcuradoriaDTO.setDataEmissao(documento.getDataEmissao());
        peticaoProcuradoriaDTO.setIdArquivoS3(arquivo.getId().toString());
        peticaoProcuradoriaDTO.setIdPessoaUnico(documento.getPessoa().getIdUnico());
        peticaoProcuradoriaDTO.setCertidaoDividaAtivaDTO(documento.getCertidoesDividaAtivaPeticao().stream().map(documentoCda -> {
            CertidaoProcuradoriaDTO certidaoProcuradoriaDTO = new CertidaoProcuradoriaDTO();
            certidaoProcuradoriaDTO.setDocumento(documentoCda.getDocumento());
            certidaoProcuradoriaDTO.setExercicio(documentoCda.getExercicio());
            certidaoProcuradoriaDTO.setDataEmissao(documentoCda.getDataEmissao());
            certidaoProcuradoriaDTO.setValor(this.getValorItemCdaTotal(documentoCda));
            certidaoProcuradoriaDTO.setTipoCadastro(documentoCda.getTipoCadastro().getValue());
            certidaoProcuradoriaDTO.setCadastroGeral(documentoCda.getCadastroGeral().getCadastroGeral());
            return certidaoProcuradoriaDTO;
        }).collect(Collectors.toList()));
        PeticaoProcuradoriaRequestDTO peticaoProcuradoriaRequestDTO = new PeticaoProcuradoriaRequestDTO();
        peticaoProcuradoriaRequestDTO.setPeticaoProcuradoriaDTO(peticaoProcuradoriaDTO);
        return peticaoProcuradoriaRequestDTO;
    }

    private void mergeInfoToDocument(PDDocument document, byte[] infoToAppendDocumento) throws IOException {
        PDFMergerUtility pdfMerge = new PDFMergerUtility();
        this.appendInfoToDocument(document, pdfMerge, infoToAppendDocumento);
    }

    private void appendInfoToDocument(PDDocument document, PDFMergerUtility pdfMerge, byte[] info) throws IOException {
        PDDocument pdfDocument = PDDocument.load((byte[])info);
        pdfMerge.appendDocument(document, pdfDocument);
        pdfDocument.close();
    }

    private InputStream saveDocument(PDDocument document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save((OutputStream)byteArrayOutputStream);
        document.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private ArquivoNovoRequest createNewFileRequest(Long idPeticao, InputStream inputStream) {
        String nomeArquivo = String.format("Peticao_CDA_Procuradoria_%d_%s", idPeticao, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
        return arquivoNovoRequest;
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    public BigDecimal getValorItemCdaTotal(Documento documentoCda) {
        return Optional.ofNullable(documentoCda.getDocumentoItemDividaAtivas()).map(documentoItemCda -> documentoItemCda.stream().map(DocumentoItemDividaAtiva::getTotal).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
    }

    @Generated
    public EnviarPeticaoService(CertidaoDividaAtivaService certidaoDividaAtivaService, LotePeticaoService lotePeticaoService, DocumentoService documentoService, ResolversHandler resolversHandler, Optional<EnviaPeticaoProcuradoriaFeignClient> enviaPeticaoProcuradoriaFeignClient) {
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.lotePeticaoService = lotePeticaoService;
        this.documentoService = documentoService;
        this.resolversHandler = resolversHandler;
        this.enviaPeticaoProcuradoriaFeignClient = enviaPeticaoProcuradoriaFeignClient;
    }
}

