/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoFindRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.response.ArquivoContent;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.Entidade;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoBloqueto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.ProtestoDTO;
import br.com.elotech.tributos.dto.SubReportDTO;
import br.com.elotech.tributos.dto.SubReportItemDTO;
import br.com.elotech.tributos.dto.documento.cda.AtualizaItensParcelasDTO;
import br.com.elotech.tributos.repository.EntidadeRepository;
import br.com.elotech.tributos.repository.ProtestoRemessaRepository;
import br.com.elotech.tributos.repository.ProtestoRepository;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoItemDividaAtivaService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.RelatorioService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import br.com.elotech.tributos.util.LongUtils;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class DocumentoProtestoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentoProtestoService.class);
    private final AiseRelatorioService aiseRelatorioService;
    private final EntidadeRepository entidadeRepository;
    private final ParametroGeralService parametroGeralService;
    private final RelatorioService relatorioService;
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final DocumentoItemDividaAtivaService documentoItemDividaAtivaService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final GeraBoletoService geraBoletoService;
    private final AisePdfService aisePdfService;
    private final ResolversHandler resolversHandler;
    private final ProtestoRepository protestoRepository;
    private final ProtestoRemessaRepository protestoRemessaRepository;
    private final ModeloBoletoService modeloBoletoService;
    private static final String PATH_TRIBUTOS_S3 = "oxy_tributos/%s";
    private static final String PARAM_FORMAT = "%s=%s%n";

    public UUID gerarTermoProtesto(Long idProtesto, LocalDate dataReferencia) throws IOException {
        Protesto protesto = (Protesto)this.protestoRepository.findById((Object)idProtesto).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o protesto com id %d", idProtesto)));
        ListasNecessariasCalculaAcrescimoDTO listas = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        PDDocument pdf = new PDDocument();
        this.mergePdfProtesto(pdf, protesto);
        this.mergePdfCda(pdf, protesto.getDocumento(), listas, dataReferencia);
        this.createBoletosAndMergePdf(protesto, pdf, dataReferencia);
        this.savePdfAndUploadArquivoS3(pdf, protesto);
        this.protestoRepository.save((Object)protesto);
        return protesto.getIdTermoProtestoS3();
    }

    public void agruparDocumentoEnvioCRA(List<ProtestoDTO> protestosDTO) throws IOException {
        this.validateBeforeAgruparDocumentos(protestosDTO);
        ArrayList protestos = new ArrayList(this.protestoRepository.findAllById((Iterable)protestosDTO.stream().map(ProtestoDTO::getId).collect(Collectors.toList())));
        ListasNecessariasCalculaAcrescimoDTO listas = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        LocalDate dataReferencia = this.getUltimoDiaDoMes(LocalDate.now());
        for (Protesto protesto : protestos) {
            if (!Objects.isNull(protesto.getIdTermoProtestoS3())) continue;
            PDDocument pdf = new PDDocument();
            this.mergePdfProtesto(pdf, protesto);
            this.mergePdfCda(pdf, protesto.getDocumento(), listas, dataReferencia);
            this.createBoletosAndMergePdf(protesto, pdf, dataReferencia);
            this.savePdfAndUploadArquivoS3(pdf, protesto);
            this.protestoRepository.save((Object)protesto);
        }
    }

    public String downloadFileAllTermosByIdRemessa(Long idRemessa, LocalDate dataReferencia) throws IOException {
        List protestos = this.protestoRepository.findByIdRemessa(idRemessa);
        ListasNecessariasCalculaAcrescimoDTO listas = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        LocalDate dataReferenciaUtilizada = Objects.nonNull(dataReferencia) ? dataReferencia : this.getUltimoDiaDoMes(LocalDate.now());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)byteArrayOutputStream);){
            this.zipProtestos(protestos, listas, dataReferenciaUtilizada, zipOutputStream);
        }
        return this.saveZipAllTermosByRemessaS3(idRemessa, (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    private void zipProtestos(List<Protesto> protestos, ListasNecessariasCalculaAcrescimoDTO listas, LocalDate dataReferencia, ZipOutputStream zipOutputStream) throws IOException {
        for (Protesto protesto : protestos) {
            InputStream inputStream = this.createOrGetPdfToZipProtesto(protesto, listas, dataReferencia);
            byte[] bytes = inputStream.readAllBytes();
            String fileName = String.format("%d%d_%s_01.pdf", protesto.getDocumento().getDocumento(), protesto.getDocumento().getExercicio(), protesto.getDocumento().getPessoa().getCnpjCpf());
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipEntry.setSize(bytes.length);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(bytes);
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
            inputStream.close();
        }
    }

    private InputStream createOrGetPdfToZipProtesto(Protesto protesto, ListasNecessariasCalculaAcrescimoDTO listas, LocalDate dataReferencia) throws IOException {
        if (Objects.isNull(protesto.getIdTermoProtestoS3())) {
            return this.createNewTermoProtestoAndGetPdf(protesto, listas, dataReferencia);
        }
        return this.getArquivoAgrupadoProtesto(protesto.getIdTermoProtestoS3()).getContent();
    }

    private InputStream createNewTermoProtestoAndGetPdf(Protesto protesto, ListasNecessariasCalculaAcrescimoDTO listas, LocalDate dataReferencia) throws IOException {
        PDDocument pdf = new PDDocument();
        this.mergePdfProtesto(pdf, protesto);
        this.mergePdfCda(pdf, protesto.getDocumento(), listas, dataReferencia);
        this.createBoletosAndMergePdf(protesto, pdf, dataReferencia);
        return this.savePdfAndCreateFileOnS3(protesto, pdf);
    }

    private InputStream savePdfAndCreateFileOnS3(Protesto protesto, PDDocument pdf) throws IOException {
        ByteArrayInputStream inputStream;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            pdf.save((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream toSaveS3 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ArquivoNovoRequest arquivoNovoRequest = this.createNewFileRequest(protesto.getId(), (InputStream)toSaveS3);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            protesto.setIdTermoProtestoS3(arquivo.getId());
            this.protestoRepository.save((Object)protesto);
        }
        return inputStream;
    }

    public String getUrlAssinada(UUID idArquivo) {
        String fullPath = String.format(PATH_TRIBUTOS_S3, idArquivo);
        try {
            ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)fullPath);
            return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
        }
        catch (Exception exception) {
            log.error("Falha ao fazer o download do arquivo {}", (Object)fullPath);
            throw new EloValidationException("Falha ao fazer o download no arquivo.");
        }
    }

    private void validateBeforeAgruparDocumentos(List<ProtestoDTO> protestos) {
        if (Objects.isNull(protestos) || protestos.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi informado nenhum protesto para gerar os documentos");
        }
    }

    private String saveZipAllTermosByRemessaS3(Long idRemessa, InputStream zipInputStream) {
        String fileName = String.format("Protesto_Remessa_%d_%s", idRemessa, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        ArquivoNovoRequest arquivoNovoRequest = this.createNewFileTermosByRemessaRequest(fileName, zipInputStream);
        Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
        ProtestoRemessa remessa = (ProtestoRemessa)this.protestoRemessaRepository.findOne((Object)idRemessa);
        remessa.setIdAllTermosRemessaArquivoS3(arquivo.getId());
        this.protestoRemessaRepository.save((Object)remessa);
        return this.getUrlAssinada(remessa.getIdAllTermosRemessaArquivoS3());
    }

    private void mergePdfProtesto(PDDocument pdf, Protesto protesto) throws IOException {
        byte[] termoProtesto = this.printTermoProtesto(protesto.getDocumento());
        this.mergeInfoToDocument(pdf, termoProtesto);
    }

    private void mergePdfCda(PDDocument pdf, Documento cda, ListasNecessariasCalculaAcrescimoDTO listas, LocalDate dataReferencia) throws IOException {
        Documento updated = this.updateValoresCda(cda, listas, dataReferencia);
        byte[] certidaoDividaAtivaInfo = this.certidaoDividaAtivaService.printCertidaoDividaAtiva(updated);
        this.mergeInfoToDocument(pdf, certidaoDividaAtivaInfo);
    }

    private void createBoletosAndMergePdf(Protesto protesto, PDDocument pdf, LocalDate dataReferencia) throws IOException {
        List boletos = this.createBoletos(protesto, dataReferencia);
        if (Objects.isNull(boletos) || boletos.isEmpty()) {
            throw new EloValidationException("Erro ao gerar boleto");
        }
        for (Bloqueto boleto : boletos) {
            this.mergePdfBoleto(pdf, boleto);
            protesto.getProtestoBloquetos().add(ProtestoBloqueto.createProtestoBloqueto((Bloqueto)boleto, (Protesto)protesto));
        }
    }

    private void mergePdfBoleto(PDDocument pdf, Bloqueto boleto) throws IOException {
        byte[] infoBoleto;
        ImpressaoDTO impressaoDTO = ImpressaoDTO.from((String)this.aisePdfService.fetchBloquetoByExercicio(boleto.getBloqueto(), boleto.getExercicioBloqueto()));
        try (InputStream inputBoletoDoTermo = new URL(impressaoDTO.getUrl()).openStream();){
            infoBoleto = inputBoletoDoTermo.readAllBytes();
        }
        this.mergeInfoToDocument(pdf, infoBoleto);
    }

    private void savePdfAndUploadArquivoS3(PDDocument pdf, Protesto protesto) throws IOException {
        try (InputStream fileStream = this.saveDocument(pdf);){
            ArquivoNovoRequest arquivoNovoRequest = this.createNewFileRequest(protesto.getId(), fileStream);
            Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
            protesto.setIdTermoProtestoS3(arquivo.getId());
        }
    }

    public byte[] printTermoProtesto(Documento documento) {
        ImprimirRelatorioDTO imprimirRelatorioDTO = this.buildImpressaoTermoProtesto(documento);
        byte[] arquivo = this.aiseRelatorioService.imprimirRelatorioGenerico(imprimirRelatorioDTO);
        if (Objects.isNull(arquivo)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O relat\u00f3rio est\u00e1 inv\u00e1lido");
        }
        return arquivo;
    }

    private ArquivoContent getArquivoAgrupadoProtesto(UUID idArquivo) {
        String fullPath = String.format(PATH_TRIBUTOS_S3, idArquivo);
        try {
            ArquivoFindRequest arquivoFindRequest = ArquivoFindRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)fullPath);
            return (ArquivoContent)this.resolveArquivoClient().buscarArquivo(arquivoFindRequest).orElseThrow();
        }
        catch (Exception exception) {
            log.error("Falha ao fazer o download do arquivo {}", (Object)fullPath);
            throw new EloValidationException("Falha ao fazer o download no arquivo.");
        }
    }

    private Documento updateValoresCda(Documento documento, ListasNecessariasCalculaAcrescimoDTO listas, LocalDate dataReferencia) {
        Long id = documento.getId();
        AtualizaItensParcelasDTO atualizaItensParcelasDTO = AtualizaItensParcelasDTO.from((Documento)documento, (LocalDate)dataReferencia);
        return this.documentoItemDividaAtivaService.atualizaItensParcelas(id, atualizaItensParcelasDTO, listas);
    }

    private List<Bloqueto> createBoletos(Protesto protesto, LocalDate dataReferencia) {
        ModeloBoleto modeloBoleto = this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setDataReferencia(dataReferencia);
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE_WEB);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.AGRUPADO);
        geraBoletoDTO.setSomenteConstituidos(Boolean.FALSE);
        geraBoletoDTO.setDebitos(this.buildDebitoParcelaDTOS(protesto));
        geraBoletoDTO.setModeloBoleto(modeloBoleto);
        return this.geraBoletoService.geraBoleto(geraBoletoDTO);
    }

    private ImprimirRelatorioDTO buildImpressaoTermoProtesto(Documento documento) {
        if (Objects.isNull(documento)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Documento n\u00e3o encontrado");
        }
        Long relatorioTermoProtesto = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.RELATORIO_TERMO_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        String tipoRelatorioTermoProtesto = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_RELATORIO_TERMO_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (LongUtils.isNullOrZero((Long)relatorioTermoProtesto) || StringUtils.isEmpty((String)tipoRelatorioTermoProtesto)) {
            throw new EloValidationException("Relat\u00f3rio termo protesto e Tipo Relat\u00f3rio termo protesto n\u00e3o configurado");
        }
        Relatorio relatorio = (Relatorio)this.relatorioService.findOne((Serializable)RelatorioPK.from((String)ModuloEnum.MODULO_TRIBUTARIO.getValue(), (TipoRelatorio)TipoRelatorio.fromValue((String)tipoRelatorioTermoProtesto), (Integer)relatorioTermoProtesto.intValue()));
        if (Objects.isNull(relatorio)) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND, "Relat\u00f3rio n\u00e3o encontrado");
        }
        Entidade entidadeprincipal = this.entidadeRepository.findByEntidadeprincipal();
        String unidadeFederacaoDescr = this.entidadeRepository.findDescricaoUfEntidadeprincipal();
        String parametro = String.format(PARAM_FORMAT, "PNomeEntidade", entidadeprincipal.getNome()).concat(String.format(PARAM_FORMAT, "PExercicio", documento.getExercicio())).concat(String.format(PARAM_FORMAT, "PDescUF", unidadeFederacaoDescr)).concat(String.format(PARAM_FORMAT, "PCidade", this.getCidadeDescricao(entidadeprincipal.getCidade())));
        ImprimirRelatorioDTO dto = new ImprimirRelatorioDTO();
        dto.setRelatorio(relatorio.getId().getRelatorio());
        dto.setModulo(relatorio.getId().getModulo());
        dto.setTipoRelatorio(relatorio.getId().getTipoRelatorio());
        dto.setFiltro(String.format(" DOC.Exercicio = %d and DOC.Documento = %d and DOC.TipoDocumento = %d ", documento.getExercicio(), documento.getDocumento(), documento.getTipoDocumento()));
        dto.setSubReports(this.createSubReportDTO(dto.getFiltro()));
        dto.setListParametros(parametro);
        return dto;
    }

    private String getCidadeDescricao(Cidade cidade) {
        if (Optional.ofNullable(cidade).isEmpty()) {
            return "";
        }
        return cidade.getDescricao();
    }

    private SubReportDTO createSubReportDTO(String filtro) {
        SubReportDTO subReportDTO = new SubReportDTO();
        subReportDTO.setItems((Set)Sets.newHashSet((Object[])new SubReportItemDTO[]{new SubReportItemDTO("Cabecalho", ""), new SubReportItemDTO("ProtestoTermo", filtro), new SubReportItemDTO("ProtestoProprietario", filtro)}));
        return subReportDTO;
    }

    private void mergeInfoToDocument(PDDocument document, byte[] infoToAppendDocumento) throws IOException {
        try {
            PDFMergerUtility pdfMerge = new PDFMergerUtility();
            this.appendInfoToDocument(document, pdfMerge, infoToAppendDocumento);
        }
        catch (Exception ex) {
            throw new IOException(String.format("Erro ao juntar documentos. %s", ex.getMessage()));
        }
    }

    private void appendInfoToDocument(PDDocument document, PDFMergerUtility pdfMerge, byte[] info) throws IOException {
        PDDocument pdfDocument = PDDocument.load((byte[])info);
        pdfMerge.appendDocument(document, pdfDocument);
        pdfDocument.close();
    }

    private LocalDate getUltimoDiaDoMes(LocalDate data) {
        YearMonth yearMonth = YearMonth.from(data);
        int ultimoDia = yearMonth.lengthOfMonth();
        return data.withDayOfMonth(ultimoDia);
    }

    private List<DebitoParcelaDTO> buildDebitoParcelaDTOS(Protesto protesto) {
        return protesto.getDocumento().getDocumentoItemDividaAtivas().stream().map(dida -> DebitoParcelaDTO.from((Long)dida.getDebito().getId(), (Long)dida.getParcela())).distinct().collect(Collectors.toList());
    }

    private InputStream saveDocument(PDDocument document) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            document.save((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            return byteArrayInputStream;
        }
    }

    private ArquivoNovoRequest createNewFileRequest(Long idProtesto, InputStream inputStream) {
        String nomeArquivo = String.format("Protesto_CDA_CRA_%d_%s", idProtesto, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmm")));
        return ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
    }

    private ArquivoNovoRequest createNewFileTermosByRemessaRequest(String fileName, InputStream inputStream) {
        return ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(fileName).content(inputStream).contentType(ContentType.APPLICATION_ZIP).build();
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Generated
    public DocumentoProtestoService(AiseRelatorioService aiseRelatorioService, EntidadeRepository entidadeRepository, ParametroGeralService parametroGeralService, RelatorioService relatorioService, CertidaoDividaAtivaService certidaoDividaAtivaService, DocumentoItemDividaAtivaService documentoItemDividaAtivaService, CalculoAcrescimoService calculoAcrescimoService, GeraBoletoService geraBoletoService, AisePdfService aisePdfService, ResolversHandler resolversHandler, ProtestoRepository protestoRepository, ProtestoRemessaRepository protestoRemessaRepository, ModeloBoletoService modeloBoletoService) {
        this.aiseRelatorioService = aiseRelatorioService;
        this.entidadeRepository = entidadeRepository;
        this.parametroGeralService = parametroGeralService;
        this.relatorioService = relatorioService;
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.documentoItemDividaAtivaService = documentoItemDividaAtivaService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.geraBoletoService = geraBoletoService;
        this.aisePdfService = aisePdfService;
        this.resolversHandler = resolversHandler;
        this.protestoRepository = protestoRepository;
        this.protestoRemessaRepository = protestoRemessaRepository;
        this.modeloBoletoService = modeloBoletoService;
    }
}

