/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.documento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.DocumentoGenericoDTO;
import br.com.elotech.tributos.dto.DocumentoSearchInitialValuesDTO;
import br.com.elotech.tributos.dto.GeracaoDocumentoDTO;
import br.com.elotech.tributos.repository.CadastroGeralIsencaoRepository;
import br.com.elotech.tributos.repository.CadastroGeralRepository;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.GeraDocumentoService;
import br.com.elotech.tributos.service.PessoaService;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.stereotype.Service;

@Service
public class CertidaoIsencaoService {
    private final CadastroGeralIsencaoRepository cadastroGeralIsencaoRepository;
    private final CadastroGeralRepository cadastroGeralRepository;
    private final PessoaService pessoaService;
    private final GeraDocumentoService geraDocumentoService;
    private final DocumentoService documentoService;

    public CertidaoIsencaoService(CadastroGeralIsencaoRepository cadastroGeralIsencaoRepository, CadastroGeralRepository cadastroGeralRepository, PessoaService pessoaService, GeraDocumentoService geraDocumentoService, DocumentoService documentoService) {
        this.cadastroGeralIsencaoRepository = cadastroGeralIsencaoRepository;
        this.cadastroGeralRepository = cadastroGeralRepository;
        this.pessoaService = pessoaService;
        this.geraDocumentoService = geraDocumentoService;
        this.documentoService = documentoService;
    }

    public DocumentoDTO save(@Valid DocumentoGenericoDTO documentoGenericoDTO) {
        GeracaoDocumentoDTO geracaoDocumentoDTO = this.getGeracaoDocumentoDTO(documentoGenericoDTO, TipoDocumentoEnum.CERTIDAO_ISENCAO);
        Boolean isencoes = this.cadastroGeralIsencaoRepository.findIsencaoByTipoCadastroAndCadastroGeral(geracaoDocumentoDTO.getCadastroGeral().getTipoCadastro(), geracaoDocumentoDTO.getCadastroGeral().getCadastroGeral(), Long.valueOf(LocalDate.now().getYear()));
        if (!isencoes.booleanValue()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel gerar certid\u00e3o de isen\u00e7\u00e3o, n\u00e3o existe isen\u00e7ao vinculada a esse cadastro");
        }
        Documento documento = this.geraDocumentoService.getDocumentoAndValida(geracaoDocumentoDTO);
        return DocumentoDTO.from((Documento)((Documento)this.documentoService.save((EloEntity)documento, null)));
    }

    private GeracaoDocumentoDTO getGeracaoDocumentoDTO(@Valid DocumentoGenericoDTO documentoGenericoDTO, TipoDocumentoEnum tipoDocumento) {
        if (documentoGenericoDTO.getPorCadastro().booleanValue()) {
            if (Objects.isNull(documentoGenericoDTO.getIdCadastro())) {
                throw new EloValidationException("Cadastro Geral \u00e9 obrigat\u00f3rio");
            }
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralRepository.findById((Object)documentoGenericoDTO.getIdCadastro()).orElseThrow(() -> new EloValidationException(String.format("Cadastro Geral %d n\u00e3o encontrado", documentoGenericoDTO.getIdCadastro())));
            return GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (CadastroGeral)cadastroGeral, (TipoDocumentoEnum)tipoDocumento);
        }
        if (Objects.isNull(documentoGenericoDTO.getCodigoPessoa())) {
            throw new EloValidationException("C\u00f3digo da pessoa \u00e9 obrigat\u00f3rio");
        }
        Pessoa pessoa = (Pessoa)this.pessoaService.findById(documentoGenericoDTO.getCodigoPessoa()).orElseThrow(() -> new EloValidationException(String.format("Pessoa %d n\u00e3o encontrada", documentoGenericoDTO.getCodigoPessoa())));
        return GeracaoDocumentoDTO.from((DocumentoGenericoDTO)documentoGenericoDTO, (Pessoa)pessoa, (TipoDocumentoEnum)tipoDocumento);
    }

    public DocumentoGenericoDTO getInitialValues(DocumentoSearchInitialValuesDTO documentoSearchInitialValuesDTO) {
        return this.documentoService.getInitialValues(documentoSearchInitialValuesDTO, TipoDocumentoEnum.CERTIDAO_ISENCAO);
    }
}

