/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.contribuicaomelhoria;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.contribuicaomelhoria.MelhoriaEdital;
import br.com.elotech.tributos.domain.contribuicaomelhoria.id.MelhoriaEditalId;
import br.com.elotech.tributos.dto.contribuicaomelhoria.MelhoriaCadastroDTO;
import br.com.elotech.tributos.dto.contribuicaomelhoria.MelhoriaCadastroRequest;
import br.com.elotech.tributos.repository.contribuicaomelhoria.MelhoriaCadastroRepository;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class MelhoriaEditalService
extends CrudService<MelhoriaEdital, MelhoriaEditalId> {
    private final MelhoriaCadastroRepository melhoriaCadastroRepository;

    public Page<MelhoriaCadastroDTO> findCadastros(MelhoriaCadastroRequest request, Pageable pageable) {
        this.validateSeTemFiltros(request);
        return this.melhoriaCadastroRepository.findCadastros(request, pageable);
    }

    public void saveCadastros(MelhoriaCadastroRequest request) {
        this.validateSeTemFiltros(request);
        this.melhoriaCadastroRepository.saveCadastros(request);
    }

    private void validateSeTemFiltros(MelhoriaCadastroRequest request) {
        if (Objects.isNull(request.getFiltrosCamposDinamicos()) || request.getFiltrosCamposDinamicos().isEmpty()) {
            throw new RestException(HttpStatus.BAD_REQUEST, "\u00c9 necess\u00e1rio ao menos um filtro selecionado");
        }
    }

    @Generated
    public MelhoriaEditalService(MelhoriaCadastroRepository melhoriaCadastroRepository) {
        this.melhoriaCadastroRepository = melhoriaCadastroRepository;
    }
}

