/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.cancelamento.validacancelamentodebito.implementacoes;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.TipoDeducaoEnum;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.cancelamento.CancelamentoTributosFormDTO;
import br.com.elotech.tributos.service.cancelamento.validacancelamentodebito.ValidaCancelamentoPorEstado;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ValidaCancelamentoDebitoRondonia
implements ValidaCancelamentoPorEstado {
    public Boolean accept(String estado) {
        return estado.equals("RO");
    }

    public void validate(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        this.lancaExcessaoCasoForCancelamentoAndExercicio(cancelamentoTributosFormDTO);
        this.lancaExcessaoCasoForFiltroTodos(cancelamentoTributosFormDTO);
    }

    private void lancaExcessaoCasoForCancelamentoAndExercicio(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        Boolean isCancelamento = cancelamentoTributosFormDTO.getTipoDeducao().getId().equals(TipoDeducaoEnum.CANCELAMENTO.getValue());
        Boolean isNoExercicio = cancelamentoTributosFormDTO.getSituacaoLegal().equals(SituacaoLegal.NO_EXERCICIO.getCodigo());
        if (isCancelamento.booleanValue() && isNoExercicio.booleanValue()) {
            throw new EloValidationException("Cancelamento n\u00e3o permitido, d\u00e9bitos em Exerc\u00edcio n\u00e3o podem ser cancelados, apenas estornados.");
        }
    }

    private void lancaExcessaoCasoForFiltroTodos(CancelamentoTributosFormDTO cancelamentoTributosFormDTO) {
        Boolean existeSituacaoLegalDiferente = this.existeSituacaoLegalDiferenteEntreDebitos(cancelamentoTributosFormDTO.getParcelas());
        Boolean isCancelamento = cancelamentoTributosFormDTO.getTipoDeducao().getId().equals(TipoDeducaoEnum.CANCELAMENTO.getValue());
        if (!existeSituacaoLegalDiferente.booleanValue()) {
            boolean isExercicio = ((CancelamentoDebitoTributoDTO)cancelamentoTributosFormDTO.getParcelas().get(0)).getSituacaoLegal().equals((Object)SituacaoLegal.NO_EXERCICIO);
            if (isCancelamento.booleanValue() && isExercicio) {
                throw new EloValidationException("N\u00e3o \u00e9 permitido cancelamento de parcelas no exerc\u00edcio.");
            }
        }
    }

    public Boolean existeSituacaoLegalDiferenteEntreDebitos(List<CancelamentoDebitoTributoDTO> debitos) {
        CancelamentoDebitoTributoDTO primeiroDebito = debitos.get(0);
        return debitos.stream().anyMatch(debito -> !debito.getSituacaoLegal().equals((Object)primeiroDebito.getSituacaoLegal()));
    }
}

