/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.camposdinamicos;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.extractor.AttributeGetterResult;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.dto.CampoEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.CampoEdicaoEmMassaImobiliario;
import br.com.elotech.tributos.dto.CampoEdicaoEmMassaMobiliario;
import br.com.elotech.tributos.enums.TipoEdicaoEmMassa;
import br.com.elotech.tributos.util.AutoCompleteFieldTypeUtils;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Primary
public class CampoService
extends CrudService<Campo, Long> {
    public Page<CampoEdicaoEmMassaDTO> findAllCamposEdicaoEmMassa(String search, Pageable pageable, TipoEdicaoEmMassa tipo) {
        List campos = this.getCampos(search, pageable, tipo);
        return new PageImpl(campos, pageable, (long)campos.size());
    }

    private List<CampoEdicaoEmMassaDTO> getCampos(String search, Pageable pageable, TipoEdicaoEmMassa tipo) {
        List campos;
        if (TipoEdicaoEmMassa.MOBILIARIO.equals((Object)tipo)) {
            campos = AutoCompleteFieldTypeUtils.getCamposFromAnnotation(CampoEdicaoEmMassaMobiliario.class);
        } else {
            campos = this.findByRsql(search, pageable).getContent().stream().map(CampoEdicaoEmMassaDTO::campoEdicaoEmMassaDTO).collect(Collectors.toList());
            campos.addAll(AutoCompleteFieldTypeUtils.getCamposFromAnnotation(CampoEdicaoEmMassaImobiliario.class));
        }
        if (StringUtils.isNotBlank((CharSequence)search)) {
            String descricao = RsqlUtils.getFieldValues((String)search, (String)"descricao").stream().findFirst().map(AttributeGetterResult::getValue).map(s -> s.replace("*", "")).orElse("");
            return campos.stream().filter(item -> item.getIdentificador().toLowerCase().contains(descricao.toLowerCase()) || item.getDescricao().toLowerCase().contains(descricao.toLowerCase())).collect(Collectors.toList());
        }
        return campos;
    }

    @Generated
    public CampoService() {
    }
}

