/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.simam;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.enums.TipoRegistroSimAm;
import br.com.elotech.tributos.service.batch.simam.AtribuirNrCreditoNrDividaJobStarter;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class AtribuirNrCreditoNrDividaJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    @Qualifier(value="ajusteNrCreditoNrDividaBatchJob")
    private final Job ajusteNrCreditoNrDividaBatchJob;
    private static final String DATA_INICIAL = "dataInicial";
    private static final String DATA_FINAL = "dataFinal";
    private static final String TIPO_ARQUIVO_SIMAM = "tipo";

    public JobExecution start(LocalDate dataInicial, LocalDate dataFinal, TipoRegistroSimAm tipoRegistroSimAm) {
        this.validaSeExisteJobNaoFinalizado(dataInicial, dataFinal, tipoRegistroSimAm);
        this.validaTipoRegistroPermitido(tipoRegistroSimAm);
        return this.run(this.ajusteNrCreditoNrDividaBatchJob, this.mountJobParameters(dataInicial, dataFinal, tipoRegistroSimAm));
    }

    private void validaTipoRegistroPermitido(TipoRegistroSimAm tipoRegistroSimAm) {
        if (tipoRegistroSimAm != null && !this.isTipoPermitido(tipoRegistroSimAm)) {
            throw new RestException(HttpStatus.BAD_REQUEST, "Tipo de arquivo n\u00e3o suportado para verifica\u00e7\u00e3o inicial.");
        }
    }

    private void validaSeExisteJobNaoFinalizado(LocalDate dataInicial, LocalDate dataFinal, TipoRegistroSimAm tipoRegistroSimAm) {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.ATRIBUIR_NRCREDITO_NRDIVIDA_ARQUIVOS_SIMAM.getTipo()).stream().anyMatch(jobExecution -> {
            JobParameters parameters = jobExecution.getJobParameters();
            LocalDate paramDataInicial = this.toLocalDate(parameters.getDate(DATA_INICIAL));
            LocalDate paramDataFinal = this.toLocalDate(parameters.getDate(DATA_FINAL));
            Long paramTipoRegistroSimAMCode = parameters.getLong(TIPO_ARQUIVO_SIMAM);
            TipoRegistroSimAm paramTipoRegistroSimAM = tipoRegistroSimAm != null && paramTipoRegistroSimAMCode != null ? TipoRegistroSimAm.getByCodigo((Long)paramTipoRegistroSimAMCode) : null;
            return Objects.equals(paramDataInicial, dataInicial) && Objects.equals(paramDataFinal, dataFinal) && (paramTipoRegistroSimAM == null || tipoRegistroSimAm != null && Objects.equals(paramTipoRegistroSimAM, tipoRegistroSimAm));
        });
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe uma execu\u00e7\u00e3o do job com os mesmos par\u00e2metros em andamento.");
        }
    }

    private JobParameters mountJobParameters(LocalDate dataInicial, LocalDate dataFinal, TipoRegistroSimAm tipoRegistroSimAm) {
        JobParametersBuilder builder = new JobParametersBuilder();
        builder.addDate(DATA_INICIAL, this.toDate(dataInicial));
        builder.addDate(DATA_FINAL, this.toDate(dataFinal));
        builder.addDate("dataReferencia", new Date());
        if (tipoRegistroSimAm != null) {
            builder.addLong(TIPO_ARQUIVO_SIMAM, tipoRegistroSimAm.getCodigo());
        }
        return builder.toJobParameters();
    }

    private JobExecution run(Job job, JobParameters jobParameters) {
        try {
            return this.jobLauncher.run(job, jobParameters);
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new RuntimeException("J\u00e1 existe uma job finalizado com esses par\u00e2metros", e);
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new RuntimeException("J\u00e1 existe uma job rodando com esses par\u00e2metros", e);
        }
        catch (JobParametersInvalidException e) {
            throw new RuntimeException("Par\u00e2metros inv\u00e1lidos", e);
        }
        catch (JobRestartException e) {
            throw new RuntimeException("Problemas ao reiniciar o job", e);
        }
    }

    private boolean isTipoPermitido(TipoRegistroSimAm tipoRegistroSimAm) {
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$TipoRegistroSimAm[tipoRegistroSimAm.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    private LocalDate toLocalDate(Date date) {
        return DateUtils.dateToLocalDate((Date)Objects.requireNonNull(date));
    }

    private Date toDate(LocalDate localDate) {
        return DateUtils.localDateToDate((LocalDate)Objects.requireNonNull(localDate));
    }

    @Generated
    public AtribuirNrCreditoNrDividaJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, Job ajusteNrCreditoNrDividaBatchJob) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.ajusteNrCreditoNrDividaBatchJob = ajusteNrCreditoNrDividaBatchJob;
    }
}

