/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.debitoautomatico;

import br.com.elotech.tributos.dto.debitoautomatico.RemessaDebitoAutomaticoFilterDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RemessaArquivoDebitoAutomaticoJobStarter {
    private final JobLauncher jobLauncher;
    private final Job remessaArquivoDebitoAutomaticoBatchJob;
    private final ObjectMapper objectMapper;

    public RemessaArquivoDebitoAutomaticoJobStarter(JobLauncher jobLauncher, @Qualifier(value="remessaArquivoDebitoAutomaticoBatchJob") Job remessaArquivoDebitoAutomaticoBatchJob, ObjectMapper objectMapper) {
        this.jobLauncher = jobLauncher;
        this.remessaArquivoDebitoAutomaticoBatchJob = remessaArquivoDebitoAutomaticoBatchJob;
        this.objectMapper = objectMapper;
    }

    public JobExecution startJob(Long idRemessa, RemessaDebitoAutomaticoFilterDTO filtro) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idRemessa", idRemessa);
        jobParametersBuilder.addString("filtro", this.objectMapper.writeValueAsString((Object)filtro));
        jobParametersBuilder.addDate("date", new Date());
        return this.jobLauncher.run(this.remessaArquivoDebitoAutomaticoBatchJob, jobParametersBuilder.toJobParameters());
    }
}

