/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.comunicado;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDateTime;
import java.util.Objects;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ValidacaoEnderecoJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job validacaoEnderecoBatchJob;

    public ValidacaoEnderecoJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="validacaoEnderecoBatchJob") Job validacaoEnderecoBatchJob) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.validacaoEnderecoBatchJob = validacaoEnderecoBatchJob;
    }

    public JobExecution startjob(Long entidade, Long exercicio, Long idComunicado, LocalDateTime dataAtual) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.COMUNICADO_VALIDACAO_ENDERECOS.getTipo()).stream().anyMatch(job -> entidade.equals(Objects.requireNonNull(job.getJobParameters().getLong("entidade"))) && exercicio.equals(Objects.requireNonNull(job.getJobParameters().getLong("exercicio"))) && idComunicado.equals(Objects.requireNonNull(job.getJobParameters().getLong("idComunicado"))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addLong("exercicio", exercicio);
        jobParametersBuilder.addLong("idComunicado", idComunicado);
        jobParametersBuilder.addDate("dataAtual", DateUtils.localDateTimeToDate((LocalDateTime)dataAtual));
        return this.jobLauncher.run(this.validacaoEnderecoBatchJob, jobParametersBuilder.toJobParameters());
    }
}

