/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.cda;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.documento.cda.GeracaoLoteCdaDTO;
import br.com.elotech.tributos.service.ContextService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import lombok.Generated;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SimulacaoLoteCdaJobStarter {
    private static final String ID_LOTE = "idLote";
    private static final String ENTIDADE = "entidade";
    private static final String GERACAO_LOTE_CDA_DTO = "geracaoLoteCdaDto";
    private static final String DATA = "data";
    @Qualifier(value="simulacaoLoteCdaBatchJob")
    private final Job simulacaoLoteCdaBatchJob;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final ContextService contextService;
    private final ObjectMapper objectMapper;

    public JobExecution startJob(Long idLote, GeracaoLoteCdaDTO geracaoLoteCdaDTO) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        this.validateJobWithSameIdLote(idLote);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong(ID_LOTE, idLote);
        jobParametersBuilder.addLong(ENTIDADE, this.contextService.getEntidadePrincipal());
        jobParametersBuilder.addString(GERACAO_LOTE_CDA_DTO, this.objectMapper.writeValueAsString((Object)geracaoLoteCdaDTO));
        jobParametersBuilder.addDate(DATA, new Date());
        return this.jobLauncher.run(this.simulacaoLoteCdaBatchJob, jobParametersBuilder.toJobParameters());
    }

    private void validateJobWithSameIdLote(Long idLote) {
        boolean hasJob = this.jobExplorer.findRunningJobExecutions(JobType.SIMULACAO_LOTE_CDA.getTipo()).stream().anyMatch(jobExecution -> idLote.equals(jobExecution.getJobParameters().getLong(ID_LOTE)));
        if (hasJob) {
            throw new EloValidationException(String.format("A simula\u00e7\u00e3o do lote de CDA %d j\u00e1 est\u00e1 em processamento.", idLote));
        }
    }

    @Generated
    public SimulacaoLoteCdaJobStarter(Job simulacaoLoteCdaBatchJob, JobLauncher jobLauncher, JobExplorer jobExplorer, ContextService contextService, ObjectMapper objectMapper) {
        this.simulacaoLoteCdaBatchJob = simulacaoLoteCdaBatchJob;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.contextService = contextService;
        this.objectMapper = objectMapper;
    }
}

