/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.cda;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.documento.cda.LoteCda;
import br.com.elotech.tributos.service.documento.cda.LoteCdaService;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class GeracaoProtestoLoteCdaJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    @Qualifier(value="geracaoProtestoLoteCdaBatchJob")
    private final Job geracaoProtestoLoteCdaBatchJob;
    private final LoteCdaService loteCdaService;

    public JobExecution startJob(Long idLote) {
        this.validaSeExisteJobNaoFinalizadoComMesmoFiltro(idLote);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        LoteCda loteCda = this.loteCdaService.getToGeracaoProtesto(idLote);
        jobParametersBuilder.addLong("idLote", loteCda.getId());
        jobParametersBuilder.addDate("data", new Date());
        try {
            return this.jobLauncher.run(this.geracaoProtestoLoteCdaBatchJob, jobParametersBuilder.toJobParameters());
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new EloValidationException("Job Gera\u00e7\u00e3o Protesto j\u00e1 est\u00e1 sendo executado");
        }
        catch (JobRestartException e) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel reiniciar o Job Gera\u00e7\u00e3o Protesto");
        }
        catch (JobParametersInvalidException e) {
            throw new EloValidationException("Par\u00e2metros para o Job Gera\u00e7\u00e3o Protesto est\u00e1 inv\u00e1lido. Verifique!");
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel reinicicar o Job Gera\u00e7\u00e3o Protesto, pois foi conclu\u00eddo com sucesso");
        }
    }

    private void validaSeExisteJobNaoFinalizadoComMesmoFiltro(Long idLote) {
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.GERACAO_PROTESTO_LOTE_CDA.getTipo()).stream().anyMatch(job -> idLote.equals(Objects.requireNonNull(job.getJobParameters().getLong("idLote"))));
        if (Boolean.TRUE.equals(existeJobNaoFinalizadoComMesmoFiltro)) {
            throw new EloValidationException("J\u00e1 existe um job com estes par\u00e2metros.");
        }
    }

    @Generated
    public GeracaoProtestoLoteCdaJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, Job geracaoProtestoLoteCdaBatchJob, LoteCdaService loteCdaService) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.geracaoProtestoLoteCdaBatchJob = geracaoProtestoLoteCdaBatchJob;
        this.loteCdaService = loteCdaService;
    }
}

