/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch.atualizacaomonetariaparcelamento;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.parcelamento.AtualizacaoMonetaria;
import br.com.elotech.tributos.domain.parcelamento.TipoAtualizacaoMonetaria;
import br.com.elotech.tributos.dto.atualizacaomonetariaparcelamento.AtualizacaoMonetariaParcelamentoParams;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.AtualizacaoMonetariaService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class AtualizacaoMonetariaParcelamentoJobStarter {
    private final JobLauncher jobLauncher;
    private final Job job;
    private final ObjectMapper objectMapper;
    private final JobExplorer jobExplorer;
    private final ParametroGeralService parametroGeralService;
    private final AtualizacaoMonetariaService atualizacaoMonetariaService;

    public AtualizacaoMonetariaParcelamentoJobStarter(JobLauncher jobLauncher, @Qualifier(value="AtualizacaoMonetariaParcelamentoBatchJob") Job job, ObjectMapper objectMapper, JobExplorer jobExplorer, ParametroGeralService parametroGeralService, AtualizacaoMonetariaService atualizacaoMonetariaService) {
        this.jobLauncher = jobLauncher;
        this.job = job;
        this.objectMapper = objectMapper;
        this.jobExplorer = jobExplorer;
        this.parametroGeralService = parametroGeralService;
        this.atualizacaoMonetariaService = atualizacaoMonetariaService;
    }

    public JobExecution startJob(AtualizacaoMonetariaParcelamentoParams params) throws Exception {
        TipoAtualizacaoMonetaria tipo = Optional.ofNullable(this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.ATUALIZACAO_TIPO_REAJUSTE, ModuloEnum.MODULO_TRIBUTARIO.getValue())).map(TipoAtualizacaoMonetaria::fromValue).orElse(TipoAtualizacaoMonetaria.MENSAL);
        if (!TipoAtualizacaoMonetaria.MENSAL.equals((Object)tipo)) {
            throw new EloValidationException("Essa rotina s\u00f3 pode ser utilizada se o parametro ATUALIZACAOTIPOREAJUSTE for MENSAL");
        }
        params.setTipo(tipo);
        if (this.isJobRunning(params)) {
            throw new EloValidationException(String.format("Um job de atualiza\u00e7\u00e3o monet\u00e1ria j\u00e1 est\u00e1 em execu\u00e7\u00e3o para os parametros %s", this.buildIdentifier(params)));
        }
        Boolean permiteAtualizacaoMonetariaMensal = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.PERMITE_ATUALIZACAO_MONETARIA_MENSAL);
        if (!permiteAtualizacaoMonetariaMensal.booleanValue() && this.atualizacaoMonetariaService.existsAtualizacaoRealizadaNoMes(params.getEntidade(), params.getExercicio(), params.getMes(), tipo)) {
            throw new EloValidationException(String.format("J\u00e1 existe uma atualiza\u00e7\u00e3o monet\u00e1ria para o m\u00eas %d/%d", params.getMes(), params.getExercicio()));
        }
        params.setPermiteAtualizacaoMensal(permiteAtualizacaoMonetariaMensal);
        params.calcularDatas();
        if (!this.atualizacaoMonetariaService.existsDebitoByFiltro(params)) {
            throw new EloValidationException("N\u00e3o foi encontrado nenhum d\u00e9bito para ser atualizado segundo o filtro informado.");
        }
        AtualizacaoMonetaria atualizacaoMonetaria = this.createAtualizacaoMonetaria(params);
        JobParameters jobParameters = this.createJobParameters(params, atualizacaoMonetaria);
        return this.jobLauncher.run(this.job, jobParameters);
    }

    private AtualizacaoMonetaria createAtualizacaoMonetaria(AtualizacaoMonetariaParcelamentoParams params) {
        AtualizacaoMonetaria atualizacaoMonetaria = new AtualizacaoMonetaria();
        if (!params.getPermiteAtualizacaoMensal().booleanValue()) {
            atualizacaoMonetaria.setId(Long.valueOf(String.format("%d%d", params.getMes(), params.getExercicio())));
        }
        atualizacaoMonetaria.setTipo(params.getTipo());
        atualizacaoMonetaria.setEntidade(params.getEntidade());
        atualizacaoMonetaria.setAno(Integer.valueOf(params.getExercicio().intValue()));
        atualizacaoMonetaria.setMes(Integer.valueOf(params.getMes().intValue()));
        atualizacaoMonetaria.setObservacao(params.getObservacao());
        atualizacaoMonetaria.setUsuario(SecurityUtils.getUserAise());
        atualizacaoMonetaria.setData(params.getDataMovimentacao().toLocalDate());
        atualizacaoMonetaria.setHora(DateUtils.localDateTimeToHoraFormatoBrasileiro((LocalDateTime)params.getDataMovimentacao()));
        return (AtualizacaoMonetaria)this.atualizacaoMonetariaService.save((EloEntity)atualizacaoMonetaria, null);
    }

    private boolean isJobRunning(AtualizacaoMonetariaParcelamentoParams params) {
        return this.jobExplorer.findRunningJobExecutions(JobType.ATUALIZACAO_MONETARIA_PARCELAMENTO.getTipo()).stream().anyMatch(execution -> this.buildIdentifier(params).equals(execution.getJobParameters().getString("identifier")));
    }

    private JobParameters createJobParameters(AtualizacaoMonetariaParcelamentoParams params, AtualizacaoMonetaria atualizacaoMonetaria) throws Exception {
        return new JobParametersBuilder().addString("params", this.objectMapper.writeValueAsString((Object)params)).addLong("timestamp", Long.valueOf(System.currentTimeMillis())).addString("identifier", this.buildIdentifier(params)).addLong("idAtualizacaoMonetaria", atualizacaoMonetaria.getId()).toJobParameters();
    }

    private String buildIdentifier(AtualizacaoMonetariaParcelamentoParams params) {
        return String.format("%d-%d-%d-%d", params.getEntidade(), params.getExercicio(), params.getMes(), params.getTipo().getValue());
    }
}

