/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.Livro;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.dto.dividaativa.FiltroGeraLivroDTO;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaBatchService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.util.DateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class LivroDividaAtivaJobStarter {
    private static final Logger log = LoggerFactory.getLogger(LivroDividaAtivaJobStarter.class);
    private final ObjectMapper objectMapper;
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job livroDividaAtivaBatchJob;
    private final ParametroGeralService parametroGeralService;
    private final ContextService contextService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService;

    public LivroDividaAtivaJobStarter(ObjectMapper objectMapper, JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="livroDividaAtivaBatchJob") Job livroDividaAtivaBatchJob, ParametroGeralService parametroGeralService, ContextService contextService, ParametroEntidadeExercicioService parametroEntidadeExercicioService, GeraLivroDividaAtivaBatchService geraLivroDividaAtivaBatchService) {
        this.objectMapper = objectMapper;
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.livroDividaAtivaBatchJob = livroDividaAtivaBatchJob;
        this.parametroGeralService = parametroGeralService;
        this.contextService = contextService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.geraLivroDividaAtivaBatchService = geraLivroDividaAtivaBatchService;
    }

    public JobExecution startJob(FiltroGeraLivroDTO filtro, Optional<Long> idAgendamento) {
        String filtroString = this.castObjectToString((Object)filtro);
        Boolean existeJobNaoFinalizadoComMesmoFiltro = this.jobExplorer.findRunningJobExecutions(JobType.CREATE_LIVRO_DIVIDA_ATIVA.getTipo()).stream().anyMatch(job -> filtroString.equals(job.getJobParameters().getString("filtro")));
        if (existeJobNaoFinalizadoComMesmoFiltro.booleanValue()) {
            throw new EloValidationException("J\u00e1 existe uma job com estes par\u00e2metros.");
        }
        Boolean englobaDebitos = this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.ENGLOBA_DEBITO_DIVIDA_ATIVA).map(ParametroEntidadeExercicio::getValor).map("S"::equals).orElse(Boolean.FALSE);
        String parametroInscricaoPorParcela = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_INSCRICAO_DIVIDA_ATIVA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        Livro livroCriado = this.geraLivroDividaAtivaBatchService.createLivroFromFiltro(filtro, englobaDebitos);
        String livroId = this.castObjectToString((Object)livroCriado.getId());
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addString("filtro", filtroString);
        jobParametersBuilder.addString("inscricaoPorParcela", parametroInscricaoPorParcela);
        jobParametersBuilder.addString("livroId", livroId);
        jobParametersBuilder.addLong("entidade", this.contextService.getEntidadePrincipal());
        jobParametersBuilder.addDate("date", new Date());
        jobParametersBuilder.addDate("dataInscricao", DateUtils.localDateToDate((LocalDate)filtro.getDataInscricao()));
        idAgendamento.ifPresent(id -> jobParametersBuilder.addLong("idAgendamento", id));
        return this.start(jobParametersBuilder.toJobParameters());
    }

    private String castObjectToString(Object object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            log.error("Erro ao fazer parse do objeto ", (Throwable)e);
            throw new EloValidationException("Erro ao fazer prepara\u00e7\u00e3o para gera\u00e7\u00e3o de livro de d\u00edvia ativa");
        }
    }

    private JobExecution start(JobParameters parameters) {
        try {
            return this.jobLauncher.run(this.livroDividaAtivaBatchJob, parameters);
        }
        catch (JobExecutionAlreadyRunningException e) {
            throw new EloValidationException("Job Gera\u00e7\u00e3o de livro de d\u00edvida ativa j\u00e1 est\u00e1 sendo executado");
        }
        catch (JobRestartException e) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel reiniciar o Job Gera\u00e7\u00e3o de livro de d\u00edvida ativa");
        }
        catch (JobParametersInvalidException e) {
            throw new EloValidationException("Par\u00e2metros para o Job Gera\u00e7\u00e3o de livro de d\u00edvida ativa est\u00e1 inv\u00e1lido. Verifique!");
        }
        catch (JobInstanceAlreadyCompleteException e) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel reiniciar o Job Gera\u00e7\u00e3o de livro de d\u00edvida ativa, pois foi conclu\u00eddo com sucesso");
        }
    }
}

