/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteConcederDescontoDTO;
import br.com.elotech.tributos.repository.BaixaAutomaticaDetalheRepository;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class DescontoBaixaAutomaticaJobStarter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DescontoBaixaAutomaticaJobStarter.class);
    private final JobLauncher launcher;
    private final JobExplorer explorer;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final Job job;
    private final BaixaAutomaticaDetalheRepository baixaAutomaticaDetalheRepository;

    public DescontoBaixaAutomaticaJobStarter(JobLauncher launcher, JobExplorer explorer, ParametroEntidadeExercicioService parametroEntidadeExercicioService, @Qualifier(value="descontoBaixaAutomaticaDetalheJob") Job job, BaixaAutomaticaDetalheRepository baixaAutomaticaDetalheRepository) {
        this.launcher = launcher;
        this.explorer = explorer;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.job = job;
        this.baixaAutomaticaDetalheRepository = baixaAutomaticaDetalheRepository;
    }

    public JobExecution startJob(PagamentoLoteConcederDescontoDTO dto) {
        this.validaSeTemItensParaAplicarDesconto(dto);
        JobParameters parameters = this.mountJobParameters(dto);
        this.validarSeTemJobRodandoComMesmosParametros(parameters);
        return this.start(parameters);
    }

    private void validaSeTemItensParaAplicarDesconto(PagamentoLoteConcederDescontoDTO dto) {
        boolean canExecute = this.baixaAutomaticaDetalheRepository.podeAplicarDesconto(dto.getEntidade(), dto.getExercicio(), dto.getLote());
        if (!canExecute) {
            throw new EloValidationException("N\u00e3o existe item para conceder desconto");
        }
    }

    private JobExecution start(JobParameters parameters) {
        try {
            return this.launcher.run(this.job, parameters);
        }
        catch (Exception e) {
            log.error("N\u00e3o foi poss\u00edvel concluir a execu\u00e7\u00e3o do job CONCEDER_DESCONTO_BAIXA_AUTOMATICA", (Throwable)e);
            throw new ResponseStatusException(HttpStatus.BAD_GATEWAY, "N\u00e3o foi poss\u00edvel concluir a execu\u00e7\u00e3o do job");
        }
    }

    private void validarSeTemJobRodandoComMesmosParametros(JobParameters newJobParameters) {
        this.explorer.findRunningJobExecutions(JobType.CONCEDER_DESCONTO_BAIXA_AUTOMATICA.getTipo()).stream().map(JobExecution::getJobParameters).forEach(parameters -> this.validate(parameters, newJobParameters));
    }

    private void validate(JobParameters parameters, JobParameters newJobParameters) {
        if (this.existsParams(parameters, newJobParameters)) {
            throw new EloValidationException("J\u00e1 existe um Job com os mesmos par\u00e2metros sendo executado");
        }
    }

    private boolean existsParams(JobParameters parameter, JobParameters newJobParameters) {
        return parameter.getParameters().equals(newJobParameters.getParameters());
    }

    private JobParameters mountJobParameters(PagamentoLoteConcederDescontoDTO dto) {
        JobParametersBuilder builder = new JobParametersBuilder().addLong("lote", dto.getLote()).addLong("exercicio", dto.getExercicio()).addLong("entidade", dto.getEntidade()).addDate("data", new Date()).addLong("motivoDeducaoId", this.getMotivoDeducaoId());
        if (Objects.nonNull(dto.getObservacao()) && !dto.getObservacao().isEmpty()) {
            builder.addString("observacao", dto.getObservacao());
        }
        return builder.toJobParameters();
    }

    private Long getMotivoDeducaoId() {
        Optional parametro = this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.MOTIVO_DEDUCAO_PAGO_MENOR);
        if (parametro.isEmpty() || StringUtils.isBlank((CharSequence)((ParametroEntidadeExercicio)parametro.get()).getValor())) {
            throw new EloValidationException("N\u00e3o foi encontrado Motivo de Dedu\u00e7\u00e3o parametrizado");
        }
        return Long.valueOf(((ParametroEntidadeExercicio)parametro.get()).getValor());
    }
}

