/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.VerificarExistenciaJobService;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class BaixaAutomaticaJobStarter {
    private final JobLauncher jobLauncher;
    private final VerificarExistenciaJobService verificarExistenciaJobService;
    private final Job baixaAutomaticaBatchJob;
    private final PagamentoLoteService pagamentoLoteService;
    private final TarefaAssincronaService tarefaAssincronaService;

    public BaixaAutomaticaJobStarter(JobLauncher jobLauncher, VerificarExistenciaJobService verificarExistenciaJobService, @Qualifier(value="baixaAutomaticaBatchJob") Job baixaAutomaticaBatchJob, PagamentoLoteService pagamentoLoteService, TarefaAssincronaService tarefaAssincronaService) {
        this.jobLauncher = jobLauncher;
        this.verificarExistenciaJobService = verificarExistenciaJobService;
        this.baixaAutomaticaBatchJob = baixaAutomaticaBatchJob;
        this.pagamentoLoteService = pagamentoLoteService;
        this.tarefaAssincronaService = tarefaAssincronaService;
    }

    public JobExecution startJob(Long entidade, Long exercicio, Long lote) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        PagamentoLoteId pagamentoLoteId = PagamentoLoteId.of((Long)entidade, (Long)exercicio, (Long)lote);
        Boolean tarefaEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.VERIFICACAO_PAGAMENTO_LOTE, "ID_PAGAMENTO_LOTE", pagamentoLoteId.toString());
        if (Boolean.TRUE.equals(tarefaEmExecucao)) {
            throw new EloValidationException("J\u00e1 existe uma tarefa em execu\u00e7\u00e3o para o Lote Pagamento informado!");
        }
        boolean existeJobComMesmosParametros = this.verificarExistenciaJobService.existeJobEmAndamento(entidade, exercicio, lote, JobType.BAIXA_AUTOMATICA.getTipo());
        if (existeJobComMesmosParametros) {
            throw new EloValidationException("Este lote j\u00e1 se encontra em processamento.");
        }
        PagamentoLote pagamentoLote = this.pagamentoLoteService.findByPagamentoLote(entidade, exercicio, lote);
        pagamentoLote.verificaSituacaoLote();
        pagamentoLote.verificaTipoDeArquivoRetorno();
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("entidade", entidade);
        jobParametersBuilder.addLong("exercicio", exercicio);
        jobParametersBuilder.addLong("lote", lote);
        jobParametersBuilder.addDate("data", new Date());
        return this.jobLauncher.run(this.baixaAutomaticaBatchJob, jobParametersBuilder.toJobParameters());
    }
}

