/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.agendamentorotina.notifiers.implementations;

import br.com.elotech.core.mail.MailService;
import br.com.elotech.core.mail.impl.MailParams;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.agendamentorotina.AgendamentoRotina;
import br.com.elotech.tributos.dto.parcelamento.AiseEstornoParcelamentoDTO;
import br.com.elotech.tributos.enums.agendamentorotina.TipoAgendamentoRotina;
import br.com.elotech.tributos.repository.agendamentorotina.AgendamentoRotinaRepository;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.agendamentorotina.notifiers.AgendamentoRotinaNotifier;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openl.util.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EstornoParcelamentoNotifier
implements AgendamentoRotinaNotifier {
    private final MailService mailService;
    private final AgendamentoRotinaRepository repository;
    private final PessoaService pessoaService;

    protected EstornoParcelamentoNotifier(MailService mailService, AgendamentoRotinaRepository repository, PessoaService pessoaService) {
        this.mailService = mailService;
        this.repository = repository;
        this.pessoaService = pessoaService;
    }

    public boolean accept(AgendamentoRotina agendamentoRotina) {
        return TipoAgendamentoRotina.ESTORNO_PARCELAMENTO.equals((Object)agendamentoRotina.getRotina());
    }

    public MailService getMailService() {
        return this.mailService;
    }

    public <R> void notify(AgendamentoRotina agendamentoRotina, R resource) {
        if (resource instanceof List) {
            this.notifyEstornos(agendamentoRotina, (List)resource);
        }
    }

    public <R> void notify(Long idAgendamento, R resource) {
        this.repository.findById((Object)idAgendamento).ifPresent(agendamentoRotina -> this.notify(agendamentoRotina, resource));
    }

    private void notifyEstornos(AgendamentoRotina agendamentoRotina, List<AiseEstornoParcelamentoDTO> estornos) {
        String messageContent = this.buildMessageContent(estornos);
        this.notifyEmail(agendamentoRotina, messageContent);
    }

    private void notifyEmail(AgendamentoRotina agendamentoRotina, String message) {
        if (agendamentoRotina.shouldSendEmail()) {
            MailParams mailParams = this.buildMailParams(agendamentoRotina, message);
            this.notifyByEmail(mailParams);
        }
    }

    private MailParams buildMailParams(AgendamentoRotina agendamentoRotina, String content) {
        Pessoa pessoa = this.pessoaService.findByCnpjCpf(agendamentoRotina.getUsuario());
        return MailParams.builder().to(pessoa.getContatoPrincipal().getEmail()).subject("Agendamento de rotina " + agendamentoRotina.getId() + " - Gera\u00e7\u00e3o de Livro de D\u00edvida Ativa").multipart(false).content(content).html(false).build();
    }

    private String buildMessageContent(List<AiseEstornoParcelamentoDTO> estornos) {
        Object messageTemplate = "Rotina de estorno de parcelamento em lote foi executada. ";
        String estornados = estornos.stream().filter(estorno -> Objects.nonNull(estorno.getIdEstornoParcelamento())).map(estorno -> String.valueOf(estorno.getIdParcelamento())).collect(Collectors.joining(","));
        String estornoComErro = estornos.stream().filter(estorno -> Objects.isNull(estorno.getIdEstornoParcelamento())).map(estorno -> String.valueOf(estorno.getIdParcelamento())).collect(Collectors.joining(","));
        messageTemplate = (String)messageTemplate + String.format("Parcelamentos estornados: %s. Com erro: %s", StringUtils.isBlank((CharSequence)estornados) ? "NENHUM" : estornados, StringUtils.isBlank((CharSequence)estornoComErro) ? "NENHUM" : estornoComErro);
        return messageTemplate;
    }
}

