/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo.multa;

import br.com.elotech.core.utils.Comparators;
import br.com.elotech.tributos.domain.EntidadeCorrecaoMulta;
import java.math.BigDecimal;
import java.util.List;

public final class CalculoMultaComum {
    private CalculoMultaComum() {
    }

    public static BigDecimal calculaValorMulta(List<EntidadeCorrecaoMulta> multas, Long numeroDias, Boolean dividaAtiva, Boolean parcelado) {
        return multas.stream().filter(multa -> multa.getNumeroDias() <= numeroDias && multa.getDividaAtiva().equals(dividaAtiva) && multa.getParcelado().equals(parcelado)).sorted(Comparators.comparingField(EntidadeCorrecaoMulta.class, (String)"numeroDias").reversed()).findFirst().map(EntidadeCorrecaoMulta::getPercentual).orElse(BigDecimal.ZERO);
    }
}

