/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.BaseCorrecaoMonetaria;
import br.com.elotech.tributos.domain.BaseJurosCorrecao;
import br.com.elotech.tributos.domain.BaseMultaCorrecao;
import br.com.elotech.tributos.domain.ConfigHonorario;
import br.com.elotech.tributos.domain.DividaFormaPagamentoTributo;
import br.com.elotech.tributos.domain.Feriado;
import br.com.elotech.tributos.domain.FormaCorrecao;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.MudancaMonetaria;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoFormaPagamento;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.domain.acrescimo.FormaCalculo;
import br.com.elotech.tributos.domain.acrescimo.IndiceComposto;
import br.com.elotech.tributos.domain.acrescimo.TipoCorrecao;
import br.com.elotech.tributos.domain.acrescimo.TipoJuros;
import br.com.elotech.tributos.domain.acrescimo.ValorIndice;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.DividaFormaPagamentoDTO;
import br.com.elotech.tributos.dto.acrescimo.EntidadeCorrecaoDTO;
import br.com.elotech.tributos.dto.acrescimo.ParametroCalculoAcrescimoDTO;
import br.com.elotech.tributos.service.ConfigHonorarioService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.FeriadoService;
import br.com.elotech.tributos.service.FormaCorrecaoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.MudancaMonetariaService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.TributoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoParamatroService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.acrescimo.calculo.correcao.CalculoCorrecaoUtils;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaComum;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaEspecialService;
import br.com.elotech.tributos.util.CalculoUtils;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.hibernate.Hibernate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.server.ResponseStatusException;

@Service
public class CalculoAcrescimoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CalculoAcrescimoService.class);
    private static final Boolean NAO_ARREDONDA = Boolean.FALSE;
    private static final BigDecimal DIVISOR_100 = BigDecimal.valueOf(100L);
    private static final Set<TipoFormaPagamento> COTA_UNICA = EnumSet.of(TipoFormaPagamento.COTA_UNICA, TipoFormaPagamento.TRES_PARCELAS);
    private final List<FormaCalculo> formasCalculos = Arrays.asList(FormaCalculo.VALOR_ATUAL, FormaCalculo.ACUMULADO);
    private final CalculoAcrescimoParamatroService calculoAcrescimoParamatroService;
    private final CalculoMultaEspecialService calculoMultaEspecialService;
    private final DiaUtilService diaUtilService;
    private final MudancaMonetariaService mudancaMonetariaService;
    private final FormaPagamentoService formaPagamentoService;
    private final FormaCorrecaoService formaCorrecaoService;
    private final TributoService tributoService;
    private final ContextService contextService;
    private final FeriadoService feriadoService;
    private final ParametroGeralService parametroGeralService;
    private final EntityManager entityManager;
    private final ConfigHonorarioService configHonorarioService;

    private BigDecimal getValorFinal(BigDecimal valor, Boolean arredondaPorPartesNoCalculo) {
        if (valor.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        return Boolean.TRUE.equals(arredondaPorPartesNoCalculo) ? valor.setScale((int)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS, RoundingMode.HALF_UP) : valor;
    }

    private BigDecimal calculaBaseCompostaCorrecao(AcrescimoDTO dados, BigDecimal valorParaCalculo, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        if (parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_MULTA) || parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularMulta(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        if (parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS) || parametros.getEntidadeCorrecao().getBaseCorrecaoMonetaria().equals((Object)BaseCorrecaoMonetaria.PRINCIPAL_JUROS_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularJuros(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        return valorParaCalculo;
    }

    private LocalDate atualizaDataBaseCalculo(IndiceComposto lastIndiceComposto, IndiceComposto indiceComposto, LocalDate dataBaseCalculo, LocalDate dataPagamento) {
        if (Objects.isNull(lastIndiceComposto) || indiceComposto.equals((Object)lastIndiceComposto) && !indiceComposto.getSobreporPeriodo().booleanValue()) {
            switch (1.$SwitchMap$br$com$elotech$tributos$domain$acrescimo$PeriodoCorrecao[indiceComposto.getIndiceCorrecao().getPeriodoCorrecao().ordinal()]) {
                case 1: {
                    return dataBaseCalculo.plusDays(1L);
                }
                case 2: {
                    return TipoCorrecao.INDICE_MENSAL_ACUMULADO.equals((Object)indiceComposto.getFormaCorrecao().getTipoCorrecao()) ? CalculoCorrecaoUtils.getDataBaseIndiceMensal((LocalDate)dataBaseCalculo, (LocalDate)dataPagamento, (Boolean)Boolean.FALSE) : dataBaseCalculo.plusMonths(1L);
                }
                case 3: {
                    return dataBaseCalculo.plusYears(1L);
                }
            }
        }
        return dataBaseCalculo;
    }

    private boolean isIndiceCompostoEqualToValorAtual(FormaCorrecao formaCorrecao, LocalDate dataPagamento) {
        IndiceComposto indiceComposto = CalculoCorrecaoUtils.getIndiceCompostoByData((FormaCorrecao)formaCorrecao, (LocalDate)dataPagamento);
        return FormaCalculo.VALOR_ATUAL.equals((Object)indiceComposto.getIndiceCorrecao().getFormaCalculo());
    }

    private boolean isFormaCorrecaoEqualToDataLancamento(FormaCorrecao formaCorrecao) {
        return TipoCorrecao.DATA_LANCAMENTO.equals((Object)formaCorrecao.getTipoCorrecao());
    }

    private boolean formaCorrecaoHasIntervaloMesesEqualToZero(FormaCorrecao formaCorrecao) {
        return formaCorrecao.getMeses() == 0L;
    }

    private boolean calculaAcrescimoDebitoIndiceCorrecaoEqualToValorAtualAndTipoCorrecaoEqualToDataLancamento(LocalDate dataBaseCalculo, LocalDate dataPagamento, ParametroCalculoAcrescimoDTO parametroCalculoAcrescimo) {
        return this.isFormaCorrecaoEqualToDataLancamento(parametroCalculoAcrescimo.getFormaCorrecao()) && this.formaCorrecaoHasIntervaloMesesEqualToZero(parametroCalculoAcrescimo.getFormaCorrecao()) && parametroCalculoAcrescimo.isCalculaAcrescimoIndiceCorrecaoValorAtual() && this.isIndiceCompostoEqualToValorAtual(parametroCalculoAcrescimo.getFormaCorrecao(), dataPagamento) && dataBaseCalculo.isEqual(dataPagamento);
    }

    private BigDecimal calcularCorrecao(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados, boolean utilizaCorrecaoEspecial) {
        boolean calculaCorrecao;
        LocalDate dataBaseCalculo;
        BigDecimal valorParaCalculo;
        FormaCorrecao formaCorrecao;
        FormaCorrecao formaCorrecao2 = formaCorrecao = utilizaCorrecaoEspecial ? parametros.getEntidadeCorrecao().getCorrecaoEspecial() : parametros.getFormaCorrecao();
        if (!parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceCorrecao().incideNaSituacao(dados.getSituacaoLegal()).booleanValue() || Objects.nonNull(dados.getTributo()) && !parametros.getTributo().getIncideCorrecao().booleanValue()) {
            return this.getValorFinal(dados.getValorCorrecao(), NAO_ARREDONDA);
        }
        if (TipoCorrecao.DATA_VENCIMENTO.equals((Object)formaCorrecao.getTipoCorrecao()) && dados.getDataVencimento().isAfter(dados.getDataReferencia())) {
            return this.getValorFinal(dados.getValorCorrecao(), NAO_ARREDONDA);
        }
        BigDecimal bigDecimal = valorParaCalculo = utilizaCorrecaoEspecial ? dados.getValorOriginal().add(dados.getValorCorrecao()) : dados.getValorOriginal();
        if (calculaBaseComposta.booleanValue()) {
            valorParaCalculo = this.calculaBaseCompostaCorrecao(dados, valorParaCalculo, calculaBaseComposta, parametros, feriados);
            dados.setValor(valorParaCalculo);
        }
        BigDecimal valorRetorno = calculaBaseComposta != false ? dados.getValorCorrecao() : BigDecimal.ZERO;
        LocalDate dataBaseCalculoInicial = dataBaseCalculo = this.getDataCorrecao(dados, parametros);
        LocalDate dataPagamento = CalculoCorrecaoUtils.novaDataPagamento((FormaCorrecao)formaCorrecao, (LocalDate)dataBaseCalculo, (LocalDate)dados.getDataReferencia());
        IndiceComposto lastIndiceComposto = null;
        boolean bl = calculaCorrecao = dataBaseCalculo.isBefore(dataPagamento) || this.calculaAcrescimoDebitoIndiceCorrecaoEqualToValorAtualAndTipoCorrecaoEqualToDataLancamento(dataBaseCalculo, dataPagamento, parametros);
        while (calculaCorrecao) {
            IndiceComposto indiceComposto = CalculoCorrecaoUtils.getIndiceCompostoByData((FormaCorrecao)formaCorrecao, (LocalDate)dataBaseCalculo);
            if (dataBaseCalculoInicial.equals(dataBaseCalculo) && indiceComposto.utilizaDataAlternativaIndiceMensal().booleanValue() && (dataBaseCalculo = CalculoCorrecaoUtils.getDataBaseIndiceMensal((LocalDate)dataBaseCalculo, (LocalDate)dataPagamento, (Boolean)Boolean.TRUE)).equals(dataPagamento)) break;
            FormaCalculo formaCalculo = indiceComposto.getIndiceCorrecao().getFormaCalculo();
            ValorIndice valorIndiceCorrecao = CalculoCorrecaoUtils.getValorIndice((FormaCorrecao)formaCorrecao, lastIndiceComposto, (IndiceComposto)indiceComposto, (LocalDate)dataBaseCalculo);
            lastIndiceComposto = indiceComposto;
            valorRetorno = valorRetorno.add(formaCalculo.getCalculoCorrecao().calculoValorCorrecao(valorParaCalculo.add(!this.formasCalculos.contains(formaCalculo) ? valorRetorno : BigDecimal.ZERO), dataBaseCalculo, dataPagamento, indiceComposto, valorIndiceCorrecao, parametros.getCorrecoesMonetarias()));
            dataBaseCalculo = this.atualizaDataBaseCalculo(lastIndiceComposto, indiceComposto, dataBaseCalculo, dataPagamento);
            if (FormaCalculo.VARIACAO.equals((Object)formaCalculo) || FormaCalculo.VALOR_ATUAL.equals((Object)formaCalculo)) {
                dataBaseCalculo = indiceComposto.getDataFinal().plusDays(1L);
            }
            calculaCorrecao = dataBaseCalculo.isBefore(dataPagamento);
        }
        if (calculaBaseComposta.booleanValue() && formaCorrecao.getAgregaAoValorDoPrincipal().booleanValue()) {
            dados.setValor(dados.getValor().add(this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo())));
            return BigDecimal.ZERO;
        }
        return this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo());
    }

    private LocalDate getDataCorrecao(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$acrescimo$TipoCorrecao[parametros.getFormaCorrecao().getTipoCorrecao().ordinal()]) {
            case 1: {
                return dados.getDataLancamento();
            }
            case 2: {
                return dados.getDataVencimento();
            }
            case 3: {
                return dados.getDataBaseIndiceAcumulado();
            }
        }
        throw new EloValidationException("N\u00e3o foi poss\u00edvel identificar a data de corre\u00e7\u00e3o a ser usado para o tipo " + parametros.getFormaCorrecao().getTipoCorrecao());
    }

    private BigDecimal calculaBaseCompostaJuros(CalculaAcrescimoDTO calculaAcrescimoDTO, BigDecimal valorParaCalculo) {
        ParametroCalculoAcrescimoDTO parametros = calculaAcrescimoDTO.getParametros();
        List feriados = calculaAcrescimoDTO.getFeriados();
        AcrescimoDTO dados = calculaAcrescimoDTO.getDados();
        if (parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO) || parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularCorrecao(dados, Boolean.valueOf(calculaAcrescimoDTO.getCalculaBaseComposta() == false), parametros, feriados, Boolean.FALSE.booleanValue()));
        }
        if (parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_MULTA) || parametros.getEntidadeCorrecao().getBaseJuros().equals((Object)BaseJurosCorrecao.PRINCIPAL_CORRECAO_MULTA)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularMulta(dados, Boolean.valueOf(calculaAcrescimoDTO.getCalculaBaseComposta() == false), parametros, feriados));
        }
        return valorParaCalculo;
    }

    protected BigDecimal calcularJuros(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        CalculaAcrescimoDTO calculaAcrescimoDTO = CalculaAcrescimoDTO.builder().dados(dados).feriados(feriados).calculaBaseComposta(calculaBaseComposta).parametros(parametros).build();
        this.validateEntidadeCorrecaoParaCalculoDeJuros(parametros.getEntidadeCorrecao());
        BigDecimal juros = this.shouldUseJurosValorFinal(dados, parametros, calculaAcrescimoDTO) ? this.getValorFinal(dados.getValorJuros(), NAO_ARREDONDA) : (parametros.isUsaCalculoJurosPorExercicio() && !parametros.getEntidadeCorrecao().getMesJuros().equals((Object)TipoJuros.APOS_VENCIMENTO) ? this.calculaJurosPorExercicio(calculaAcrescimoDTO) : (parametros.getEntidadeCorrecao().utilizaCorrecaoEspecial() ? this.calculaJurosCorrecaoEspecial(calculaAcrescimoDTO) : this.calculaJurosExercicioAtual(calculaAcrescimoDTO)));
        return juros;
    }

    private boolean shouldUseJurosValorFinal(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros, CalculaAcrescimoDTO calculaAcrescimoDTO) {
        return !dados.getDataReferencia().isAfter(dados.getDataVencimento()) || parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceJuros().incideNaSituacao(dados.getSituacaoLegal()) == false || Objects.nonNull(dados.getTributo()) && calculaAcrescimoDTO.getParametros().getTributo().getIncideJuros() == false;
    }

    private BigDecimal calculaJurosCorrecaoEspecial(CalculaAcrescimoDTO calculaAcrescimoDTO) {
        AcrescimoDTO dados = calculaAcrescimoDTO.getDados();
        ParametroCalculoAcrescimoDTO parametros = calculaAcrescimoDTO.getParametros();
        List feriados = calculaAcrescimoDTO.getFeriados();
        BigDecimal correcaoEspecial = this.calcularCorrecao(dados, Boolean.FALSE, parametros, feriados, Boolean.TRUE.booleanValue());
        BigDecimal juros = this.calculaJurosExercicioAtual(calculaAcrescimoDTO);
        return juros.add(correcaoEspecial);
    }

    private BigDecimal calculaBaseCompostaMulta(AcrescimoDTO dados, BigDecimal valorParaCalculo, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        if (parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO) || parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO_JUROS)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularCorrecao(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados, Boolean.FALSE.booleanValue()));
        }
        if (parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_JUROS) || parametros.getEntidadeCorrecao().getBaseMulta().equals((Object)BaseMultaCorrecao.PRINCIPAL_CORRECAO_JUROS)) {
            valorParaCalculo = valorParaCalculo.add(this.calcularJuros(dados, Boolean.valueOf(calculaBaseComposta == false), parametros, feriados));
        }
        return valorParaCalculo;
    }

    private BigDecimal calcularMulta(AcrescimoDTO dados, Boolean calculaBaseComposta, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        BigDecimal percentualMultaComum;
        Long diasAtraso;
        if (!parametros.getEntidadeCorrecao().getEntidadeCorrecaoIndiceMulta().incideNaSituacao(dados.getSituacaoLegal()).booleanValue() || Objects.nonNull(dados.getTributo()) && !parametros.getTributo().getIncideMulta().booleanValue()) {
            return this.getValorFinal(dados.getValorMulta(), NAO_ARREDONDA);
        }
        BigDecimal valorParaCalculo = dados.getValorOriginal();
        if (calculaBaseComposta.booleanValue()) {
            valorParaCalculo = this.calculaBaseCompostaMulta(dados, valorParaCalculo, calculaBaseComposta, parametros, feriados);
        }
        if ((diasAtraso = this.diaUtilService.countDiasAtraso(dados.getDataVencimento(), dados.getDataReferencia(), parametros.getEntidadeCorrecao().getMultaDias(), feriados)) <= 0L) {
            return this.getValorFinal(dados.getValorMulta(), NAO_ARREDONDA);
        }
        BigDecimal percentualMulta = percentualMultaComum = CalculoMultaComum.calculaValorMulta((List)parametros.getEntidadeCorrecao().getCorrecaoMulta(), (Long)diasAtraso, (Boolean)dados.getSituacaoLegal().isDividaAtivaOrJuizo(), (Boolean)dados.getParcelado());
        if (!parametros.getEntidadeCorrecao().getSobreporMulta().booleanValue()) {
            BigDecimal percentualMultaEspecial = this.calculoMultaEspecialService.calculaValorMultaEspecial(parametros.getEntidadeCorrecao().getCorrecaoMultaEspecial(), dados.getDataVencimento(), dados.getDataReferencia(), parametros.getEntidadeCorrecao().getMultaDias(), feriados);
            percentualMulta = percentualMultaComum.add(percentualMultaEspecial);
        }
        BigDecimal valorRetorno = valorParaCalculo.multiply(percentualMulta).divide(DIVISOR_100);
        return this.getValorFinal(valorRetorno, parametros.getEntidadeCorrecao().getArredondaPorPartesNoCalculo());
    }

    public EntidadeCorrecaoDTO getEntidadeCorrecao(Long entidade, Long exercicio, Optional<Long> divida) {
        if (Objects.isNull(entidade) || Objects.isNull(exercicio)) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel realizar o c\u00e1lculo pois n\u00e3o foram informados os dados da entidade e do exerc\u00edcio.");
        }
        return this.calculoAcrescimoParamatroService.getEntidadeCorrecao(entidade, exercicio, divida);
    }

    public List<EntidadeCorrecaoDTO> getAllEntidadesCorrecoes(Long entidade) {
        return this.calculoAcrescimoParamatroService.getAllEntidadesCorrecoes(entidade);
    }

    private Boolean podeCalcularAcrescimos(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        return (parametros.getFormaCorrecao().getTipoCorrecao().equals((Object)TipoCorrecao.DATA_VENCIMENTO) && dados.getDataReferencia().isAfter(dados.getDataVencimento()) || Arrays.asList(TipoCorrecao.DATA_LANCAMENTO, TipoCorrecao.INDICE_MENSAL_ACUMULADO).contains(parametros.getFormaCorrecao().getTipoCorrecao())) && !Arrays.asList(TipoFormaPagamento.COTA_UNICA, TipoFormaPagamento.TRES_PARCELAS).contains(parametros.getFormaPagamento().getTipoFormaPagamento());
    }

    private void verificaDataVencimento(AcrescimoDTO dados, List<Feriado> feriados) {
        LocalDate proximoDiaUtil;
        if (!this.diaUtilService.diaUtil(dados.getDataVencimento(), feriados).booleanValue() && Objects.nonNull(proximoDiaUtil = this.diaUtilService.diaUtilProximo(dados.getDataVencimento(), feriados)) && !dados.getDataVencimento().isAfter(dados.getDataReferencia()) && !dados.getDataReferencia().isAfter(proximoDiaUtil)) {
            dados.setDataVencimentoOriginal(dados.getDataVencimento());
            dados.setDataVencimento(proximoDiaUtil);
        }
    }

    private void verificaDataPagamento(AcrescimoDTO dados, List<Feriado> feriados) {
        LocalDate proximoDiaUtil;
        if (Objects.nonNull(dados.getDataVencimentoBoleto()) && !this.diaUtilService.diaUtil(dados.getDataVencimentoBoleto(), feriados).booleanValue() && Objects.nonNull(proximoDiaUtil = this.diaUtilService.diaUtilProximo(dados.getDataVencimentoBoleto(), feriados)) && proximoDiaUtil.isEqual(dados.getDataReferencia())) {
            dados.setDataReferencia(dados.getDataVencimentoBoleto());
        }
    }

    private DividaFormaPagamentoTributo getDividaFormaPagamentoTributo(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros) {
        if (Objects.nonNull(parametros.getDividaFormaPagamento())) {
            return parametros.getDividaFormaPagamento().getFormasPagamentoTributo().stream().filter(tributo -> tributo.getId().getTributo().compareToIgnoreCase(dados.getTributo()) == 0).findFirst().orElse(null);
        }
        return null;
    }

    private Boolean possuiDesconto(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros, LocalDate proximoDiaUtil) {
        return Objects.nonNull(parametros.getDividaFormaPagamento()) && (COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()) && (parametros.getDividaFormaPagamento().getVencimento().compareTo(dados.getDataReferencia()) >= 0 || Boolean.TRUE.equals(dados.getAplicaDescontoCotaUnica())) || !COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()) && proximoDiaUtil.compareTo(dados.getDataReferencia()) >= 0);
    }

    private void calculaValorDesconto(AcrescimoDTO dados, ParametroCalculoAcrescimoDTO parametros, List<Feriado> feriados) {
        DividaFormaPagamentoTributo dividaFormaPagamentoTributo;
        LocalDate proximoDiaUtil;
        LocalDate localDate = proximoDiaUtil = this.diaUtilService.diaUtil(dados.getDataVencimento(), feriados) != false ? dados.getDataVencimento() : this.diaUtilService.diaUtilProximo(dados.getDataVencimento(), feriados);
        if (dados.getDescontoParcelamento().compareTo(BigDecimal.ZERO) > 0 && (dados.getDataReferencia().isBefore(proximoDiaUtil) || COTA_UNICA.contains(parametros.getFormaPagamento().getTipoFormaPagamento()))) {
            dados.setValorDescontoPrincipal(CalculoUtils.arredonda((BigDecimal)dados.getValor().multiply(dados.getDescontoParcelamento()).divide(DIVISOR_100)));
        }
        if (Objects.nonNull(dividaFormaPagamentoTributo = this.getDividaFormaPagamentoTributo(dados, parametros)) && dividaFormaPagamentoTributo.possuiDesconto().booleanValue() && parametros.getFormaPagamento().getId().compareTo(0L) > 0) {
            if (this.possuiDesconto(dados, parametros, proximoDiaUtil).booleanValue()) {
                dados.setValorDescontoPrincipal(dados.getValorDescontoPrincipal().add(CalculoUtils.arredonda((BigDecimal)dados.getValor().multiply(dividaFormaPagamentoTributo.getDesconto()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoJuros().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoJuros(dados.getValorDescontoJuros().add(CalculoUtils.arredonda((BigDecimal)dados.getValorJuros().multiply(dividaFormaPagamentoTributo.getDescontoJuros()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoMulta().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoMulta(dados.getValorDescontoMulta().add(CalculoUtils.arredonda((BigDecimal)dados.getValorMulta().multiply(dividaFormaPagamentoTributo.getDescontoMulta()).divide(DIVISOR_100))));
            }
            if (dividaFormaPagamentoTributo.getDescontoCorrecao().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorDescontoCorrecao(dados.getValorDescontoCorrecao().add(CalculoUtils.arredonda((BigDecimal)dados.getValorCorrecao().multiply(dividaFormaPagamentoTributo.getDescontoCorrecao()).divide(DIVISOR_100))));
            }
        }
    }

    @Transactional(readOnly=true)
    public AcrescimoDTO calculaAcrescimos(AcrescimoDTO dados, List<EntidadeCorrecaoDTO> entidadeCorrecaoDTOS, List<FormaCorrecao> formaCorrecoes, List<FormaPagamento> formaPagamentos, List<MudancaMonetaria> mudancasMonetarias, List<Feriado> feriados, Map<String, Tributo> cacheTributos, Map<String, DividaFormaPagamentoDTO> cacheDivida, boolean usaCalculoJurosPorExercicio, boolean calculaAcrescimoIndiceCorrecaoValorAtual, ConfigHonorario configHonorario) {
        ParametroCalculoAcrescimoDTO parametros = this.getParamsCalculoCorrecao(dados, entidadeCorrecaoDTOS, formaCorrecoes, formaPagamentos, mudancasMonetarias, usaCalculoJurosPorExercicio, calculaAcrescimoIndiceCorrecaoValorAtual);
        if (parametros.getFormaCorrecao().getConverteMoeda().booleanValue()) {
            dados.setValor(CalculoCorrecaoUtils.converteMoeda((BigDecimal)dados.getValor(), (LocalDate)dados.getDataLancamento(), (LocalDate)dados.getDataVencimento(), (FormaCorrecao)parametros.getFormaCorrecao()));
            log.trace("Converteu moeda");
        }
        if (Objects.nonNull(parametros.getCorrecoesMonetarias())) {
            parametros.getCorrecoesMonetarias().forEach(mudancaMonetaria -> {
                BigDecimal valorAnterior = dados.getValor();
                BigDecimal valorCorrigido = CalculoCorrecaoUtils.aplicaCorrecaoMonetaria((MudancaMonetaria)mudancaMonetaria, (BigDecimal)valorAnterior, (LocalDate)dados.getDataVencimento(), (LocalDate)dados.getDataReferencia());
                dados.setValor(valorCorrigido);
                log.trace("Calculou Correcao monetaria {}. Valor anterior: {}, valorCorrigido: {}", new Object[]{mudancaMonetaria.getId(), valorAnterior, valorCorrigido});
            });
        }
        dados.setValorOriginal(dados.getValor());
        dados.setDataVencimentoOriginal(dados.getDataVencimento());
        if (this.podeCalcularAcrescimos(dados, parametros).booleanValue()) {
            this.getParamsCalculoTributo(parametros, dados, cacheTributos);
            this.verificaDataVencimento(dados, feriados);
            log.trace("Verificou Data de vencimento ");
            this.verificaDataPagamento(dados, feriados);
            log.trace("Verificou Data de pagamento ");
            dados.setValorCorrecao(CalculoUtils.arredonda((BigDecimal)this.calcularCorrecao(dados, Boolean.TRUE, parametros, feriados, Boolean.FALSE.booleanValue())));
            log.trace("Calculou Corre\u00e7\u00e3o");
            dados.setValorMulta(CalculoUtils.arredonda((BigDecimal)this.calcularMulta(dados, Boolean.TRUE, parametros, feriados)));
            log.trace("Calculou Multa");
            dados.setValorJuros(CalculoUtils.arredonda((BigDecimal)this.calcularJuros(dados, Boolean.TRUE, parametros, feriados)));
            log.trace("Calculou Juros");
            if (parametros.getFormaCorrecao().getAgregaAoJuros().booleanValue() && dados.getValorCorrecao().compareTo(BigDecimal.ZERO) > 0) {
                dados.setValorJuros(dados.getValorJuros().add(dados.getValorCorrecao()));
                dados.setValorCorrecao(BigDecimal.ZERO);
                log.trace("Ativou a condi\u00e7\u00e3o de agregar a corre\u00e7\u00e3o ao valor dos juros");
            }
            dados.setValor(CalculoUtils.arredonda((BigDecimal)dados.getValor()));
            log.trace("Arredondou valor");
            dados.setDataVencimento(dados.getDataVencimentoOriginal());
        }
        if (dados.getCalculaValorDesconto().booleanValue()) {
            this.getParamsCalculoDividaFormaPagamento(parametros, dados, cacheDivida);
            this.calculaValorDesconto(dados, parametros, feriados);
            log.trace("Calculou desconto");
        }
        if (this.deveCalcularHonorario(configHonorario, dados)) {
            dados.setValorHonorario(this.getValorHonorario(dados, configHonorario));
        }
        return dados;
    }

    public boolean deveCalcularHonorario(ConfigHonorario configHonorario, AcrescimoDTO dados) {
        return Objects.nonNull(configHonorario) && Boolean.FALSE.equals(dados.getParcelado()) && (configHonorario.getPercentualAJ() > 0.0 || configHonorario.getPercentualDA() > 0.0);
    }

    public BigDecimal calcularPorcentagem(BigDecimal valor, Double percentual) {
        return valor.multiply(BigDecimal.valueOf(percentual)).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_EVEN);
    }

    private BigDecimal getValorHonorario(AcrescimoDTO dados, ConfigHonorario configHonorario) {
        Double percentual = 0.0;
        BigDecimal valorCalculo = dados.getValor().subtract(dados.getValorDesconto());
        if (dados.getSituacaoLegal().equals((Object)SituacaoLegal.JUIZO)) {
            percentual = configHonorario.getPercentualAJ();
        }
        if (dados.getSituacaoLegal().equals((Object)SituacaoLegal.DIVIDA_ATIVA)) {
            percentual = configHonorario.getPercentualDA();
        }
        if (Boolean.TRUE.equals(configHonorario.getCalcularValorAcrescimosHono())) {
            valorCalculo = dados.getValor().add(dados.getValorJuros()).add(dados.getValorMulta()).add(dados.getValorCorrecao()).subtract(dados.getValorDesconto());
        }
        if (percentual > 0.0) {
            return this.calcularPorcentagem(valorCalculo, percentual);
        }
        return BigDecimal.ZERO;
    }

    @Transactional
    public List<AcrescimoDTO> calculaAcrescimos(List<AcrescimoDTO> dados) {
        List entidadesCorrecoes = this.getEntidadesCorrecoes(this.contextService.getEntidadePrincipalInfo().getId());
        List formasCorrecoes = this.getFormasCorrecoes();
        List formasPagamentos = this.getFormasPagamento();
        List mudancasMonetarias = this.getMudancasMonetarias();
        List feriados = this.getFeriados();
        HashMap cacheTributos = new HashMap();
        HashMap cacheDivida = new HashMap();
        boolean usaCalculoJurosPorExercicio = this.usaCalculoJurosPorExercicio();
        boolean calculaAcrescimoIndiceCorrecaoValorAtual = this.entidadeCalculaAcrescimoIndiceCorrecaoValorAtual();
        ConfigHonorario configHonorario = this.getConfiguracaoHonorarioByExercicio(this.contextService.getExercicioAtual());
        for (AcrescimoDTO dto : dados) {
            this.calculaAcrescimos(dto, entidadesCorrecoes, formasCorrecoes, formasPagamentos, mudancasMonetarias, feriados, cacheTributos, cacheDivida, usaCalculoJurosPorExercicio, calculaAcrescimoIndiceCorrecaoValorAtual, configHonorario);
        }
        return dados;
    }

    @Transactional
    public AcrescimoDTO calculaAcrescimos(AcrescimoDTO dto, Optional<ListasNecessariasCalculaAcrescimoDTO> lncaDTO) {
        return this.calculaAcrescimos(dto, lncaDTO, null, null);
    }

    @Transactional
    public AcrescimoDTO calculaAcrescimos(AcrescimoDTO dto, Optional<ListasNecessariasCalculaAcrescimoDTO> lncaDTO, Boolean usaCalculoJurosPorExercicio, Boolean calculaAcrescimoIndiceCorrecaoValorAtual) {
        ListasNecessariasCalculaAcrescimoDTO listasNecessariasCalculaAcrescimoDTO = lncaDTO.orElseGet(() -> this.createNecessariasCalculaAcrescimo());
        return this.calculaAcrescimos(dto, listasNecessariasCalculaAcrescimoDTO.getEntidadesCorrecoes(), listasNecessariasCalculaAcrescimoDTO.getFormasCorrecoes(), listasNecessariasCalculaAcrescimoDTO.getFormasPagamentos(), listasNecessariasCalculaAcrescimoDTO.getMudancasMonetarias(), listasNecessariasCalculaAcrescimoDTO.getFeriados(), new HashMap(), new HashMap(), Objects.isNull(usaCalculoJurosPorExercicio) ? this.usaCalculoJurosPorExercicio() : usaCalculoJurosPorExercicio.booleanValue(), Objects.isNull(calculaAcrescimoIndiceCorrecaoValorAtual) ? this.entidadeCalculaAcrescimoIndiceCorrecaoValorAtual() : calculaAcrescimoIndiceCorrecaoValorAtual.booleanValue(), this.getConfiguracaoHonorarioByExercicio(this.contextService.getExercicioAtual()));
    }

    public <T extends CalculaAcrescimoBaseDTO> List<T> calculaAcrescimos(List<T> params, Long formaPagamento) {
        return this.calculaAcrescimos(params, formaPagamento, this.contextService.getDataAtual());
    }

    @Transactional(readOnly=true)
    public <T extends CalculaAcrescimoBaseDTO> List<T> calculaAcrescimos(List<T> params, Long formaPagamento, LocalDate dataReferencia) {
        List entidadesCorrecoes = this.getEntidadesCorrecoes(this.contextService.getEntidadePrincipalInfo().getId());
        log.trace("carregou entidade corre\u00e7\u00e3o");
        List formasCorrecoes = this.getFormasCorrecoes();
        log.trace("carregou forma corre\u00e7\u00e3o");
        List formasPagamentos = this.getFormasPagamento();
        log.trace("carregou forma pagamento");
        List mudancasMonetarias = this.getMudancasMonetarias();
        log.trace("carregou mudan\u00e7a monetaria");
        List feriados = this.getFeriados();
        log.trace("carregou feriados");
        ListasNecessariasCalculaAcrescimoDTO dtos = new ListasNecessariasCalculaAcrescimoDTO(entidadesCorrecoes, formasCorrecoes, formasPagamentos, mudancasMonetarias, feriados);
        return this.calculaAcrescimos(params, formaPagamento, dataReferencia, dtos);
    }

    @Transactional(readOnly=true)
    public <T extends CalculaAcrescimoBaseDTO> List<T> calculaAcrescimos(List<T> params, Long formaPagamento, LocalDate dataReferencia, ListasNecessariasCalculaAcrescimoDTO dto) {
        ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos = Optional.ofNullable(dto).orElseGet(() -> this.createNecessariasCalculaAcrescimo());
        boolean useCalculoJurosPorExercicio = this.usaCalculoJurosPorExercicio();
        boolean calculaAcrescimoIndiceCorrecaoValorAtual = this.entidadeCalculaAcrescimoIndiceCorrecaoValorAtual();
        ConfigHonorario configHonorario = this.getConfiguracaoHonorarioByExercicio(this.contextService.getExercicioAtual());
        AtomicLong i = new AtomicLong(0L);
        int total = params.size();
        return params.stream().map(debito -> {
            log.trace("iniciou item numero {}/{}", (Object)i.get(), (Object)total);
            TipoSituacaoParcela tipoSituacaoParcela = TipoSituacaoParcela.fromValue((Object)debito.getTipoSituacaoParcela());
            if (!tipoSituacaoParcela.isAberto()) {
                return debito;
            }
            AcrescimoDTO valorAcrescimo = this.calculaAcrescimos(AcrescimoDTO.of((CalculaAcrescimoBaseDTO)debito, (Long)formaPagamento, (LocalDate)dataReferencia), parametrosAcrescimos.getEntidadesCorrecoes(), parametrosAcrescimos.getFormasCorrecoes(), parametrosAcrescimos.getFormasPagamentos(), parametrosAcrescimos.getMudancasMonetarias(), parametrosAcrescimos.getFeriados(), parametrosAcrescimos.getCacheTributos(), parametrosAcrescimos.getCacheDivida(), useCalculoJurosPorExercicio, calculaAcrescimoIndiceCorrecaoValorAtual, configHonorario);
            debito.setValorPrincipal(valorAcrescimo.getValor());
            debito.setValorOriginalDebito(valorAcrescimo.getValorOriginal());
            debito.setValorJuros(valorAcrescimo.getValorJuros());
            debito.setValorMulta(valorAcrescimo.getValorMulta());
            debito.setValorCorrecao(valorAcrescimo.getValorCorrecao());
            debito.setValorDescontoPrincipal(valorAcrescimo.getValorDescontoPrincipal());
            debito.setValorDescontoJuros(valorAcrescimo.getValorDescontoJuros());
            debito.setValorDescontoMulta(valorAcrescimo.getValorDescontoMulta());
            debito.setValorDescontoCorrecao(valorAcrescimo.getValorDescontoCorrecao());
            debito.setValorHonorario(valorAcrescimo.getValorHonorario());
            log.trace("finalizou item {}/{}", (Object)i.getAndIncrement(), (Object)total);
            return debito;
        }).collect(Collectors.toList());
    }

    private ParametroCalculoAcrescimoDTO getParamsCalculoCorrecao(AcrescimoDTO dados, List<EntidadeCorrecaoDTO> entidadeCorrecaoDTOS, List<FormaCorrecao> formaCorrecoes, List<FormaPagamento> formaPagamentos, List<MudancaMonetaria> mudancasMonetarias, boolean usaCalculoJurosPorExercicio, boolean entidadeCalculaAcrescimoIndiceCorrecaoValorAtual) {
        ParametroCalculoAcrescimoDTO parametros = new ParametroCalculoAcrescimoDTO();
        parametros.setEntidadeCorrecao(this.filterEntidadeCorrecao(dados.getExercicio(), dados.getEntidade(), dados.getDivida().getDivida(), entidadeCorrecaoDTOS));
        parametros.setAllEntidadeCorrecao(entidadeCorrecaoDTOS);
        parametros.setUsaCalculoJurosPorExercicio(usaCalculoJurosPorExercicio);
        parametros.setCalculaAcrescimoIndiceCorrecaoValorAtual(entidadeCalculaAcrescimoIndiceCorrecaoValorAtual);
        parametros.setFormaCorrecao(formaCorrecoes.stream().filter(formaCorrecao -> formaCorrecao.getId().equals(dados.getFormaCorrecao())).findFirst().orElse(Optional.ofNullable(parametros.getEntidadeCorrecao()).map(EntidadeCorrecaoDTO::getFormaCorrecao).orElse(null)));
        log.trace("Carregou forma corre\u00e7\u00e3o.");
        parametros.setFormaPagamento((FormaPagamento)formaPagamentos.stream().filter(formaPagamento -> formaPagamento.getId().equals(dados.getFormaPagamento())).findFirst().orElse(null));
        log.trace("Carregou forma pagamento.");
        parametros.setCorrecoesMonetarias(mudancasMonetarias);
        log.trace("Carregou corre\u00e7\u00f5es monetarias.");
        return parametros;
    }

    private EntidadeCorrecaoDTO filterEntidadeCorrecao(Long exercicio, Long entidade, Long divida, List<EntidadeCorrecaoDTO> entidadeCorrecaoDTOS) {
        List entidadeCorrecaoByEntidadeExercicioDivida = entidadeCorrecaoDTOS.stream().filter(dto -> dto.getExercicio().equals(exercicio) && dto.getEntidade().equals(entidade) && dto.getEntidadeCorrecaoDivida().stream().anyMatch(d -> d.getId().getDivida().equals(divida))).collect(Collectors.toList());
        if (entidadeCorrecaoByEntidadeExercicioDivida.size() > 1) {
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, String.format("Existe mais de uma entidade corre\u00e7\u00e3o configurada para mesma guia. Entidade %d e Exerc\u00edcio %d e Divida %d ", entidade, exercicio, divida));
        }
        if (entidadeCorrecaoByEntidadeExercicioDivida.size() == 1) {
            log.trace("Carregou entidade corre\u00e7\u00e3o por exercicio, entidade e divida.");
            return entidadeCorrecaoByEntidadeExercicioDivida.stream().findFirst().orElse(null);
        }
        log.trace("Carregou entidade corre\u00e7\u00e3o por exercicio, entidade e principal.");
        return entidadeCorrecaoDTOS.stream().filter(dto -> dto.getExercicio().equals(exercicio) && dto.getEntidade().equals(entidade) && dto.getPrincipal() != false).findFirst().orElseThrow(() -> this.mountEntidadeCorrecaoErrorMessage(entidade, exercicio, divida));
    }

    private ResponseStatusException mountEntidadeCorrecaoErrorMessage(Long idEntidade, Long exercicio, Long divida) {
        String mensagemErro = String.format("N\u00e3o foi encontrado entidade de corre\u00e7\u00e3o principal para o exercicio %d e entidade %d. ", exercicio, idEntidade);
        if (Objects.nonNull(divida)) {
            mensagemErro = mensagemErro.concat(String.format("Tamb\u00e9m n\u00e3o foi encontrado entidade de corre\u00e7\u00e3o para a divida %d. ", divida));
        }
        return new ResponseStatusException(HttpStatus.NOT_FOUND, mensagemErro);
    }

    private void getParamsCalculoTributo(ParametroCalculoAcrescimoDTO parametros, AcrescimoDTO dados, Map<String, Tributo> cacheTributo) {
        String key = String.format("%d-%d-%s", dados.getEntidade(), dados.getExercicio(), dados.getTributo());
        Tributo tributo = cacheTributo.computeIfAbsent(key, k -> this.loadTributo(dados));
        parametros.setTributo(tributo);
        log.trace("Carregou tributo.");
    }

    private void getParamsCalculoDividaFormaPagamento(ParametroCalculoAcrescimoDTO parametros, AcrescimoDTO dados, Map<String, DividaFormaPagamentoDTO> cacheDivida) {
        parametros.setDividaFormaPagamento(this.loadDividaFormaPagamento(dados, cacheDivida));
        log.trace("Carregou divida forma pagamento.");
    }

    public List<EntidadeCorrecaoDTO> getEntidadesCorrecoes() {
        return this.getEntidadesCorrecoes(this.contextService.getEntidadePrincipalInfo().getId());
    }

    public List<EntidadeCorrecaoDTO> getEntidadeCorrecaoByMultiValueFilterExercicio() {
        return this.calculoAcrescimoParamatroService.getEntidadesCorrecaoByEntidade(this.contextService.getEntidadePrincipalInfo().getId());
    }

    private List<EntidadeCorrecaoDTO> getEntidadesCorrecoes(Long idEntidade) {
        return this.getAllEntidadesCorrecoes(idEntidade);
    }

    @Transactional
    public ListasNecessariasCalculaAcrescimoDTO createNecessariasCalculaAcrescimo() {
        return new ListasNecessariasCalculaAcrescimoDTO(this.getEntidadesCorrecoes(), this.getFormasCorrecoes(), this.getFormasPagamento(), this.getMudancasMonetarias(), this.getFeriados());
    }

    @Transactional
    public ListasNecessariasCalculaAcrescimoDTO createNecessariasCalculaAcrescimoBatch() {
        List formaCorrecoes = this.entityManager.createQuery("SELECT f FROM FormaCorrecao f JOIN FETCH f.indices", FormaCorrecao.class).getResultList();
        formaCorrecoes.stream().map(FormaCorrecao::getIndices).flatMap(Collection::stream).forEach(a -> {
            Hibernate.initialize((Object)a.getId().getIndiceCorrecao());
            Hibernate.initialize((Object)a.getId().getIndiceCorrecao().getValores());
        });
        return new ListasNecessariasCalculaAcrescimoDTO(this.getEntidadesCorrecoes(), formaCorrecoes, this.getFormasPagamento(), this.getMudancasMonetarias(), this.getFeriados());
    }

    public List<FormaPagamento> getFormasPagamento() {
        return this.formaPagamentoService.findAll();
    }

    private DividaFormaPagamentoDTO loadDividaFormaPagamento(AcrescimoDTO dados, Map<String, DividaFormaPagamentoDTO> cacheDivida) {
        String key = String.format("%d-%d-%d-%d", dados.getEntidade(), dados.getExercicio(), dados.getDivida().getDivida(), dados.getFormaPagamento());
        DividaFormaPagamentoDTO divida = cacheDivida.computeIfAbsent(key, k -> this.calculoAcrescimoParamatroService.getDividaFormaPagamento(dados.getEntidade(), dados.getExercicio(), dados.getDivida().getDivida(), dados.getFormaPagamento()));
        return divida;
    }

    public List<FormaCorrecao> getFormasCorrecoes() {
        return this.formaCorrecaoService.findByRsql(Optional.empty());
    }

    private Tributo loadTributo(AcrescimoDTO dados) {
        return this.tributoService.findByEntidadeAndExercicioAndTributo(dados.getEntidade(), dados.getExercicio(), dados.getTributo());
    }

    public List<MudancaMonetaria> getMudancasMonetarias() {
        return this.mudancaMonetariaService.findByRsql(Optional.empty());
    }

    public List<Feriado> getFeriados() {
        return this.feriadoService.findAllFeriados();
    }

    public ConfigHonorario getConfiguracaoHonorarioByExercicio(Long exercicio) {
        return this.configHonorarioService.findByExercicio(exercicio);
    }

    private BigDecimal calculaJurosExercicioAtual(CalculaAcrescimoDTO calculaAcrescimoDTO) {
        AcrescimoDTO dados = calculaAcrescimoDTO.getDados();
        EntidadeCorrecaoDTO entidadeCorrecaoAtual = calculaAcrescimoDTO.getParametros().getEntidadeCorrecao();
        BigDecimal valorJurosAplicado = this.calculateJuros(calculaAcrescimoDTO, dados.getDataVencimento(), dados.getDataReferencia(), Integer.valueOf(entidadeCorrecaoAtual.getExercicio().intValue()));
        return this.getValorFinal(valorJurosAplicado, entidadeCorrecaoAtual.getArredondaPorPartesNoCalculo());
    }

    private BigDecimal calculaJurosPorExercicio(CalculaAcrescimoDTO calculaAcrescimoDTO) {
        AcrescimoDTO dados = calculaAcrescimoDTO.getDados();
        BigDecimal total = BigDecimal.ZERO;
        EntidadeCorrecaoDTO entidadeCorrecaoPrincipal = calculaAcrescimoDTO.getParametros().getEntidadeCorrecao();
        for (int anoIterado = dados.getDataVencimento().getYear(); dados.getDataReferencia().getYear() >= anoIterado; ++anoIterado) {
            LocalDate dataInicial = this.mountDataInicialPorExercicio(anoIterado, dados.getDataVencimento(), entidadeCorrecaoPrincipal.getMesJuros());
            LocalDate dataFinal = this.mountDataFinalPorExercicio(anoIterado, dados.getDataReferencia(), entidadeCorrecaoPrincipal.getMesJuros());
            total = total.add(this.calculateJuros(calculaAcrescimoDTO, dataInicial, dataFinal, Integer.valueOf(anoIterado)));
        }
        if (this.deveAcrescentarMaisUmMesParaJuros(dados.getDataReferencia(), dados, entidadeCorrecaoPrincipal)) {
            LocalDate dataInicial = dados.getDataReferencia().with(TemporalAdjusters.firstDayOfMonth());
            LocalDate dataFinal = dados.getDataReferencia().with(TemporalAdjusters.lastDayOfMonth()).plusDays(1L);
            total = total.add(this.calculateJuros(calculaAcrescimoDTO, dataInicial, dataFinal, Integer.valueOf(dados.getDataReferencia().getYear())));
        }
        return this.getValorFinal(total, entidadeCorrecaoPrincipal.getArredondaPorPartesNoCalculo());
    }

    private boolean deveAcrescentarMaisUmMesParaJuros(LocalDate dataFinal, AcrescimoDTO dados, EntidadeCorrecaoDTO entidadeCorrecao) {
        boolean isMaisUmMesDeJuros = 30 - dados.getDataVencimento().getDayOfMonth() + dados.getDataReferencia().getDayOfMonth() >= 30;
        boolean isAnoVencimentoDiferenteDoAnoReferencia = dados.getDataVencimento().getYear() != dados.getDataReferencia().getYear();
        boolean isVencimentoDepoisDoDiaPrimeiro = dados.getDataVencimento().getDayOfMonth() > 1;
        boolean isTipoJurosMesCompleto = entidadeCorrecao.getMesJuros().equals((Object)TipoJuros.MES_COMPLETO);
        boolean isDataFinalIgualDataReferencia = dataFinal.equals(dados.getDataReferencia());
        return isMaisUmMesDeJuros && isAnoVencimentoDiferenteDoAnoReferencia && isVencimentoDepoisDoDiaPrimeiro && isTipoJurosMesCompleto && isDataFinalIgualDataReferencia;
    }

    private LocalDate mountDataInicialPorExercicio(int anoAtual, LocalDate dataVencimento, TipoJuros tipoJuros) {
        if (anoAtual == dataVencimento.getYear()) {
            return dataVencimento;
        }
        if (Arrays.asList(TipoJuros.MES_CORRIDO, TipoJuros.MES_INCOMPLETO).contains(tipoJuros)) {
            return LocalDate.of(anoAtual, Month.JANUARY, dataVencimento.getDayOfMonth());
        }
        return LocalDate.of(anoAtual, Month.JANUARY, 1);
    }

    private LocalDate mountDataFinalPorExercicio(int anoAtual, LocalDate dataReferencia, TipoJuros tipoJuros) {
        if (anoAtual == dataReferencia.getYear()) {
            return dataReferencia;
        }
        LocalDate dataFinal = LocalDate.of(anoAtual, Month.DECEMBER, 31);
        if (TipoJuros.PROXIMO_MES.equals((Object)tipoJuros)) {
            dataFinal = dataFinal.plusDays(1L);
        } else if (TipoJuros.MES_CORRIDO.equals((Object)tipoJuros)) {
            dataFinal = dataFinal.plusDays(32L);
        }
        return dataFinal;
    }

    private void validateEntidadeCorrecaoParaCalculoDeJuros(EntidadeCorrecaoDTO entidadeCorrecao) {
        Assert.notNull((Object)entidadeCorrecao.getMesJuros(), (String)String.format("Entidade corre\u00e7\u00e3o sem m\u00eas juros configurado %s", entidadeCorrecao));
        Assert.notNull((Object)entidadeCorrecao.getJuroMora(), (String)String.format("Entidade corre\u00e7\u00e3o sem juros mora configurado %s", entidadeCorrecao));
    }

    private EntidadeCorrecaoDTO findEntidadeCorrecaoPorExercicio(AcrescimoDTO dados, int exercicio, List<EntidadeCorrecaoDTO> allEntidadeCorrecaoDTO) {
        return this.filterEntidadeCorrecao(Long.valueOf(exercicio), dados.getEntidade(), dados.getDivida().getDivida(), allEntidadeCorrecaoDTO);
    }

    private BigDecimal getAliquotaVariavel(TipoJuros tipoJuros, LocalDate dataInicial, LocalDate dataFinal) {
        return BigDecimal.valueOf(tipoJuros.getCalculoJuros().calculaAliquota(dataInicial, dataFinal));
    }

    private BigDecimal calculateJuros(CalculaAcrescimoDTO calculaAcrescimoDTO, LocalDate dataInicial, LocalDate dataFinal, Integer exercicio) {
        BigDecimal valorComBaseComposta = this.getValorBaseCompostaJuros(calculaAcrescimoDTO.getDados().getValorOriginal(), calculaAcrescimoDTO);
        EntidadeCorrecaoDTO entidadeCorrecaoAtual = this.findEntidadeCorrecaoPorExercicio(calculaAcrescimoDTO.getDados(), exercicio.intValue(), calculaAcrescimoDTO.getParametros().getAllEntidadeCorrecao());
        BigDecimal aliquotaVariavel = this.getAliquotaVariavel(entidadeCorrecaoAtual.getMesJuros(), dataInicial, dataFinal).abs();
        return valorComBaseComposta.multiply(entidadeCorrecaoAtual.getJuroMora()).multiply(aliquotaVariavel).divide(DIVISOR_100);
    }

    private boolean usaCalculoJurosPorExercicio() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.ALIQUOTAJUROSPOREXERCICIO);
    }

    private boolean entidadeCalculaAcrescimoIndiceCorrecaoValorAtual() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CALC_ACRESCIMO_INDICE_CORRECAO_VALOR_ATUAL);
    }

    private BigDecimal getValorBaseCompostaJuros(BigDecimal baseCalculo, CalculaAcrescimoDTO params) {
        return params.deveCalcularBaseComposta() ? this.calculaBaseCompostaJuros(params, baseCalculo) : baseCalculo;
    }

    @Generated
    public CalculoAcrescimoService(CalculoAcrescimoParamatroService calculoAcrescimoParamatroService, CalculoMultaEspecialService calculoMultaEspecialService, DiaUtilService diaUtilService, MudancaMonetariaService mudancaMonetariaService, FormaPagamentoService formaPagamentoService, FormaCorrecaoService formaCorrecaoService, TributoService tributoService, ContextService contextService, FeriadoService feriadoService, ParametroGeralService parametroGeralService, EntityManager entityManager, ConfigHonorarioService configHonorarioService) {
        this.calculoAcrescimoParamatroService = calculoAcrescimoParamatroService;
        this.calculoMultaEspecialService = calculoMultaEspecialService;
        this.diaUtilService = diaUtilService;
        this.mudancaMonetariaService = mudancaMonetariaService;
        this.formaPagamentoService = formaPagamentoService;
        this.formaCorrecaoService = formaCorrecaoService;
        this.tributoService = tributoService;
        this.contextService = contextService;
        this.feriadoService = feriadoService;
        this.parametroGeralService = parametroGeralService;
        this.entityManager = entityManager;
        this.configHonorarioService = configHonorarioService;
    }
}

