/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo;

import br.com.elotech.core.rsql.RsqlSpecification;
import br.com.elotech.tributos.domain.DividaFormaPagamento;
import br.com.elotech.tributos.domain.EntidadeCorrecao;
import br.com.elotech.tributos.dto.acrescimo.DividaFormaPagamentoDTO;
import br.com.elotech.tributos.dto.acrescimo.EntidadeCorrecaoDTO;
import br.com.elotech.tributos.repository.DividaFormaPagamentoRepository;
import br.com.elotech.tributos.repository.DividaRepository;
import br.com.elotech.tributos.repository.EntidadeCorrecaoRepository;
import br.com.elotech.tributos.service.EntidadeCorrecaoService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class CalculoAcrescimoParamatroService {
    private final EntidadeCorrecaoService entidadeCorrecaoService;
    private final DividaRepository dividaRepository;
    private final EntidadeCorrecaoRepository entidadeCorrecaoRepository;
    private final DividaFormaPagamentoRepository dividaFormaPagamentoRepository;
    private final EntityManager entityManager;

    public CalculoAcrescimoParamatroService(EntidadeCorrecaoService entidadeCorrecaoService, DividaRepository dividaRepository, EntidadeCorrecaoRepository entidadeCorrecaoRepository, DividaFormaPagamentoRepository dividaFormaPagamentoRepository, EntityManager entityManager) {
        this.entidadeCorrecaoService = entidadeCorrecaoService;
        this.dividaRepository = dividaRepository;
        this.entidadeCorrecaoRepository = entidadeCorrecaoRepository;
        this.dividaFormaPagamentoRepository = dividaFormaPagamentoRepository;
        this.entityManager = entityManager;
    }

    public EntidadeCorrecaoDTO getEntidadeCorrecao(Long entidade, Long exercicio, Optional<Long> divida) {
        EntidadeCorrecao entity = this.entidadeCorrecaoService.getEntidadeCorrecao(entidade, exercicio, divida);
        return Objects.nonNull(entity) ? EntidadeCorrecaoDTO.of((EntidadeCorrecao)entity) : null;
    }

    public List<EntidadeCorrecaoDTO> getAllEntidadesCorrecoes(Long entidade) {
        return this.entidadeCorrecaoService.getAllEntidadesCorrecao(entidade).stream().map(EntidadeCorrecaoDTO::of).collect(Collectors.toList());
    }

    public List<EntidadeCorrecaoDTO> getEntidadesCorrecaoByEntidade(Long entidade) {
        StringBuilder rsqlBuilder = new StringBuilder();
        Page result = this.entidadeCorrecaoRepository.findAll((Specification)new RsqlSpecification(this.entityManager, rsqlBuilder.append(String.format("id.entidade == %d", entidade)).toString()), (Pageable)PageRequest.of((int)0, (int)20));
        return result.getContent().stream().map(EntidadeCorrecaoDTO::of).collect(Collectors.toList());
    }

    public DividaFormaPagamentoDTO getDividaFormaPagamento(Long entidade, Long exercicio, Long divida, Long formaPagamento) {
        DividaFormaPagamento dividaFormaPagamento = this.dividaFormaPagamentoRepository.findByEntidadeAndExercicioAndGuiaRecolhimentoAndFormaPagamentoId(entidade, exercicio, divida, formaPagamento);
        return Optional.ofNullable(dividaFormaPagamento).map(DividaFormaPagamentoDTO::of).orElse(null);
    }
}

