/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.repository.VinculoRepository;
import java.util.List;
import javax.persistence.EntityNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class VinculoService
extends CrudService<Vinculo, Long> {
    private final VinculoRepository vinculoRepository;

    public VinculoService(VinculoRepository vinculoRepository) {
        this.vinculoRepository = vinculoRepository;
    }

    public List<Vinculo> findVinculoDevedorSolidarioAndCadastroAvulso() {
        return this.vinculoRepository.findByTipoVinculoAndTiposCadastroAndAtivoTrue(TipoVinculo.DEVEDORSOLIDARIO, TipoCadastro.AVULSO);
    }

    public Vinculo findVinculoByTipoVinculo(TipoVinculo tipoVinculo) {
        return (Vinculo)this.vinculoRepository.findByTipoVinculo(tipoVinculo).stream().findFirst().orElseThrow(() -> new EntityNotFoundException(String.format("N\u00e3o foi encontrado Vinculo com o tipo %s", tipoVinculo.getDescricao())));
    }
}

