/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.TipoProprietarioItbi;
import br.com.elotech.tributos.service.CadastroGeralObservacaoService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ItbiService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.ProprietarioService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferenciaItbiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferenciaItbiService.class);
    private final PagamentoService pagamentoService;
    private final ItbiService itbiService;
    private final CadastroGeralObservacaoService cadastroGeralObservacaoService;
    private final CadastroGeralService cadastroGeralService;
    private final ProprietarioService proprietarioService;

    public TransferenciaItbiService(PagamentoService pagamentoService, ItbiService itbiService, CadastroGeralObservacaoService cadastroGeralObservacaoService, CadastroGeralService cadastroGeralService, ProprietarioService proprietarioService) {
        this.pagamentoService = pagamentoService;
        this.itbiService = itbiService;
        this.cadastroGeralObservacaoService = cadastroGeralObservacaoService;
        this.cadastroGeralService = cadastroGeralService;
        this.proprietarioService = proprietarioService;
    }

    @Transactional
    public void validaTransferenciaItbi(Pagamento pagamento) {
        LOGGER.debug("Verificando transfer\u00eancia de ITBI do pagamento {}/{}", (Object)pagamento.getId().getPagamento(), (Object)pagamento.getId().getExercicioPagamento());
        List debitosId = this.pagamentoService.findIdDebitoItbiListByPagamento(pagamento);
        if (!debitosId.isEmpty()) {
            LOGGER.info("Encontrados {} d\u00e9bitos para o pagamento {}/{}", new Object[]{debitosId.size(), pagamento.getId().getPagamento(), pagamento.getId().getExercicioPagamento()});
            debitosId.forEach(debito -> LOGGER.debug("-> {}", debito));
            List<ImobiliarioItbi> imobiliarioItbis = debitosId.stream().map(arg_0 -> ((ItbiService)this.itbiService).findImobiliarioItbiByDebito(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
            LOGGER.info("Encontrados {} ITBIs para transfer\u00eancia", (Object)imobiliarioItbis.size());
            imobiliarioItbis.forEach(imobiliarioItbi -> {
                LOGGER.info("Processando ITBI {}/{} do cadastro {}", new Object[]{imobiliarioItbi.getCodigoItbi(), imobiliarioItbi.getExercicio(), imobiliarioItbi.getCadastroGeral()});
                Optional cadastroGeral = this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(imobiliarioItbi.getTipoCadastro(), imobiliarioItbi.getCadastroGeral());
                if (cadastroGeral.isPresent()) {
                    LOGGER.info("Identificado cadastro {} com id {}", (Object)((CadastroGeral)cadastroGeral.get()).getCadastroGeral(), (Object)((CadastroGeral)cadastroGeral.get()).getId());
                    this.transfereItbi(imobiliarioItbi, (CadastroGeral)cadastroGeral.get());
                } else {
                    LOGGER.info(String.format("N\u00e3o foi poss\u00edvel efetuar a transfer\u00eancia do ITBI(%s) devido ao cadastro geral %s estar em exclus\u00e3o l\u00f3gica.", imobiliarioItbi.getId(), imobiliarioItbi.getCadastroGeral()));
                }
            });
        }
    }

    private void transfereItbi(ImobiliarioItbi imobiliarioItbi, CadastroGeral cadastroGeral) {
        List proprietariosAtuais = imobiliarioItbi.getProprietarios().stream().filter(proprietarioItbi -> TipoProprietarioItbi.ATUAL.equals((Object)proprietarioItbi.getId().getTipoProprietarioItbi())).collect(Collectors.toList());
        LOGGER.info("Transferindo ITBI n\u00famero {}/{} do cadastro geral {} com id {}", new Object[]{imobiliarioItbi.getCodigoItbi(), imobiliarioItbi.getExercicio(), imobiliarioItbi.getCadastroGeral(), cadastroGeral.getId()});
        this.atualizaObservacao(cadastroGeral, imobiliarioItbi);
        this.proprietarioService.atualizaProprietarios(cadastroGeral, proprietariosAtuais);
        this.itbiService.atualizaSituacaoItbiParaTransferido(imobiliarioItbi);
    }

    private void atualizaObservacao(CadastroGeral cadastroGeral, ImobiliarioItbi imobiliarioItbi) {
        String vendedores = imobiliarioItbi.getProprietarios().stream().filter(proprietarioItbi -> TipoProprietarioItbi.VENDEDOR.equals((Object)proprietarioItbi.getId().getTipoProprietarioItbi())).map(vendedor -> vendedor.getId().getPessoa().getNome()).collect(Collectors.joining(","));
        String compradores = imobiliarioItbi.getProprietarios().stream().filter(proprietarioItbi -> TipoProprietarioItbi.COMPRADOR.equals((Object)proprietarioItbi.getId().getTipoProprietarioItbi())).map(comprador -> comprador.getId().getPessoa().getNome()).collect(Collectors.joining(","));
        String textoObservacao = String.format("TRANSFER\u00caNCIA DE PROPRIEDADE DO CADASTRO %d, PROPRIET\u00c1RIO(S) ATUAL(IS):%n%s%nPARA O(S) COMPRADOR(ES):%n%s.", cadastroGeral.getCadastroGeral(), vendedores, compradores);
        if (cadastroGeral.possuiIsencaoCadastrada().booleanValue()) {
            Long idIsencaoPadrao = 0L;
            String isencoes = cadastroGeral.getCadastroGeralIsencoes().stream().map(isencao -> isencao.getId().toString()).collect(Collectors.joining(","));
            String observacaoIsencao = String.format("%nRETIRADA(S) ISEN\u00c7\u00c3O(\u00d5ES) (%s) CONFORME PROCESSO DE ITBI N\u00ba N\u00daMERO ITBI (%s).", isencoes, imobiliarioItbi.getId());
            textoObservacao = textoObservacao.concat(observacaoIsencao);
            cadastroGeral.getCadastroGeralIsencoes().removeIf(cadastroGeralIsencao -> cadastroGeralIsencao.getIsencao().getId() > idIsencaoPadrao);
        }
        cadastroGeral.getObservacoes().add(this.cadastroGeralObservacaoService.geraObservacao(cadastroGeral, textoObservacao, "SISTEMA"));
        this.cadastroGeralService.save((EloEntity)cadastroGeral, null);
    }
}

