/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.SetorQuadra;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.repository.SetorQuadraRepository;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import de.danielbechler.util.Assert;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;

@Service
public class SetorQuadraService
extends CrudService<SetorQuadra, Long> {
    private final SetorQuadraRepository setorQuadraRepository;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    public SetorQuadraService(SetorQuadraRepository setorQuadraRepository, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.setorQuadraRepository = setorQuadraRepository;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }

    public SetorQuadra findBySetorDistritoDistritoAndSetorSetorAndQuadra(String distrito, String setor, String quadra) {
        return this.setorQuadraRepository.findBySetorDistritoDistritoAndSetorSetorAndQuadra(distrito, setor, quadra);
    }

    private boolean existsSetorQuadra(SetorQuadra setorQuadra) {
        return Objects.nonNull(this.setorQuadraRepository.findBySetorDistritoDistritoAndSetorSetorAndQuadra(setorQuadra.getSetor().getDistrito().getDistrito(), setorQuadra.getSetor().getSetor(), setorQuadra.getQuadra()));
    }

    private void validaSetorQuadra(SetorQuadra setorQuadra) {
        ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
        Assert.notNull((Object)setorQuadra.getSetor(), (String)String.format("%s n\u00e3o pode ser nulo.", configuracao.getSetor().getDescricao()));
        Assert.notNull((Object)setorQuadra.getSetor().getDistrito(), (String)String.format("%s n\u00e3o pode ser nulo.", configuracao.getDistrito().getDescricao()));
    }

    protected void beforeInsert(SetorQuadra setorQuadra) {
        ConfiguracaoInscricaoCadastral configuracao = this.configuracaoInscricaoCadastralService.getConfiguracao();
        this.validaSetorQuadra(setorQuadra);
        if (this.existsSetorQuadra(setorQuadra)) {
            throw new EloValidationException(String.format("%s: %s, %s: %s e %s: %s j\u00e1 existe.", configuracao.getDistrito().getDescricao(), setorQuadra.getSetor().getDistrito().getDistrito(), configuracao.getSetor().getDescricao(), setorQuadra.getSetor().getSetor(), configuracao.getQuadra().getDescricao(), setorQuadra.getQuadra()));
        }
        setorQuadra.setCodigoDistrito(setorQuadra.getSetor().getDistrito().getDistrito());
        setorQuadra.setCodigoSetor(setorQuadra.getSetor().getSetor());
        super.beforeInsert((EloEntity)setorQuadra);
    }

    protected void beforeEdit(SetorQuadra setorQuadra) {
        this.validaSetorQuadra(setorQuadra);
        super.beforeEdit((EloEntity)setorQuadra);
    }

    public List<SetorQuadra> findByLoteamentoId(Long loteamento) {
        return this.setorQuadraRepository.findByLoteamentoId(loteamento);
    }
}

