/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.enumerable.common.SimNao;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroEntidadeEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.ParametroEntidadeService;
import br.com.elotech.tributos.service.ParametroGeralService;
import org.apache.commons.lang3.NotImplementedException;
import org.springframework.stereotype.Service;

@Service(value="sequenceCadastroGeralService")
public class SequenceCadastroGeralService {
    private static final String SEQUENCE_IMOBILIARIO_CODIGO = "S05CODIGOIMOBILIARIO";
    private static final String SEQUENCE_IMOBILIARIO_CADASTRO = "S05CDSCADASTROIMOBILIARIO";
    private static final String SEQUENCE_AVULSO = "S05CDSCADASTROAVULSO";
    private static final String SEQUENCE_MOBILIARIO = "S05CDSCADASTROMOBILIARIO";
    private static final String SEQUENCE_RURAL = "S05CDSCADASTRORURAL";
    private final ParametroGeralService parametroGeralService;
    private final ParametroEntidadeService parametroEntidadeService;

    public SequenceCadastroGeralService(ParametroGeralService parametroGeralService, ParametroEntidadeService parametroEntidadeService) {
        this.parametroGeralService = parametroGeralService;
        this.parametroEntidadeService = parametroEntidadeService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getExpression(CadastroGeral cadastroGeral) {
        StringBuilder sequenceName = new StringBuilder();
        if (cadastroGeral.getTipoCadastro().isImobiliario().booleanValue()) {
            boolean utilizaSetorImobiliario = this.utilizaSetorImobiliario();
            boolean informaCadastroImobiliarioManual = this.informaCadastroImobiliarioManual();
            boolean codigoImobiliarioSequencial = this.codigoImobiliarioSequencial();
            if (!(utilizaSetorImobiliario || informaCadastroImobiliarioManual || codigoImobiliarioSequencial)) {
                sequenceName.append(SEQUENCE_IMOBILIARIO_CADASTRO);
                return sequenceName.toString();
            } else {
                if (!codigoImobiliarioSequencial) throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel buscar a sequ\u00eancia do cadastro com a seguinte configura\u00e7\u00e3o de par\u00e2metros: %s = %s, %s = %s, %s = %s.", ParametroEntidadeEnum.UTILIZA_SETOR_IMOBILIARIO.getValue(), SimNao.fromBoolean((Boolean)utilizaSetorImobiliario), ParametroEntidadeEnum.INFORMA_CADASTRO_MANUAL.getValue(), SimNao.fromBoolean((Boolean)informaCadastroImobiliarioManual), ParametroGeralEnum.CODIGO_IMOBILIARIO_SEQUENCIAL.getValue(), SimNao.fromBoolean((Boolean)codigoImobiliarioSequencial)));
                sequenceName.append(SEQUENCE_IMOBILIARIO_CODIGO);
            }
            return sequenceName.toString();
        } else if (cadastroGeral.getTipoCadastro().isMobiliario().booleanValue()) {
            sequenceName.append(SEQUENCE_MOBILIARIO);
            return sequenceName.toString();
        } else if (cadastroGeral.getTipoCadastro().isRural().booleanValue()) {
            if (this.informaCadastroRuralManual()) return sequenceName.toString();
            sequenceName.append(SEQUENCE_RURAL);
            return sequenceName.toString();
        } else {
            if (!cadastroGeral.getTipoCadastro().isAvulso().booleanValue()) throw new NotImplementedException("N\u00e3o foi implementado o gerenciamento da sequ\u00eancia para este Tipo de Cadastro");
            sequenceName.append(SEQUENCE_AVULSO);
        }
        return sequenceName.toString();
    }

    private boolean utilizaSetorImobiliario() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.UTILIZA_SETOR_IMOBILIARIO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean informaCadastroImobiliarioManual() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.INFORMA_CADASTRO_MANUAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean informaCadastroRuralManual() {
        return this.parametroEntidadeService.getParamValueAsBoolean(ParametroEntidadeEnum.INFORMA_CADASTRO_RURAL_MANUAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }

    private boolean codigoImobiliarioSequencial() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CODIGO_IMOBILIARIO_SEQUENCIAL, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

