/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.ProtestoRemessaItemDTO;
import br.com.elotech.tributos.repository.ProtestoRemessaItemRepository;
import br.com.elotech.tributos.util.LongUtils;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ProtestoRemessaItemService
extends CrudService<ProtestoRemessaItem, Long> {
    private final ProtestoRemessaItemRepository protestoRemessaItemRepository;

    public void saveAll(List<ProtestoRemessaItem> protestos) {
        this.protestoRemessaItemRepository.saveAll(protestos);
    }

    public List<ProtestoRemessaItem> findByProtestoRemessa(ProtestoRemessa protestoRemessa) {
        return this.protestoRemessaItemRepository.findByProtestoRemessa(protestoRemessa);
    }

    public Optional<ProtestoRemessaItem> findByProtesto(Protesto protesto) {
        return this.protestoRemessaItemRepository.findFirstByProtestoOrderByIdDesc(protesto);
    }

    public Long findNextSequence(Long entidade, Long exercicio, Long remessa) {
        return LongUtils.incrementAndGet((Long)this.protestoRemessaItemRepository.findLastSequence(entidade, exercicio, remessa));
    }

    public ProtestoRemessaItem create(ProtestoRemessa protestoRemessa, Protesto protesto, Long sequencia) {
        ProtestoRemessaItem protestoRemessaItem = new ProtestoRemessaItem();
        protestoRemessaItem.setProtesto(protesto);
        protestoRemessaItem.setCodigoProtesto(protesto.getProtesto());
        protestoRemessaItem.setProtestoRemessa(protestoRemessa);
        protestoRemessaItem.setSequencia(sequencia);
        protestoRemessaItem.setExercicioDocumento(protesto.getDocumento().getExercicio());
        protestoRemessaItem.setTipoDocumento(protesto.getDocumento().getTipoDocumento());
        protestoRemessaItem.setDocumento(protesto.getDocumento().getDocumento());
        protestoRemessaItem.setCadastroGeral(protesto.getDocumento().getCodigoCadastroGeral());
        protestoRemessaItem.setTipoCadastro(protesto.getDocumento().getTipoCadastro().getValue());
        protestoRemessaItem.setPessoa(protesto.getDocumento().getPessoa());
        protestoRemessaItem.setExercicioProtesto(protesto.getExercicio());
        protestoRemessaItem.setVinculo((Long)Optional.ofNullable(protesto.getDocumento()).map(Documento::getCadastroGeral).map(CadastroGeral::getProprietarioPrincipal).flatMap(optional -> optional).map(Proprietario::getVinculo).map(Vinculo::getTipoVinculo).map(TipoVinculo::getValue).orElse(null));
        return protestoRemessaItem;
    }

    public List<ProtestoRemessaItem> createItens(ProtestoRemessa protestoRemessa, Protesto protesto, AtomicLong sequencia) {
        return protesto.getDocumento().getDocumentoPessoas().stream().map(documentoPessoa -> {
            ProtestoRemessaItem protestoRemessaItem = new ProtestoRemessaItem();
            protestoRemessaItem.setProtesto(protesto);
            protestoRemessaItem.setCodigoProtesto(protesto.getProtesto());
            protestoRemessaItem.setProtestoRemessa(protestoRemessa);
            protestoRemessaItem.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
            protestoRemessaItem.setExercicioDocumento(protesto.getDocumento().getExercicio());
            protestoRemessaItem.setTipoDocumento(protesto.getDocumento().getTipoDocumento());
            protestoRemessaItem.setDocumento(protesto.getDocumento().getDocumento());
            protestoRemessaItem.setCadastroGeral(protesto.getDocumento().getCodigoCadastroGeral());
            protestoRemessaItem.setTipoCadastro(protesto.getDocumento().getTipoCadastro().getValue());
            protestoRemessaItem.setPessoa(documentoPessoa.getPessoa());
            protestoRemessaItem.setExercicioProtesto(protesto.getExercicio());
            TipoVinculo vinculo = Boolean.TRUE.equals(documentoPessoa.getPrincipal()) ? TipoVinculo.PRINCIPAL : TipoVinculo.SOCIO;
            protestoRemessaItem.setVinculo(vinculo.getValue());
            return protestoRemessaItem;
        }).collect(Collectors.toList());
    }

    public List<ProtestoRemessaItemDTO> findByProtestoRemessaAndBuildProtestoRemessaItemDTO(ProtestoRemessa protestoRemessa) {
        return this.findByProtestoRemessa(protestoRemessa).stream().map(ProtestoRemessaItemDTO::new).collect(Collectors.toList());
    }

    @Generated
    public ProtestoRemessaItemService(ProtestoRemessaItemRepository protestoRemessaItemRepository) {
        this.protestoRemessaItemRepository = protestoRemessaItemRepository;
    }
}

