/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.ProprietarioItbi;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.VinculoService;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProprietarioService
extends CrudService<Proprietario, Long> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProprietarioService.class);
    private final CadastroGeralService cadastroGeralService;
    private final VinculoService vinculoService;

    public ProprietarioService(CadastroGeralService cadastroGeralService, VinculoService vinculoService) {
        this.cadastroGeralService = cadastroGeralService;
        this.vinculoService = vinculoService;
    }

    void atualizaProprietarios(CadastroGeral cadastroGeral, List<ProprietarioItbi> proprietariosItbi) {
        cadastroGeral.getProprietarios().removeIf(proprietario -> proprietariosItbi.stream().noneMatch(proprietarioItbi -> proprietario.getPessoa().getId().equals(proprietarioItbi.getId().getPessoa().getId())));
        proprietariosItbi.stream().filter(proprietarioItbi -> cadastroGeral.getProprietarios().stream().noneMatch(proprietario -> proprietario.getPessoa().getId().equals(proprietarioItbi.getId().getPessoa().getId()))).forEach(proprietarioItbi -> {
            Proprietario novoProprietario = this.createProprietario(cadastroGeral, proprietarioItbi);
            cadastroGeral.getProprietarios().add(novoProprietario);
        });
        cadastroGeral.getProprietarios().forEach(proprietario -> {
            Optional<ProprietarioItbi> proprietarioItbiOptional = proprietariosItbi.stream().filter(proprietarioItbi -> proprietarioItbi.getId().getPessoa().getId().equals(proprietario.getPessoa().getId())).findFirst();
            proprietarioItbiOptional.ifPresent(proprietarioItbi -> {
                proprietario.setPercentual(proprietarioItbi.getPercentual());
                proprietario.setPrincipal(proprietarioItbi.getPrincipal());
                if (proprietarioItbi.getPrincipal().booleanValue()) {
                    cadastroGeral.setPessoa(proprietario.getPessoa());
                    cadastroGeral.setDataAlteracao(LocalDate.now());
                }
            });
        });
        LOGGER.info("Salvando dados do cadastro {} com id {}", (Object)cadastroGeral.getCadastroGeral(), (Object)cadastroGeral.getId());
        cadastroGeral.getProprietarios().forEach(proprietario -> LOGGER.debug("-> Propriet\u00e1rio {} pessoa {} cadastro com id {}", new Object[]{proprietario.getId(), proprietario.getPessoa().getId(), proprietario.getCadastroGeral().getId()}));
        this.cadastroGeralService.save((EloEntity)cadastroGeral, null);
    }

    private Proprietario createProprietario(CadastroGeral cadastroGeral, ProprietarioItbi proprietarioItbi) {
        Proprietario proprietario = new Proprietario();
        proprietario.setPessoa(proprietarioItbi.getId().getPessoa());
        proprietario.setCadastroGeral(cadastroGeral);
        proprietario.setVinculo((Vinculo)this.vinculoService.findOne((Serializable)proprietarioItbi.getVinculo()));
        proprietario.setPercentual(proprietarioItbi.getPercentual());
        proprietario.setPrincipal(proprietarioItbi.getPrincipal());
        return proprietario;
    }
}

