/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalheId;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.BaixaAutomaticaCadastroDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.service.BaixaAutomaticaDetalheService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.TipoMensagemService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessaPagamentoLoteSiafiService {
    private final BaixaAutomaticaDetalheService baixaAutomaticaDetalheService;
    private final TipoMensagemService tipoMensagemService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final DividaService dividaService;
    private final GeraBoletoService geraBoletoService;
    private final EntityManager entityManager;
    private final GeraDebitoService geraDebitoService;
    private final ModeloBoletoService modeloBoletoService;

    public ProcessaPagamentoLoteSiafiService(BaixaAutomaticaDetalheService baixaAutomaticaDetalheService, TipoMensagemService tipoMensagemService, ParametroEntidadeExercicioService parametroEntidadeExercicioService, DividaService dividaService, GeraBoletoService geraBoletoService, EntityManager entityManager, GeraDebitoService geraDebitoService, ModeloBoletoService modeloBoletoService) {
        this.baixaAutomaticaDetalheService = baixaAutomaticaDetalheService;
        this.tipoMensagemService = tipoMensagemService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.dividaService = dividaService;
        this.geraBoletoService = geraBoletoService;
        this.entityManager = entityManager;
        this.geraDebitoService = geraDebitoService;
        this.modeloBoletoService = modeloBoletoService;
    }

    public BaixaAutomaticaDetalhe verificarLoteSequencia(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        BaixaAutomaticaCadastroDTO cadastro = this.baixaAutomaticaDetalheService.findCadastroSiafi(baixaAutomaticaDetalhe.getNossoNumero());
        if (Objects.isNull(cadastro)) {
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.CADASTRO_MOBILIARIO_NAO_ENCONTRADO);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.CADASTRO_MOBILIARIO_NAO_ENCONTRADO.getDescricao());
            return baixaAutomaticaDetalhe;
        }
        Optional dividaSiafi = this.getCodigoDividaSiafi();
        if (!dividaSiafi.isPresent()) {
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.DIVIDA_SIAFI_NAO_ENCONTRADA);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.DIVIDA_SIAFI_NAO_ENCONTRADA.getDescricao());
            return baixaAutomaticaDetalhe;
        }
        Optional dividaTributoPadrao = this.getDividaTributo(baixaAutomaticaDetalhe.getId().getEntidade(), baixaAutomaticaDetalhe.getAnoMovimento(), (Long)dividaSiafi.get());
        if (!dividaTributoPadrao.isPresent()) {
            TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.RECEITA_PADRAO_NAO_ENCONTRADA);
            baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
            baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
            baixaAutomaticaDetalhe.setMensagem(TipoMensagemEnum.RECEITA_PADRAO_NAO_ENCONTRADA.getDescricao());
            return baixaAutomaticaDetalhe;
        }
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_VALIDADO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagem(String.format("D\u00edvida %d validada com sucesso", dividaSiafi.get()));
        return baixaAutomaticaDetalhe;
    }

    private Optional<Long> getCodigoDividaSiafi() {
        return this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.DIVIDA_BAIXA_SIAFI).map(ParametroEntidadeExercicio::getValor).map(Long::valueOf);
    }

    private Optional<DividaTributo> getDividaTributo(Long entidade, Long exercicio, Long codigoDivida) {
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, codigoDivida).orElseThrow(() -> new EloValidationException(String.format("D\u00edvida %d n\u00e3o encontrada no exerc\u00edcio %d para entidade %d", codigoDivida, exercicio, entidade)));
        return divida.getTributos().stream().filter(DividaTributo::getReceitaPadrao).findFirst();
    }

    public BaixaAutomaticaDetalhe gerarDebitoEBoleto(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        DebitoIdDTO debitoGerado = this.geraDebito(baixaAutomaticaDetalhe);
        ModeloBoleto modeloBoleto = this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia();
        this.entityManager.flush();
        DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
        debitoParcelaDTO.setIdDebito(debitoGerado.getIdDebito());
        debitoParcelaDTO.setParcela(Long.valueOf(1L));
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.PARCELADO);
        geraBoletoDTO.setDebitos(Collections.singletonList(debitoParcelaDTO));
        geraBoletoDTO.setModeloBoleto(modeloBoleto);
        Bloqueto boleto = (Bloqueto)this.geraBoletoService.geraBoletoSuperSimples(geraBoletoDTO).stream().findFirst().orElseThrow(() -> new IllegalStateException("Erro ao gerar boleto"));
        boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.DEBITO_GERADO);
        baixaAutomaticaDetalhe.setIdDebitoOperacao(debitoGerado.getIdDebito());
        baixaAutomaticaDetalhe.setParcelaOperacao(Long.valueOf(1L));
        baixaAutomaticaDetalhe.setBoleto(boleto);
        baixaAutomaticaDetalhe.setValor(boleto.getValorBloqueto());
        return baixaAutomaticaDetalhe;
    }

    private DebitoIdDTO geraDebito(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        BaixaAutomaticaCadastroDTO cadastro = this.baixaAutomaticaDetalheService.findCadastroSiafi(baixaAutomaticaDetalhe.getNossoNumero());
        Long dividaSiafi = (Long)this.getCodigoDividaSiafi().orElseThrow(() -> new EloValidationException("N\u00e3o foi poss\u00edvel encontrar a d\u00edvida do SIAFI."));
        DividaTributo dividaTributo = (DividaTributo)this.getDividaTributo(baixaAutomaticaDetalhe.getId().getEntidade(), baixaAutomaticaDetalhe.getAnoMovimento(), dividaSiafi).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o tributo padr\u00e3o da d\u00edvida %d/%d.", dividaSiafi, baixaAutomaticaDetalhe.getAnoMovimento())));
        BigDecimal valor = baixaAutomaticaDetalhe.getValorPagoPrincipal().subtract(baixaAutomaticaDetalhe.getValorPagoMulta()).subtract(baixaAutomaticaDetalhe.getValorPagoJuros());
        DebitoManualTributoDTO tributo = new DebitoManualTributoDTO();
        tributo.setTributo(dividaTributo.getTributo().getTributo());
        tributo.setOrdem(dividaTributo.getOrdem());
        tributo.setValorTributo(valor);
        DebitoManualParcelaDTO parcela = new DebitoManualParcelaDTO();
        parcela.setParcela(Long.valueOf(1L));
        parcela.setMesReferencia(baixaAutomaticaDetalhe.getMesMovimento());
        parcela.setAnoReferencia(baixaAutomaticaDetalhe.getAnoMovimento());
        parcela.setDataVencimento(this.getDataVencimento(baixaAutomaticaDetalhe));
        parcela.setValor(valor);
        DebitoManualObservacaoDTO observacao = new DebitoManualObservacaoDTO();
        BaixaAutomaticaDetalheId idBaixaAutomatica = baixaAutomaticaDetalhe.getId();
        observacao.setObservacao(String.format("D\u00e9bito gerado pela baixa autom\u00e1tica de lote %d/%d sequencia %d", idBaixaAutomatica.getLote(), idBaixaAutomatica.getExercicio(), idBaixaAutomatica.getSequenciaArquivo()));
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(baixaAutomaticaDetalhe.getId().getExercicio());
        debitoManualDTO.setDataLancamento(baixaAutomaticaDetalhe.getPagamentoLote().getDataMovimento());
        debitoManualDTO.setDivida(dividaSiafi);
        debitoManualDTO.setTipoCadastro(TipoCadastro.fromValue((Long)cadastro.getTipoCadastro()));
        debitoManualDTO.setCadastroGeral(cadastro.getCadastroGeral());
        debitoManualDTO.setPrograma(JobType.BAIXA_AUTOMATICA.getTipo());
        debitoManualDTO.getTributos().add(tributo);
        debitoManualDTO.getParcelas().add(parcela);
        debitoManualDTO.getObservacoes().add(observacao);
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }

    private LocalDate getDataVencimento(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe) {
        Boolean usaDataVencimentoDoArquivo = this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO, ParametroEntidadeExercicioEnum.UTILIZA_VENCIMENTO_ARQUIVO_SIAFI).map(ParametroEntidadeExercicio::getValor).map("S"::equals).orElse(Boolean.FALSE);
        if (usaDataVencimentoDoArquivo.booleanValue()) {
            return baixaAutomaticaDetalhe.getDataVencimento();
        }
        return LocalDate.of(baixaAutomaticaDetalhe.getAnoMovimento().intValue(), baixaAutomaticaDetalhe.getMesMovimento().intValue(), 20).plusMonths(1L);
    }
}

