/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import br.com.elotech.tributos.domain.TipoOperacaoDebito;
import br.com.elotech.tributos.domain.pagamento.BaixaAutomaticaDetalhe;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagem;
import br.com.elotech.tributos.domain.tipomensagem.TipoMensagemEnum;
import br.com.elotech.tributos.dto.BaixaAutomaticaBloquetoAgrupadoFintelDTO;
import br.com.elotech.tributos.dto.BaixaAutomaticaBloquetoFintelDTO;
import br.com.elotech.tributos.dto.BaixaAutomaticaBloquetoValoresFintelDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualIssDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ParametrosFintelDTO;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.ExercicioService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.TipoMensagemService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.ws.client.core.support.WebServiceGatewaySupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Service
@Transactional
public class ProcessaPagamentoLoteFintelService
extends WebServiceGatewaySupport {
    private final DividaService dividaService;
    private final TipoMensagemService tipoMensagemService;
    private final GeraDebitoService geraDebitoService;
    private final GeraBoletoService geraBoletoService;
    private final EntityManager entityManager;
    private final ExercicioService exercicioService;
    private final DebitoService debitoService;
    @Autowired
    private RestTemplate restTemplate;

    private String extractDataContent(String soapXml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(soapXml)));
            Node tag = document.getElementsByTagName("return").item(0);
            return tag.getTextContent();
        }
        catch (Exception e) {
            throw new EloValidationException("Falha ao extrair conte\u00fado do XML. " + e.getMessage());
        }
    }

    private BaixaAutomaticaBloquetoFintelDTO unmarshalRetorno(String xmlRetorno) {
        try {
            if (xmlRetorno.contains("ISS-e: guia n\u00e3o encontrada")) {
                return null;
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{BaixaAutomaticaBloquetoFintelDTO.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return (BaixaAutomaticaBloquetoFintelDTO)unmarshaller.unmarshal((Reader)new StringReader(xmlRetorno));
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao converter XML de retorno da integra\u00e7\u00e3o com a FINTEL. " + e.getMessage());
        }
    }

    private String callSoapWebService(String soapAction, String xmlRequest, ParametrosFintelDTO parametrosFintelDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_XML);
        headers.set("SOAPAction", soapAction);
        HttpEntity request = new HttpEntity((Object)xmlRequest, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(parametrosFintelDTO.getSoapEndPointUrl(), HttpMethod.POST, request, String.class, new Object[0]);
        return (String)response.getBody();
    }

    private String createSoapRequest(String bodyName, Map<String, String> parameters, String soapURI) throws SOAPException, IOException {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
        SOAPBody soapBody = soapEnvelope.getBody();
        SOAPFactory soapFactory = SOAPFactory.newInstance();
        Name soapBodyName = soapFactory.createName(bodyName, "", soapURI);
        SOAPBodyElement bodyElement = soapBody.addBodyElement(soapBodyName);
        TreeMap<String, String> sortedParameters = new TreeMap<String, String>(parameters);
        for (Map.Entry entry : sortedParameters.entrySet()) {
            SOAPElement element = bodyElement.addChildElement((String)entry.getKey());
            element.addTextNode((String)entry.getValue());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)out);
        return out.toString();
    }

    private String mountXMLGetBloqueto(String key, String nossoNumero, String soapUri) throws SOAPException, IOException {
        return this.createSoapRequest("getGuiaById", Map.of("key", key, "nosnum", nossoNumero), soapUri);
    }

    private String mountXMLLoginRequest(ParametrosFintelDTO parametrosFintelDTO) throws SOAPException, IOException {
        String usuarioFintel = parametrosFintelDTO.getUsuarioFintel();
        String senhaFintel = parametrosFintelDTO.getSenhaFintel();
        return this.createSoapRequest("Login", Map.of("login", usuarioFintel, "pwd", senhaFintel), parametrosFintelDTO.getSoapUri());
    }

    private String realizarLogin(ParametrosFintelDTO parametrosFintelDTO) throws EloValidationException {
        String soapActionLogin = parametrosFintelDTO.getSoapEndPointUrl() + "/Login";
        try {
            String response = this.callSoapWebService(soapActionLogin, this.mountXMLLoginRequest(parametrosFintelDTO), parametrosFintelDTO);
            return this.extractDataContent(response);
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao chamar servi\u00e7o SOAP de Login da FINTEL: " + e.getMessage());
        }
    }

    private String buscarGuia(String token, String nossoNumero, ParametrosFintelDTO parametrosFintelDTO) throws EloValidationException {
        String soapActionGuia = parametrosFintelDTO.getSoapEndPointUrl() + "/GetGuiaById";
        try {
            return this.callSoapWebService(soapActionGuia, this.mountXMLGetBloqueto(token, nossoNumero, parametrosFintelDTO.getSoapUri()), parametrosFintelDTO);
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao chamar servi\u00e7o SOAP para buscar guia da FINTEL: " + e.getMessage());
        }
    }

    private BaixaAutomaticaBloquetoFintelDTO processarRetorno(String responseXml) throws EloValidationException {
        try {
            String dataContent = this.extractDataContent(responseXml);
            return Objects.nonNull(dataContent) ? this.unmarshalRetorno(dataContent) : null;
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao converter XML de retorno da integra\u00e7\u00e3o com a FINTEL: " + e.getMessage());
        }
    }

    public BaixaAutomaticaBloquetoFintelDTO loadBloquetoFintel(String nossoNumero, ParametrosFintelDTO parametrosFintelDTO) {
        try {
            String token = this.realizarLogin(parametrosFintelDTO);
            String responseXml = this.buscarGuia(token, nossoNumero, parametrosFintelDTO);
            return this.processarRetorno(responseXml);
        }
        catch (EloValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EloValidationException("Erro inesperado na integra\u00e7\u00e3o com a FINTEL: " + e.getMessage());
        }
    }

    private boolean validaBoletoZerado(BaixaAutomaticaBloquetoFintelDTO bloquetoFintel) {
        boolean retorno = false;
        for (BaixaAutomaticaBloquetoAgrupadoFintelDTO valores : bloquetoFintel.getValoresAgrupados()) {
            BigDecimal valorTotal;
            if (valores.getAgrupado() == null || (valorTotal = valores.getAgrupado().getValorTotal()) == null || valorTotal.compareTo(BigDecimal.ZERO) != 0) continue;
            retorno = true;
        }
        return retorno;
    }

    private BaixaAutomaticaDetalhe mensagemRetorno(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, TipoMensagemEnum tipoMensagemEnum, Object ... args) {
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(tipoMensagemEnum);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagem(String.format(tipoMensagemEnum.getDescricao(), args));
        return baixaAutomaticaDetalhe;
    }

    public BaixaAutomaticaDetalhe verificarLoteSequenciaFintel(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, ParametrosFintelDTO parametrosFintelDTO) {
        BaixaAutomaticaBloquetoFintelDTO bloquetoFintel = this.loadBloquetoFintel(baixaAutomaticaDetalhe.getNossoNumero(), parametrosFintelDTO);
        if (Objects.isNull(bloquetoFintel)) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.BOLETO_NAO_IDENTIFICADO, new Object[0]);
        }
        if (Objects.isNull(bloquetoFintel.getCadastroGeral()) || bloquetoFintel.getCadastroGeral().equals(0L)) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.CADASTRO_MOBILIARIO_NAO_ENCONTRADO, new Object[0]);
        }
        if (Objects.isNull(bloquetoFintel.getValoresAgrupados()) || bloquetoFintel.getValoresAgrupados().isEmpty()) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.BOLETO_ZERADO, new Object[0]);
        }
        BigDecimal valorTotalCalculado = BigDecimal.ZERO;
        BigDecimal valorTotalBloqueto = BigDecimal.ZERO;
        for (BaixaAutomaticaBloquetoAgrupadoFintelDTO valores : bloquetoFintel.getValoresAgrupados()) {
            if (valores.getAgrupado() == null) continue;
            valorTotalCalculado = valorTotalCalculado.add(valores.getAgrupado().getValorTotalCalculado());
            valorTotalBloqueto = valorTotalBloqueto.add(valores.getAgrupado().getValorTotal());
        }
        if (baixaAutomaticaDetalhe.getValorPago().doubleValue() != valorTotalCalculado.doubleValue()) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.VALORTOTAL_DIFERENTE_VALORPAGO_FINTEL, new Object[]{valorTotalCalculado, baixaAutomaticaDetalhe.getValorPago()});
        }
        if (this.validaBoletoZerado(bloquetoFintel)) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.BOLETO_ZERADO, new Object[0]);
        }
        if (!valorTotalBloqueto.equals(valorTotalCalculado)) {
            return this.mensagemRetorno(baixaAutomaticaDetalhe, TipoMensagemEnum.VALORES_TOTAIS_DIFERENTES_FINTEL, new Object[]{valorTotalBloqueto, valorTotalCalculado, baixaAutomaticaDetalhe.getMesMovimento(), baixaAutomaticaDetalhe.getAnoMovimento()});
        }
        TipoMensagem tipoMensagem = this.tipoMensagemService.findTipoMensagem(TipoMensagemEnum.BOLETO_VALIDADO);
        baixaAutomaticaDetalhe.setSituacao(tipoMensagem.getClassificacao());
        baixaAutomaticaDetalhe.setTipoMensagem(tipoMensagem);
        baixaAutomaticaDetalhe.setMensagem(String.format("D\u00edvida %d validada com sucesso", bloquetoFintel.getCodigoTributo()));
        return baixaAutomaticaDetalhe;
    }

    public void gerarDebitoEBoleto(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, ParametrosFintelDTO parametrosFintelDTO) {
        BaixaAutomaticaBloquetoFintelDTO bloquetoFintel = this.loadBloquetoFintel(baixaAutomaticaDetalhe.getNossoNumero(), parametrosFintelDTO);
        ArrayList listDebitoParcelasDTO = new ArrayList();
        List debitosGerados = bloquetoFintel.getValoresAgrupados().stream().map(parcela -> {
            BaixaAutomaticaBloquetoValoresFintelDTO agrupado = parcela.getAgrupado();
            Long dividaId = bloquetoFintel.getCodigoTributo();
            Long anoReferencia = this.getAnoReferencia(agrupado.getMesReferencia());
            Optional dividaTributo = this.getDividaTributo(dividaId, baixaAutomaticaDetalhe, anoReferencia);
            Optional debitoGerado = Optional.empty();
            if (dividaTributo.isPresent()) {
                debitoGerado = TipoDivida.ISS_HOMOLOGADO.equals((Object)((DividaTributo)dividaTributo.get()).getDivida().getTipoDivida()) ? this.geraDebitoFintelIss(baixaAutomaticaDetalhe, bloquetoFintel, agrupado) : this.geraDebitoFintel(baixaAutomaticaDetalhe, bloquetoFintel, agrupado);
            }
            debitoGerado.ifPresent(debito -> {
                this.entityManager.flush();
                DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
                debitoParcelaDTO.setIdDebito(debito.getId());
                debitoParcelaDTO.setParcela(debito.getNumeroParcela());
                listDebitoParcelasDTO.add(debitoParcelaDTO);
            });
            return debitoGerado;
        }).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setEmiteBoletoFintel(Boolean.valueOf(true));
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setTipoBoleto(listDebitoParcelasDTO.size() == 1 ? TipoBloqueto.PARCELADO : TipoBloqueto.AGRUPADO);
        geraBoletoDTO.setDebitos(listDebitoParcelasDTO);
        Bloqueto boleto = (Bloqueto)this.geraBoletoService.geraBoletoSuperSimples(geraBoletoDTO).stream().findFirst().orElseThrow(() -> new IllegalStateException("Erro ao gerar boleto"));
        boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        boleto.setCodigoBarras(bloquetoFintel.getCodigoBarra());
        boleto.setNossoNumero(bloquetoFintel.getCodigoBarra().substring(27));
        boleto.setDvNossoNumero("");
        boleto.setDataVencimento(bloquetoFintel.getDataVencimento());
        boleto.setDataEmissao(bloquetoFintel.getDataEmissao());
        boleto.setDataLimitePagamento(bloquetoFintel.getDataValidade());
        boleto.setCampo1("");
        boleto.setCampo2("");
        boleto.setCampo3("");
        boleto.setCampo4("");
        boleto.setCampo5("");
        boleto.setCodigoBarrasFormatado("");
        this.atualizaBaixaAutomaticaDetalhe(baixaAutomaticaDetalhe, (Debito)debitosGerados.get(0), boleto);
    }

    private void atualizaBaixaAutomaticaDetalhe(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, Debito debitoGerado, Bloqueto boleto) {
        if (debitoGerado.getParcelas().size() == 1) {
            baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.DEBITO_GERADO);
        } else {
            baixaAutomaticaDetalhe.setTipoOperacao(TipoOperacaoDebito.PARCELA_GERADA);
        }
        baixaAutomaticaDetalhe.setIdDebitoOperacao(debitoGerado.getId());
        baixaAutomaticaDetalhe.setParcelaOperacao(Long.valueOf(debitoGerado.getParcelas().size()));
        baixaAutomaticaDetalhe.setBoleto(boleto);
        baixaAutomaticaDetalhe.setValor(boleto.getValorBloqueto());
    }

    private Long getMesReferencia(String competencia) {
        return !competencia.isEmpty() ? Long.parseLong(competencia.substring(5, 7)) : 0L;
    }

    private Long getAnoReferencia(String competencia) {
        return !competencia.isEmpty() ? Long.parseLong(competencia.substring(0, 4)) : 0L;
    }

    private Optional<Debito> geraDebitoFintel(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, BaixaAutomaticaBloquetoFintelDTO debito, BaixaAutomaticaBloquetoValoresFintelDTO parcela) {
        Long dividaId = debito.getCodigoTributo();
        Long anoReferencia = this.getAnoReferencia(parcela.getMesReferencia());
        Long mesReferencia = this.getMesReferencia(parcela.getMesReferencia());
        Optional dividaTributo = this.getDividaTributo(dividaId, baixaAutomaticaDetalhe, anoReferencia);
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
        if (dividaTributo.isPresent()) {
            debitoManualTributoDTO.setTributo(((DividaTributo)dividaTributo.get()).getTributo().getTributo());
            debitoManualTributoDTO.setValorTributo(parcela.getValorTotal());
            debitoManualTributoDTO.setValorRenuncia(BigDecimal.ZERO);
            debitoManualTributoDTO.setValorBaseCalculo(BigDecimal.ZERO);
        }
        if (anoReferencia > this.exercicioService.getExercicio()) {
            debitoManualDTO.setExercicio(this.exercicioService.getExercicio());
        } else {
            debitoManualDTO.setExercicio(anoReferencia);
        }
        debitoManualDTO.setTipoCadastro(TipoCadastro.fromValue((Long)debito.getTipoCadastro()));
        debitoManualDTO.setCadastroGeral(debito.getCadastroGeral());
        debitoManualDTO.setDivida(dividaId);
        debitoManualDTO.setDataLancamento(baixaAutomaticaDetalhe.getPagamentoLote().getDataMovimento());
        debitoManualDTO.setDataInclusao(baixaAutomaticaDetalhe.getPagamentoLote().getDataMovimento());
        debitoManualDTO.setPrograma("Baixa Autom\u00e1tica");
        DebitoManualObservacaoDTO debitoManualObservacaoDTO = DebitoManualObservacaoDTO.of((String)String.format("D\u00e9bito gerado pela baixa autom\u00e1tica de lote %d/%d sequencia %d", baixaAutomaticaDetalhe.getId().getLote(), baixaAutomaticaDetalhe.getId().getExercicio(), baixaAutomaticaDetalhe.getId().getSequenciaArquivo()));
        debitoManualDTO.getObservacoes().add(debitoManualObservacaoDTO);
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setParcela(Long.valueOf(1L));
        debitoManualParcelaDTO.setDataVencimento(baixaAutomaticaDetalhe.getDataVencimento());
        debitoManualParcelaDTO.setValor(baixaAutomaticaDetalhe.getValorPago());
        debitoManualParcelaDTO.setDataSituacao(baixaAutomaticaDetalhe.getPagamentoLote().getDataMovimento());
        debitoManualParcelaDTO.setAnoReferencia(anoReferencia);
        debitoManualParcelaDTO.setMesReferencia(mesReferencia);
        debitoManualDTO.getParcelas().add(debitoManualParcelaDTO);
        debitoManualDTO.getTributos().add(debitoManualTributoDTO);
        DebitoIdDTO debitoIdDTO = this.geraDebitoService.geraDebitoManual(debitoManualDTO);
        return this.debitoService.findByCompositeKey(debitoIdDTO.getEntidade(), debitoIdDTO.getExercicio(), debitoIdDTO.getTipoCadastro(), debitoIdDTO.getCadastroGeral(), debitoIdDTO.getDivida(), debitoIdDTO.getSubDivida());
    }

    private Optional<Debito> geraDebitoFintelIss(BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, BaixaAutomaticaBloquetoFintelDTO debito, BaixaAutomaticaBloquetoValoresFintelDTO parcela) {
        Long subDividaIssHomologado = 100L;
        Long dividaId = debito.getCodigoTributo();
        Long anoReferencia = this.getAnoReferencia(parcela.getMesReferencia());
        Long mesReferencia = this.getMesReferencia(parcela.getMesReferencia());
        Optional dividaTributo = this.getDividaTributo(dividaId, baixaAutomaticaDetalhe, anoReferencia);
        Long novaSubDivida = subDividaIssHomologado + mesReferencia;
        DebitoManualIssDTO debitoManualIssDTO = new DebitoManualIssDTO();
        dividaTributo.ifPresent(arg_0 -> ((DebitoManualIssDTO)debitoManualIssDTO).setTributo(arg_0));
        if (anoReferencia > this.exercicioService.getExercicio()) {
            debitoManualIssDTO.setExercicio(this.exercicioService.getExercicio());
        } else {
            debitoManualIssDTO.setExercicio(anoReferencia);
        }
        debitoManualIssDTO.setBaixaAutomatica(Boolean.TRUE);
        debitoManualIssDTO.setTipoCadastro(TipoCadastro.fromValue((Long)debito.getTipoCadastro()));
        debitoManualIssDTO.setCadastroGeral(debito.getCadastroGeral());
        debitoManualIssDTO.setDivida(dividaId);
        debitoManualIssDTO.setSubDivida(novaSubDivida);
        debitoManualIssDTO.setDataLancamento(baixaAutomaticaDetalhe.getPagamentoLote().getDataMovimento());
        debitoManualIssDTO.setDataInclusao(baixaAutomaticaDetalhe.getPagamentoLote().getDataMovimento());
        debitoManualIssDTO.setProgram("Baixa Autom\u00e1tica");
        DebitoManualObservacaoDTO debitoManualObservacaoDTO = DebitoManualObservacaoDTO.of((String)String.format("D\u00e9bito gerado pela baixa autom\u00e1tica de lote %d/%d sequencia %d", baixaAutomaticaDetalhe.getId().getLote(), baixaAutomaticaDetalhe.getId().getExercicio(), baixaAutomaticaDetalhe.getId().getSequenciaArquivo()));
        debitoManualIssDTO.getObservacoes().add(debitoManualObservacaoDTO);
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setDataVencimento(baixaAutomaticaDetalhe.getDataVencimento());
        debitoManualParcelaDTO.setValor(baixaAutomaticaDetalhe.getValorPago());
        debitoManualParcelaDTO.setDataSituacao(baixaAutomaticaDetalhe.getPagamentoLote().getDataMovimento());
        debitoManualParcelaDTO.setAnoReferencia(anoReferencia);
        debitoManualParcelaDTO.setMesReferencia(mesReferencia);
        debitoManualIssDTO.getParcelas().add(debitoManualParcelaDTO);
        return this.geraDebitoService.geraDebitoManualIss(debitoManualIssDTO).stream().findFirst();
    }

    private Optional<DividaTributo> getDividaTributo(Long dividaId, BaixaAutomaticaDetalhe baixaAutomaticaDetalhe, Long anoMovimento) {
        Long entidade = baixaAutomaticaDetalhe.getId().getEntidade();
        Long exercicio = anoMovimento > this.exercicioService.getExercicio() ? this.exercicioService.getExercicio() : anoMovimento;
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, dividaId).orElseThrow(() -> new EloValidationException(String.format("D\u00edvida %d n\u00e3o encontrada no exerc\u00edcio %d para entidade %d", dividaId, exercicio, entidade)));
        return divida.getTributos().stream().filter(DividaTributo::getReceitaPadrao).findFirst();
    }

    @Generated
    public ProcessaPagamentoLoteFintelService(DividaService dividaService, TipoMensagemService tipoMensagemService, GeraDebitoService geraDebitoService, GeraBoletoService geraBoletoService, EntityManager entityManager, ExercicioService exercicioService, DebitoService debitoService, RestTemplate restTemplate) {
        this.dividaService = dividaService;
        this.tipoMensagemService = tipoMensagemService;
        this.geraDebitoService = geraDebitoService;
        this.geraBoletoService = geraBoletoService;
        this.entityManager = entityManager;
        this.exercicioService = exercicioService;
        this.debitoService = debitoService;
        this.restTemplate = restTemplate;
    }

    @Generated
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

