/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.Usuario;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoUsuario;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoUsuarioPk;
import br.com.elotech.tributos.repository.UsuarioRepository;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoRepository;
import br.com.elotech.tributos.repository.parcelamento.ParamParcelamentoUsuarioRepository;
import br.com.elotech.tributos.repository.projections.ParamParcelamentoUsuarioProjection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ResponseStatusException;

@Service
public class ParamParcelamentoUsuarioService {
    private final ParamParcelamentoUsuarioRepository paramUsuarioRepository;
    private final ParamParcelamentoRepository paramParcelamentoRepository;
    private final UsuarioRepository usuarioRepository;

    public ParamParcelamentoUsuarioService(ParamParcelamentoUsuarioRepository paramUsuarioRepository, ParamParcelamentoRepository paramParcelamentoRepository, UsuarioRepository usuarioRepository) {
        this.paramUsuarioRepository = paramUsuarioRepository;
        this.paramParcelamentoRepository = paramParcelamentoRepository;
        this.usuarioRepository = usuarioRepository;
    }

    public void delete(Long idParametroParcelamento, String usuario) {
        this.paramUsuarioRepository.deleteById((Object)this.getId(idParametroParcelamento, usuario));
    }

    public ParamParcelamentoUsuario save(Long idParametroParcelamento, String usuario) {
        ParamParcelamentoUsuario paramUsuario = new ParamParcelamentoUsuario();
        paramUsuario.setId(this.getId(idParametroParcelamento, usuario));
        ParamParcelamento parametroParcelamento = (ParamParcelamento)this.paramParcelamentoRepository.findById((Object)idParametroParcelamento).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado Par\u00e2metro Parcelamento com id %d", idParametroParcelamento)));
        paramUsuario.setParametroParcelamento(parametroParcelamento);
        paramUsuario.setUsuario((Usuario)this.usuarioRepository.findOne((Object)usuario));
        return (ParamParcelamentoUsuario)this.paramUsuarioRepository.save((Object)paramUsuario);
    }

    private ParamParcelamentoUsuarioPk getId(Long idParametroParcelamento, String usuario) {
        ParamParcelamentoUsuarioPk id = new ParamParcelamentoUsuarioPk();
        id.setIdParametroParcelamento(idParametroParcelamento);
        id.setUsuario(usuario);
        return id;
    }

    private List<ParamParcelamentoUsuario> findByIdUsuario(String usuario) {
        return this.paramUsuarioRepository.findByIdUsuario(usuario);
    }

    private Usuario findUsuario(String usuario) {
        return (Usuario)this.usuarioRepository.findById((Object)usuario).orElseThrow(() -> new ResponseStatusException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado o usu\u00e1rio %s", usuario)));
    }

    public List<ParamParcelamentoUsuario> copy(String usuarioASerCopiado, String usuarioAReceber) {
        Usuario usuarioOrigem = this.findUsuario(usuarioASerCopiado);
        Usuario usuario = this.findUsuario(usuarioAReceber);
        this.deleteAllByUsuario(usuarioAReceber);
        List permissoesCopiadas = this.findByIdUsuario(usuarioOrigem.getId()).stream().collect(Collectors.toList());
        List novasPermissoesUsuarioAReceber = permissoesCopiadas.stream().map(permissao -> {
            ParamParcelamentoUsuario paramParcelamentoUsuario = new ParamParcelamentoUsuario();
            paramParcelamentoUsuario.setId(this.getId(permissao.getId().getIdParametroParcelamento(), usuario.getId()));
            paramParcelamentoUsuario.setParametroParcelamento(permissao.getParametroParcelamento());
            paramParcelamentoUsuario.setUsuario(usuario);
            return paramParcelamentoUsuario;
        }).collect(Collectors.toList());
        return this.paramUsuarioRepository.saveAll(novasPermissoesUsuarioAReceber);
    }

    protected void deleteAllByUsuario(String usuario) {
        Usuario user = this.findUsuario(usuario);
        List permissoes = this.findByIdUsuario(user.getId());
        this.paramUsuarioRepository.deleteAll((Iterable)permissoes);
    }

    public List<ParamParcelamentoUsuarioProjection> getAllByUsuario(String usuario) {
        return this.paramUsuarioRepository.getAllByUsuario(usuario);
    }
}

