/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.DebitoParcela;
import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.Pagamento;
import br.com.elotech.tributos.domain.PagamentoNegociado;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebNovo;
import br.com.elotech.tributos.domain.PagamentoNegociadoDebOrigem;
import br.com.elotech.tributos.domain.SituacaoPagNegociadoNovo;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoEventoSituacaoParcelaEnum;
import br.com.elotech.tributos.domain.TipoSituacaoParcela;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.dto.DadosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoComTotalizadorDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoPagamentoNegociado;
import br.com.elotech.tributos.dto.FiltroPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.FiltroSimulacaoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.ParametrosPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.StatusPagamentoNegociado;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteManualDTO;
import br.com.elotech.tributos.params.NextSubdividaValueParams;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.repository.DebitoEmAbertoRepository;
import br.com.elotech.tributos.repository.PagamentoNegociadoRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.DebitoObservacaoService;
import br.com.elotech.tributos.service.DebitoParcelaService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.PagamentoLoteManualService;
import br.com.elotech.tributos.service.PagamentoNegociadoRateioService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.SituacaoParcelaService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PagamentoNegociadoService
extends CrudService<PagamentoNegociado, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PagamentoNegociadoService.class);
    private final CadastroGeralService cadastroGeralService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ContextService contextService;
    private final ConvenioService convenioService;
    private final DebitoEmAbertoRepository debitoEmAbertoRepository;
    private final DebitoParcelaService debitoParcelaService;
    private final DebitoService debitoService;
    private final EntityManager em;
    private final FormaPagamentoService formaPagamentoService;
    private final GeraBoletoService geraBoletoService;
    private final GeraDebitoService geraDebitoService;
    private final PagamentoLoteManualService pagamentoLoteManualService;
    private final PagamentoService pagamentoService;
    private final SituacaoParcelaService situacaoParcelaService;
    private final DebitoObservacaoService debitoObservacaoService;
    private final PagamentoNegociadoRepository pagamentoNegociadoRepository;
    private final PagamentoNegociadoRateioService pagamentoNegociadoRateioService;
    private final BoletoRepository boletoRepository;

    public DebitoPagamentoNegociadoComTotalizadorDTO findDebitos(FiltroConsultaDebitoPagamentoNegociado filtro) {
        Long entidade = this.contextService.getEntidadePrincipal();
        List debitos = this.debitoEmAbertoRepository.loadDebitosPagamentoNegociado(filtro, entidade);
        if (!debitos.isEmpty()) {
            FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.ofNullable(filtro.getExercicioFormaPagamento()));
            debitos = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento.getId(), filtro.getDataReferencia());
            debitos = CalculaAcrescimoBaseDTO.agruparPorParcela((List)debitos);
        }
        return new DebitoPagamentoNegociadoComTotalizadorDTO(debitos);
    }

    public DebitoPagamentoNegociadoComTotalizadorDTO gerarSimulacaoPagamentoNegociado(FiltroSimulacaoPagamentoNegociadoDTO filtro) {
        filtro.gerarRateioNegociacao();
        return new DebitoPagamentoNegociadoComTotalizadorDTO(filtro.getDebitos());
    }

    @Transactional
    public PagamentoNegociado gerarPagamentoNegociado(ParametrosPagamentoNegociadoDTO parametros) {
        log.debug("Foi inicializado a gera\u00e7\u00e3o do pagamento negociado. ");
        log.debug("Preparando dados. ");
        List debitos = parametros.getDebitos();
        List debitosTotalmenteBaixados = this.agruparDebitosTotalmenteBaixados(debitos);
        List debitoParcialBaixados = this.agruparDebitosParcialmenteBaixados(debitos);
        if (debitosTotalmenteBaixados.size() == 1 && debitoParcialBaixados.isEmpty()) {
            throw new EloValidationException("Para pagamentos integrais favor prosseguir com a gera\u00e7\u00e3o de boleto especial no atendimento.");
        }
        log.debug("Gerando pagamento negociado. ");
        PagamentoNegociado pagamentoNegociado = this.criarPagamentoNegociado(parametros);
        if (!debitoParcialBaixados.isEmpty()) {
            DebitoPagamentoNegociadoDTO debitoOriginalAbatidoParcial = (DebitoPagamentoNegociadoDTO)debitoParcialBaixados.get(0);
            log.debug("Alterando a situa\u00e7\u00e3o da parcela origem {} abatida parcialmente no Pagamento negociado para {}", (Object)debitoOriginalAbatidoParcial.getParcela(), (Object)TipoEventoSituacaoParcelaEnum.PAGO_POR_PAGAMENTO_NEGOCIADO.getDescricao());
            this.updateSituacaoParcela(debitoOriginalAbatidoParcial);
        }
        log.debug("Gerando pagamento dos d\u00e9bitos Abatidos. ");
        pagamentoNegociado.setPagamentoGerado(this.gerarPagamentoDosDebitosAbatidos(debitos, parametros));
        log.debug("Pagamento negociado gerado com sucesso");
        pagamentoNegociado = (PagamentoNegociado)this.pagamentoNegociadoRepository.save((Object)pagamentoNegociado);
        this.insereObservacoes(pagamentoNegociado);
        return pagamentoNegociado;
    }

    private void updateSituacaoParcela(DebitoPagamentoNegociadoDTO debitoPagamentoNegociado) {
        this.debitoParcelaService.findById(DebitoParcelaId.from((DebitoPagamentoNegociadoDTO)debitoPagamentoNegociado)).ifPresent(debitoParcela -> {
            debitoParcela.setSituacaoDebito(this.situacaoParcelaService.getNovaSituacaoParcela(TipoEventoSituacaoParcelaEnum.PAGO_POR_PAGAMENTO_NEGOCIADO, debitoParcela.getSituacaoDebito()));
            this.debitoParcelaService.save((EloEntity)debitoParcela, null);
        });
    }

    private List<DebitoPagamentoNegociadoDTO> agruparDebitosTotalmenteBaixados(List<DebitoPagamentoNegociadoDTO> debitos) {
        return this.agruparDebitosPorStatus(debitos, StatusPagamentoNegociado.TOTAL);
    }

    private List<DebitoPagamentoNegociadoDTO> agruparDebitosParcialmenteBaixados(List<DebitoPagamentoNegociadoDTO> debitos) {
        return this.agruparDebitosPorStatus(debitos, StatusPagamentoNegociado.PARCIAL);
    }

    private PagamentoNegociado criarPagamentoNegociado(ParametrosPagamentoNegociadoDTO parametros) {
        Convenio convenio = this.findConvenioById(parametros.getDadosPagamento().getConvenio().getId());
        PagamentoNegociado pagamentoNegociado = PagamentoNegociado.from((ParametrosPagamentoNegociadoDTO)parametros, (Convenio)convenio);
        List debitosOrigem = this.geraListaDePagamentosDebOrigem(parametros, pagamentoNegociado);
        PagamentoNegociadoDebNovo debitoNovo = this.geraDebitoNovo(parametros, pagamentoNegociado);
        pagamentoNegociado.setObservacao(parametros.getDadosPagamento().getObservacao());
        pagamentoNegociado.setDebitosOrigem(debitosOrigem);
        if (Objects.nonNull(debitoNovo)) {
            pagamentoNegociado.setDebitosNovos(Collections.singletonList(debitoNovo));
            pagamentoNegociado.setValorDebitoNovo(debitoNovo.getDebitoNovo().getValorTotal());
        }
        return pagamentoNegociado;
    }

    private Pagamento gerarPagamentoDosDebitosAbatidos(List<DebitoPagamentoNegociadoDTO> debitosAbatidos, ParametrosPagamentoNegociadoDTO parametros) {
        DadosPagamentoNegociadoDTO dadosPagamento = parametros.getDadosPagamento();
        FiltroPagamentoNegociadoDTO filtro = parametros.getFiltro();
        CadastroGeral cadastroGeral = this.getCadastroGeral(filtro.getTipoCadastro(), filtro.getCadastroGeral());
        Convenio convenio = (Convenio)this.convenioService.findOne((Serializable)dadosPagamento.getConvenio().getId());
        Bloqueto boleto = this.geraBoletoService.createBoletoForPagamentoNegociado(debitosAbatidos, dadosPagamento.getMotivo(), cadastroGeral);
        boleto = (Bloqueto)this.boletoRepository.save((Object)boleto);
        this.em.flush();
        this.em.detach((Object)boleto);
        PagamentoLoteManualDTO pagamentoLoteManualDTO = PagamentoLoteManualDTO.from((Bloqueto)boleto, (Long)convenio.getId(), (LocalDate)dadosPagamento.getDataCredito(), (Long)this.contextService.getExercicioAtual(), (LocalDate)dadosPagamento.getDataCredito());
        PagamentoLoteDTO pagamentoLoteDTO = this.pagamentoLoteManualService.salvarPagamentoLote(pagamentoLoteManualDTO);
        PagamentoLoteId pagamentoLoteID = new PagamentoLoteId();
        pagamentoLoteID.setLote(pagamentoLoteDTO.getLote());
        pagamentoLoteID.setExercicio(pagamentoLoteDTO.getExercicio());
        pagamentoLoteID.setEntidade(pagamentoLoteDTO.getEntidade());
        return (Pagamento)this.pagamentoService.buscarPagamentosPorPagamentoLoteId(pagamentoLoteID).get(0);
    }

    private PagamentoNegociadoDebNovo geraDebitoNovo(ParametrosPagamentoNegociadoDTO parametros, PagamentoNegociado pagamentoNegociado) {
        List debitosParcialmenteBaixados = this.agruparDebitosParcialmenteBaixados(parametros.getDebitos());
        if (debitosParcialmenteBaixados.isEmpty()) {
            return null;
        }
        DebitoPagamentoNegociadoDTO debitoParcial = (DebitoPagamentoNegociadoDTO)debitosParcialmenteBaixados.get(0);
        DebitoPagamentoNegociadoDTO debitoRestante = this.pagamentoNegociadoRateioService.criaDebitoRestante(debitoParcial);
        return this.geraPagamentoNegociadoDebitoNovo(debitoRestante, pagamentoNegociado, SituacaoPagNegociadoNovo.ABERTO);
    }

    private PagamentoNegociadoDebNovo geraPagamentoNegociadoDebitoNovo(DebitoPagamentoNegociadoDTO debitoDTO, PagamentoNegociado pagamentoNegociado, SituacaoPagNegociadoNovo situacao) {
        DebitoIdDTO debitoNovoID = this.gerarNovoDebito(debitoDTO);
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoNovoID.getIdDebito());
        DebitoParcela debitoParcelaOrigem = this.debitoParcelaFrom(debitoDTO);
        return this.criaNovoPagamentoNegociadoDebNovo(pagamentoNegociado, situacao, debito, debitoParcelaOrigem);
    }

    private PagamentoNegociadoDebNovo criaNovoPagamentoNegociadoDebNovo(PagamentoNegociado pagamentoNegociado, SituacaoPagNegociadoNovo situacao, Debito debito, DebitoParcela debitoParcelaOrigem) {
        PagamentoNegociadoDebNovo debNovo = new PagamentoNegociadoDebNovo();
        debNovo.setPgtonegociado(pagamentoNegociado.getId());
        debNovo.setObservacao("Pagamento negociado novo gerado atrav\u00e9s do Oxy");
        debNovo.setSituacao(situacao);
        debNovo.setDebitoNovo((DebitoParcela)debito.getParcelas().get(0));
        debNovo.setDebitoOrigem(debitoParcelaOrigem);
        return debNovo;
    }

    private DebitoIdDTO gerarNovoDebito(DebitoPagamentoNegociadoDTO debitoDTO) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoDTO.getIdDebito());
        NextSubdividaValueParams params = new NextSubdividaValueParams();
        params.setDivida(debito.getDivida().getDivida());
        params.setExercicio(debito.getExercicio());
        params.setCadastroGeral(debito.getCadastroGeral().getCadastroGeral());
        params.setTipoCadastro(debito.getTipoCadastro());
        Long novaSequencia = this.debitoService.getNextValueSubdivida(params);
        DebitoManualDTO debitoManualDTO = new DebitoManualDTO();
        debitoManualDTO.setExercicio(debitoDTO.getExercicio());
        debitoManualDTO.setTipoCadastro(TipoCadastro.fromValue((Long)debitoDTO.getTipoCadastro()));
        debitoManualDTO.setCadastroGeral(debitoDTO.getCadastroGeral());
        debitoManualDTO.setDivida(debitoDTO.getDivida());
        debitoManualDTO.setSubDivida(novaSequencia);
        debitoManualDTO.setDataLancamento(LocalDate.now());
        debitoManualDTO.setFormaCorrecao(debito.getFormaCorrecao().getId());
        debitoManualDTO.setPrograma("PagamentoNegociado");
        if (debitoDTO.getTributosAgrupados().isEmpty()) {
            DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
            debitoManualTributoDTO.setTributo(debitoDTO.getTributo());
            debitoManualTributoDTO.setValorTributo(debitoDTO.getValorNovoDebito());
            debitoManualTributoDTO.setValorRenuncia(BigDecimal.ZERO);
            debitoManualTributoDTO.setValorBaseCalculo(BigDecimal.ZERO);
            debitoManualDTO.getTributos().add(debitoManualTributoDTO);
        } else {
            debitoDTO.getTributosAgrupados().forEach(tributos -> {
                DebitoManualTributoDTO debitoManualTributoDTO = new DebitoManualTributoDTO();
                debitoManualTributoDTO.setTributo(tributos.getTributo());
                debitoManualTributoDTO.setValorTributo(tributos.getValorNovoDebito());
                debitoManualTributoDTO.setValorRenuncia(BigDecimal.ZERO);
                debitoManualTributoDTO.setValorBaseCalculo(BigDecimal.ZERO);
                debitoManualDTO.getTributos().add(debitoManualTributoDTO);
            });
        }
        DebitoManualParcelaDTO debitoManualParcelaDTO = new DebitoManualParcelaDTO();
        debitoManualParcelaDTO.setParcela(debitoDTO.getParcela());
        debitoManualParcelaDTO.setSituacao(TipoSituacaoParcela.ABERTO.getValue());
        debitoManualParcelaDTO.setSituacaoLegal(Long.valueOf(debitoDTO.getSituacaoLegal().longValue()));
        debitoManualParcelaDTO.setDataVencimento(debitoDTO.getDataVencimento());
        debitoManualParcelaDTO.setValor(debitoDTO.getValorPrincipal());
        debitoManualParcelaDTO.setValorBaseCalculo(BigDecimal.ZERO);
        debitoManualDTO.setParcelas(List.of(debitoManualParcelaDTO));
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }

    private List<PagamentoNegociadoDebOrigem> geraListaDePagamentosDebOrigem(ParametrosPagamentoNegociadoDTO parametros, PagamentoNegociado pagamentoNegociado) {
        return parametros.getDebitos().stream().map(origemDTO -> {
            PagamentoNegociadoDebOrigem origem = PagamentoNegociadoDebOrigem.from((DebitoPagamentoNegociadoDTO)origemDTO);
            origem.setPagamentoNegociado(pagamentoNegociado);
            origem.setParcela(this.debitoParcelaFrom(origemDTO));
            return origem;
        }).collect(Collectors.toList());
    }

    private List<DebitoPagamentoNegociadoDTO> agruparDebitosPorStatus(List<DebitoPagamentoNegociadoDTO> debitos, StatusPagamentoNegociado status) {
        return debitos.stream().filter(debito -> debito.getStatus().equals((Object)status)).collect(Collectors.toList());
    }

    private CadastroGeral getCadastroGeral(Long tipoCadastro, Long cadastroGeral) {
        return (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral));
    }

    private DebitoParcela debitoParcelaFrom(DebitoPagamentoNegociadoDTO debitoDTO) {
        return (DebitoParcela)this.debitoParcelaService.findOne((Serializable)DebitoParcelaId.from((DebitoPagamentoNegociadoDTO)debitoDTO));
    }

    private DebitoIdDTO debitoIdDTOFrom(DebitoParcela parcela) {
        return DebitoIdDTO.from((DebitoParcela)parcela);
    }

    private Convenio findConvenioById(Long id) {
        return (Convenio)this.convenioService.findOne((Serializable)id);
    }

    private void insereObservacoes(PagamentoNegociado pagamentoNegociado) {
        this.insereObservacaoNosDebitoParcelaTotalmenteBaixados(pagamentoNegociado);
        this.insereObservacaoNoDebitoParcelaPagoPorPagamentoNegociadoParcialmente(pagamentoNegociado);
        this.insereObservacoesNosDebitosNovos(pagamentoNegociado);
    }

    private void insereObservacaoNosDebitoParcelaTotalmenteBaixados(PagamentoNegociado pagamentoNegociado) {
        String observacao = String.format("Parcela(s) totalmente baixada(s) atrav\u00e9s do pagamento negociado %s: ", pagamentoNegociado.getId());
        pagamentoNegociado.getDebitosOrigem().stream().filter(PagamentoNegociadoDebOrigem::isTotalmenteBaixado).map(debito -> debito.getId().getDebitoParcela()).collect(Collectors.groupingBy(arg_0 -> this.debitoIdDTOFrom(arg_0))).forEach((debitoIdDTO, debitoParcelas) -> {
            String complementoObservacao = debitoParcelas.stream().map(parcela -> String.valueOf(parcela.getId().getParcela())).collect(Collectors.joining(", "));
            this.debitoObservacaoService.save(debitoIdDTO, observacao.concat(complementoObservacao));
        });
    }

    private void insereObservacaoNoDebitoParcelaPagoPorPagamentoNegociadoParcialmente(PagamentoNegociado pagamentoNegociado) {
        List parcelas = pagamentoNegociado.getDebitosOrigem().stream().filter(PagamentoNegociadoDebOrigem::isParcialmenteBaixado).map(origem -> origem.getId().getDebitoParcela()).collect(Collectors.toList());
        if (!parcelas.isEmpty()) {
            DebitoParcela parcela = (DebitoParcela)parcelas.get(0);
            String observacao = String.format("Parcela %s Paga por Pagamento Negociado %s.", parcela.getId().getParcela(), pagamentoNegociado.getId());
            this.debitoObservacaoService.save(DebitoIdDTO.from((Debito)parcela.getDebito()), observacao);
        }
    }

    private void insereObservacoesNosDebitosNovos(PagamentoNegociado pagamentoNegociado) {
        if (!pagamentoNegociado.getDebitosNovos().isEmpty()) {
            String observacao = String.format("D\u00e9bito criado a partir do pagamento negociado %s", pagamentoNegociado.getId());
            pagamentoNegociado.getDebitosNovos().stream().filter(x -> Objects.nonNull(x.getDebitoNovo())).map(PagamentoNegociadoDebNovo::getDebitoNovo).map(DebitoParcela::getDebito).map(DebitoIdDTO::from).forEach(idDTO -> this.debitoObservacaoService.save(idDTO, observacao));
        }
    }

    @Generated
    public PagamentoNegociadoService(CadastroGeralService cadastroGeralService, CalculoAcrescimoService calculoAcrescimoService, ContextService contextService, ConvenioService convenioService, DebitoEmAbertoRepository debitoEmAbertoRepository, DebitoParcelaService debitoParcelaService, DebitoService debitoService, EntityManager em, FormaPagamentoService formaPagamentoService, GeraBoletoService geraBoletoService, GeraDebitoService geraDebitoService, PagamentoLoteManualService pagamentoLoteManualService, PagamentoService pagamentoService, SituacaoParcelaService situacaoParcelaService, DebitoObservacaoService debitoObservacaoService, PagamentoNegociadoRepository pagamentoNegociadoRepository, PagamentoNegociadoRateioService pagamentoNegociadoRateioService, BoletoRepository boletoRepository) {
        this.cadastroGeralService = cadastroGeralService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.contextService = contextService;
        this.convenioService = convenioService;
        this.debitoEmAbertoRepository = debitoEmAbertoRepository;
        this.debitoParcelaService = debitoParcelaService;
        this.debitoService = debitoService;
        this.em = em;
        this.formaPagamentoService = formaPagamentoService;
        this.geraBoletoService = geraBoletoService;
        this.geraDebitoService = geraDebitoService;
        this.pagamentoLoteManualService = pagamentoLoteManualService;
        this.pagamentoService = pagamentoService;
        this.situacaoParcelaService = situacaoParcelaService;
        this.debitoObservacaoService = debitoObservacaoService;
        this.pagamentoNegociadoRepository = pagamentoNegociadoRepository;
        this.pagamentoNegociadoRateioService = pagamentoNegociadoRateioService;
        this.boletoRepository = boletoRepository;
    }
}

