/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ContaBancaria;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.ExercicioMesId;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.TipoArquivoRetornoPagamento;
import br.com.elotech.tributos.domain.integracaocontabil.LoteIntegracaoContabil;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.PagamentoLoteId;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.tipomensagem.ClassificacaoTipoMensagem;
import br.com.elotech.tributos.dto.ConsistenciaBaixaDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.pagamento.AiseImportacaoArquivoRetornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.AiseImportacaoArquivoRetornoPagamentoResultDTO;
import br.com.elotech.tributos.dto.pagamento.ConvenioArquivoRetornoDTO;
import br.com.elotech.tributos.dto.pagamento.ImportacaoArquivoRetornoPagamentoDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteDTO;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteIntegracaoDTO;
import br.com.elotech.tributos.report.loader.ConsistenciaBaixaParamLoader;
import br.com.elotech.tributos.repository.BaixaAutomaticaDetalheRepository;
import br.com.elotech.tributos.repository.ConsistenciaBaixaRepository;
import br.com.elotech.tributos.repository.PagamentoLoteRepository;
import br.com.elotech.tributos.service.ContaBancariaService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ConvenioService;
import br.com.elotech.tributos.service.ValidaDataMovimentacaoService;
import br.com.elotech.tributos.service.integracaocontabil.LoteIntegracaoContabilService;
import br.com.elotech.tributos.service.ws.rest.AisePagamentoLoteService;
import br.com.elotech.tributos.util.UsuarioUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PagamentoLoteService
extends CrudService<PagamentoLote, PagamentoLoteId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PagamentoLoteService.class);
    private final PagamentoLoteRepository pagamentoLoteRepository;
    private final ValidaDataMovimentacaoService validaDataMovimentacaoService;
    private final ContextService contextService;
    private final AisePagamentoLoteService aisePagamentoLoteService;
    private final ConvenioService convenioService;
    private final LoteIntegracaoContabilService loteIntegracaoContabilService;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ConsistenciaBaixaParamLoader consistenciaBaixaParamLoader;
    private final ConsistenciaBaixaRepository consistenciaBaixaRepository;
    private final BaixaAutomaticaDetalheRepository baixaAutomaticaDetalheRepositoy;
    private final ObjectMapper objectMapper;
    private final ContaBancariaService contaBancariaService;

    private ExercicioMesId getExercicioMesId(Long entidade, Long exercicio, LocalDate dataMovimento) {
        ExercicioMesId exercicioMesId = new ExercicioMesId();
        exercicioMesId.setEntidade(entidade);
        exercicioMesId.setExercicio(exercicio);
        exercicioMesId.setMes(Long.valueOf(dataMovimento.getMonth().getValue()));
        return exercicioMesId;
    }

    private MovimentacaoDiariaId getMovimentacaoDiariaId(Long entidade, LocalDate dataMovimento) {
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setEntidade(entidade);
        movimentacaoDiariaId.setData(dataMovimento);
        return movimentacaoDiariaId;
    }

    private PagamentoLoteId getPagamentoLoteId(Long entidade, Long exercicio, Long lote) {
        PagamentoLoteId pagamentoLoteId = new PagamentoLoteId();
        pagamentoLoteId.setEntidade(entidade);
        pagamentoLoteId.setExercicio(exercicio);
        pagamentoLoteId.setLote(lote);
        return pagamentoLoteId;
    }

    private PagamentoLote findLoteAndValidaSituacaoNull(Long entidade, Long exercicio, Long lote) {
        PagamentoLote pagamentoLote = (PagamentoLote)this.pagamentoLoteRepository.findById((Object)this.getPagamentoLoteId(entidade, exercicio, lote)).orElseThrow(() -> new EloValidationException(String.format("Lote de Pagamento %s/%s n\u00e3o encontrado.", lote, exercicio)));
        if (Objects.isNull(pagamentoLote.getDataMovimento())) {
            throw new EloValidationException("Data de movimento n\u00e3o encontrada.");
        }
        if (Objects.isNull(pagamentoLote.getSituacao())) {
            throw new EloValidationException("Situa\u00e7\u00e3o n\u00e3o encontrada.");
        }
        return pagamentoLote;
    }

    public void reabrirLote(Long entidade, Long exercicio, Long lote) {
        PagamentoLote pagamentoLote = this.findLoteAndValidaSituacaoNull(entidade, exercicio, lote);
        LoteIntegracaoContabil loteIntegracaoContabil = this.loteIntegracaoContabilService.findLoteIntegracaoByPagamentoLoteId(pagamentoLote);
        if (Objects.nonNull(loteIntegracaoContabil) && loteIntegracaoContabil.getPagamentoIntegradoContabilidade()) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel reabrir lote integrado na contabilidade.");
        }
        this.validaDataMovimentacaoService.verificaMesFechadoTributacao(this.getExercicioMesId(entidade, exercicio, pagamentoLote.getDataMovimento()));
        this.validaDataMovimentacaoService.verificaMovimentacaoDiaria(this.getMovimentacaoDiariaId(entidade, pagamentoLote.getDataMovimento()));
        pagamentoLote.setSituacao(SituacaoPagamentoLote.ABERTO);
        this.pagamentoLoteRepository.save((Object)pagamentoLote);
    }

    public void fecharLote(Long entidade, Long exercicio, Long lote) {
        PagamentoLote pagamentoLote = this.findLoteAndValidaSituacaoNull(entidade, exercicio, lote);
        this.fecharLote(pagamentoLote);
    }

    public PagamentoLote fecharLote(PagamentoLote pagamentoLote) {
        pagamentoLote.setSituacao(SituacaoPagamentoLote.FECHADO);
        return (PagamentoLote)this.pagamentoLoteRepository.save((Object)pagamentoLote);
    }

    public AiseImportacaoArquivoRetornoPagamentoResultDTO importarArquivoRetorno(ImportacaoArquivoRetornoPagamentoDTO arquivoRetorno, byte[] file) throws IOException {
        String fileContent = new String(file, Charsets.ISO_8859_1);
        String arquivoImportacaoHash256 = DigestUtils.sha256Hex((String)fileContent);
        LOGGER.debug("HASH DO ARQUIVO DE PAGAMENTO: {}", (Object)arquivoImportacaoHash256);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Arquivo: \n{}", (Object)fileContent);
        }
        this.validarImportacaoDuplicada(arquivoImportacaoHash256);
        String primeiraLinha = this.getPrimeiraLinhaArquivoRetornoBancario(fileContent);
        Long banco = this.extrairCodigoBanco(primeiraLinha);
        Convenio convenio = this.identificaArquivoRetorno(primeiraLinha, banco);
        return this.aiseImportarArquivoRetorno(arquivoRetorno, convenio, arquivoImportacaoHash256, fileContent);
    }

    private Long extrairCodigoBanco(String linha) {
        if (StringUtils.isBlank((CharSequence)linha)) {
            return 0L;
        }
        String codigoBancoStr = RegExUtils.removeAll((String)StringUtils.trim((String)StringUtils.substring((String)linha, (int)0, (int)3)), (String)"[^0-9]");
        try {
            return Long.parseLong(codigoBancoStr);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private AiseImportacaoArquivoRetornoPagamentoResultDTO aiseImportarArquivoRetorno(ImportacaoArquivoRetornoPagamentoDTO arquivoRetorno, Convenio convenio, String arquivoHashBase64, String fileContent) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = this.contextService.getExercicioAtual();
        AiseImportacaoArquivoRetornoPagamentoDTO arquivoRetornoPagamentoAiseDTO = AiseImportacaoArquivoRetornoPagamentoDTO.from((ImportacaoArquivoRetornoPagamentoDTO)arquivoRetorno);
        arquivoRetornoPagamentoAiseDTO.setEntidade(entidade);
        arquivoRetornoPagamentoAiseDTO.setExercicio(exercicio);
        arquivoRetornoPagamentoAiseDTO.setUsuario(UsuarioUtils.getUsuarioAise());
        arquivoRetornoPagamentoAiseDTO.setBanco(convenio.getBanco().getId());
        arquivoRetornoPagamentoAiseDTO.setConvenio(convenio.getConvenio());
        arquivoRetornoPagamentoAiseDTO.setContaBancaria(convenio.getContaBancaria().getContaBancaria());
        arquivoRetornoPagamentoAiseDTO.setTipoArquivo(convenio.getModeloArquivoRetorno().getModeloArquivo());
        arquivoRetornoPagamentoAiseDTO.setConteudoArquivo(fileContent);
        AiseImportacaoArquivoRetornoPagamentoResultDTO importacaoResultDTO = this.aisePagamentoLoteService.aiseImportarArquivoRetorno(arquivoRetornoPagamentoAiseDTO);
        importacaoResultDTO.getLotesGerados().forEach(loteDTO -> {
            PagamentoLote pagamentoLote = this.findByPagamentoLote(loteDTO.getEntidade(), loteDTO.getExercicio(), loteDTO.getLote());
            pagamentoLote.setArquivoHash(arquivoHashBase64);
            this.pagamentoLoteRepository.save((Object)pagamentoLote);
        });
        return importacaoResultDTO;
    }

    private void validarImportacaoDuplicada(String arquivoImportacaoHash256) {
        if (this.pagamentoLoteRepository.existsByArquivoHash(arquivoImportacaoHash256)) {
            throw new EloValidationException("Duplicidade de arquivo identificada. Este arquivo j\u00e1 foi importado.");
        }
    }

    private String getPrimeiraLinhaArquivoRetornoBancario(String fileContent) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(fileContent));
        return reader.readLine();
    }

    private Convenio identificaArquivoRetorno(String primeiraLinha, Long banco) {
        return this.getConfiguracaoConvenios(primeiraLinha).stream().map(item -> {
            if (banco.equals(Banco.CODIGO_SICOOB) && item.getBancoArquivo().equals(Banco.CODIGO_SICOOB) && item.getTipoArquivoRetornoPagamento().equals((Object)TipoArquivoRetornoPagamento.CNAB240_SICOOB) && item.getContaBancaria() != null && item.getContaBancaria() > 0L) {
                ContaBancaria contaBancaria = (ContaBancaria)this.contaBancariaService.buscarContaPorNumero(item.getContaBancaria().toString()).orElseThrow(() -> new EloValidationException("Conta banc\u00e1ria n\u00e3o encontrada para o n\u00famero: " + item.getContaBancaria()));
                return this.convenioService.findByContaBancariaAndNumeroConvenioAndBancoId(this.contextService.getEntidadePrincipal(), contaBancaria.getContaBancaria(), item.getBancoArquivo());
            }
            return this.convenioService.findByEntidadeAndNumeroConvenioAndBancoId(this.contextService.getEntidadePrincipal(), item.getConvenioArquivo(), item.getBancoArquivo());
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o foi encontrado conv\u00eanio configurado para este tipo de arquivo!"));
    }

    private List<ConvenioArquivoRetornoDTO> getConfiguracaoConvenios(String primeiraLinha) {
        ArrayList<ConvenioArquivoRetornoDTO> configuracoes = new ArrayList<ConvenioArquivoRetornoDTO>();
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.FEBRABAN, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB240, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB240_BANCO_DO_BRASIL, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB240_SANTANDER, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB240_SICREDI, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.SIAFI, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.SUPER_SIMPLES, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CBR643, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB400_SIGCB, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB400_BRADESCO, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CBR643_PONTAL_DO_PARANA, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB240_CRESOL, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB400_CRESOL, (String)primeiraLinha));
        configuracoes.add(ConvenioArquivoRetornoDTO.from((TipoArquivoRetornoPagamento)TipoArquivoRetornoPagamento.CNAB240_SICOOB, (String)primeiraLinha));
        return configuracoes;
    }

    public PagamentoLoteDTO findPagamentoLoteDTO(Long entidade, Long exercicio, Long lote) {
        PagamentoLote pagamentoLote = this.findByPagamentoLote(entidade, exercicio, lote);
        return PagamentoLoteDTO.of((PagamentoLote)pagamentoLote);
    }

    public PagamentoLote findByPagamentoLote(Long entidade, Long exercicio, Long lote) {
        PagamentoLoteId pagamentoLoteId = new PagamentoLoteId();
        pagamentoLoteId.setEntidade(entidade);
        pagamentoLoteId.setExercicio(exercicio);
        pagamentoLoteId.setLote(lote);
        return (PagamentoLote)this.pagamentoLoteRepository.findById((Object)pagamentoLoteId).orElseThrow(() -> new EloValidationException("Lote de pagamento n\u00e3o encontrado."));
    }

    public SortedMap<LocalDate, List<PagamentoLoteIntegracaoDTO>> findPagamentoLotePorDia(List<LocalDate> diasSelecionados) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Map<LocalDate, List<PagamentoLoteIntegracaoDTO>> result = this.pagamentoLoteRepository.findPagamentoLoteToPagamentoLoteIntegracaoDTO(entidade, diasSelecionados).stream().collect(Collectors.groupingBy(PagamentoLoteIntegracaoDTO::getDataMovimento));
        diasSelecionados.forEach(dia -> result.putIfAbsent((LocalDate)dia, new ArrayList()));
        TreeMap<LocalDate, List<PagamentoLoteIntegracaoDTO>> sortedMap = new TreeMap<LocalDate, List<PagamentoLoteIntegracaoDTO>>(Comparator.naturalOrder());
        sortedMap.putAll(result);
        return sortedMap;
    }

    public List<PagamentoLote> findAllNotIntegradoByDataMovimentoAndSituacao(LocalDate data) {
        return this.pagamentoLoteRepository.findAllNotIntegradoByDataMovimentoAndSituacao(data, SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE);
    }

    public Optional<PagamentoLote> findAbertoByConvenioAndData(Convenio convenio, LocalDate dataReferencia) {
        return this.pagamentoLoteRepository.findAbertoByConvenioAndData(convenio, dataReferencia);
    }

    public byte[] imprimirConsistenciaArquivoBaixa(Long entidade, Long exercicio, Long lote) {
        List consistenciasBaixa = this.consistenciaBaixaRepository.findConsistenciasBaixa(entidade, exercicio, lote);
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)consistenciasBaixa, ConsistenciaBaixaDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.consistenciaBaixaParamLoader).build();
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile("consistencia-arquivo-baixa.jrxml")).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
    }

    public void removerLote(Long entidade, Long exercicio, Long lote) {
        PagamentoLote pagamentoLote = this.findByPagamentoLote(entidade, exercicio, lote);
        if (pagamentoLote.getSituacao() != null && !pagamentoLote.getSituacao().equals((Object)SituacaoPagamentoLote.ABERTO)) {
            throw new EloValidationException("Situa\u00e7\u00e3o do Pagamento Lote diferente de 'Aberto'.");
        }
        List baixaList = this.baixaAutomaticaDetalheRepositoy.findByPagamentoLote(pagamentoLote);
        List<ClassificacaoTipoMensagem> listaSituacoesInvalidas = Arrays.asList(ClassificacaoTipoMensagem.PAGO, ClassificacaoTipoMensagem.CREDITO_CONTRIBUINTE, ClassificacaoTipoMensagem.PAGO_DUPLICIDADE, ClassificacaoTipoMensagem.CREDITO_CONCEDIDO);
        boolean existeBaixa = baixaList.stream().anyMatch(baixaAutomaticaDetalhe -> listaSituacoesInvalidas.contains(baixaAutomaticaDetalhe.getSituacao()));
        if (existeBaixa) {
            throw new EloValidationException("Foram encontradas Baixas pagas para esse Pagamento Lote.");
        }
        this.baixaAutomaticaDetalheRepositoy.deleteAll((Iterable)baixaList);
        this.pagamentoLoteRepository.delete((Object)pagamentoLote);
    }

    @Generated
    public PagamentoLoteService(PagamentoLoteRepository pagamentoLoteRepository, ValidaDataMovimentacaoService validaDataMovimentacaoService, ContextService contextService, AisePagamentoLoteService aisePagamentoLoteService, ConvenioService convenioService, LoteIntegracaoContabilService loteIntegracaoContabilService, ReportFileResolverFactory reportFileResolverFactory, ConsistenciaBaixaParamLoader consistenciaBaixaParamLoader, ConsistenciaBaixaRepository consistenciaBaixaRepository, BaixaAutomaticaDetalheRepository baixaAutomaticaDetalheRepositoy, ObjectMapper objectMapper, ContaBancariaService contaBancariaService) {
        this.pagamentoLoteRepository = pagamentoLoteRepository;
        this.validaDataMovimentacaoService = validaDataMovimentacaoService;
        this.contextService = contextService;
        this.aisePagamentoLoteService = aisePagamentoLoteService;
        this.convenioService = convenioService;
        this.loteIntegracaoContabilService = loteIntegracaoContabilService;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.consistenciaBaixaParamLoader = consistenciaBaixaParamLoader;
        this.consistenciaBaixaRepository = consistenciaBaixaRepository;
        this.baixaAutomaticaDetalheRepositoy = baixaAutomaticaDetalheRepositoy;
        this.objectMapper = objectMapper;
        this.contaBancariaService = contaBancariaService;
    }
}

