/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.dto.MotivoDeducaoDTO;
import br.com.elotech.tributos.exception.MotivoDeducaoException;
import br.com.elotech.tributos.repository.MotivoDeducaoRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class MotivoDeducaoService
extends CrudService<MotivoDeducao, Long> {
    private final MotivoDeducaoRepository motivoDeducaoRepository;
    private final ContextService contextService;

    public MotivoDeducaoService(MotivoDeducaoRepository motivoDeducaoRepository, ContextService contextService) {
        this.motivoDeducaoRepository = motivoDeducaoRepository;
        this.contextService = contextService;
    }

    public MotivoDeducao findByMotivoId(Long id) {
        this.validaMotivoMovimentacao(id);
        return (MotivoDeducao)this.getCrudRepository().findOne((Object)id);
    }

    public void validaMotivoMovimentacao(Long motivoId) {
        Boolean motivoDeducao = this.motivoDeducaoRepository.existsMotivoMovimentacao(motivoId);
        if (motivoDeducao.booleanValue()) {
            throw new MotivoDeducaoException(HttpStatus.BAD_REQUEST, String.format("N\u00e3o \u00e9 poss\u00edvel alterar o motivo %d, pois j\u00e1 existe movimenta\u00e7\u00e3o cont\u00e1bil", motivoId));
        }
    }

    public Page<MotivoDeducaoDTO> findByEntidadeExercicioAndDescricao(Long exercicio, Long entidade, String descricao, Pageable pageable) {
        return this.motivoDeducaoRepository.findByEntidadeExercicioAndDescricao(exercicio, entidade, descricao, pageable);
    }

    public List<MotivoDeducao> findAllByDescricaoAndTipoOperacaoTCE(String descricao, List<Long> tipoOperacao) {
        return this.motivoDeducaoRepository.findByDescricaoAndTipoOperacaoTce(descricao, tipoOperacao, this.contextService.getExercicioAtual());
    }

    protected void beforeDelete(MotivoDeducao entity, Authentication authentication) {
        super.beforeDelete((EloEntity)entity, authentication);
        this.validaMotivoMovimentacao(entity.getId());
    }

    protected void beforeEdit(MotivoDeducao entity) {
        super.beforeEdit((EloEntity)entity);
        this.validaMotivoMovimentacao(entity.getId());
    }
}

