/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.ModeloBoletoSequencia;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.ModeloBoletoSequenciaService;
import br.com.elotech.tributos.service.ParametroGeralService;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ModeloBoletoService
extends CrudService<ModeloBoleto, Long> {
    private final ModeloBoletoSequenciaService modeloBoletoSequenciaService;
    private final ParametroGeralService parametroGeralService;

    public ModeloBoleto buscarModeloBoletoBySequencia() {
        Long sequencia = this.modeloBoletoSequenciaService.retonarSequenciaAtual();
        return this.modeloBoletoSequenciaService.recuperarSequenciaModeloBloqueto(sequencia).map(ModeloBoletoSequencia::getModeloBoleto).orElse(null);
    }

    public ModeloBoleto retornarConfiguracaoModeloBoletoSequencia() {
        if (!this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_SEQUENCIA_MODELO_BOLETO).booleanValue()) {
            return null;
        }
        return this.buscarModeloBoletoBySequencia();
    }

    @Generated
    public ModeloBoletoService(ModeloBoletoSequenciaService modeloBoletoSequenciaService, ParametroGeralService parametroGeralService) {
        this.modeloBoletoSequenciaService = modeloBoletoSequenciaService;
        this.parametroGeralService = parametroGeralService;
    }
}

