/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ModeloBoletoSequencia;
import br.com.elotech.tributos.repository.ModeloBoletoSequenciaRepository;
import br.com.elotech.tributos.repository.SequenceGeneratorRepository;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ModeloBoletoSequenciaService
extends CrudService<ModeloBoletoSequencia, Long> {
    private final ModeloBoletoSequenciaRepository modeloBoletoSequenciaRepository;
    private final SequenceGeneratorRepository sequenceGeneratorRepository;
    private static final String SEQUENCE_MODELO_BLOQUETO_SEQUENCE = "s05modelobloquetoseq";

    public ModeloBoletoSequencia save(ModeloBoletoSequencia entity, Authentication authentication) {
        Long proximaSequencia = Optional.ofNullable(this.modeloBoletoSequenciaRepository.findMaxSequencia()).orElse(0L);
        entity.setSequencia(Long.valueOf(proximaSequencia + 1L));
        ModeloBoletoSequencia modeloBoletoSequencia = (ModeloBoletoSequencia)this.modeloBoletoSequenciaRepository.save((Object)entity);
        this.removerSequence();
        this.criarSequence();
        return modeloBoletoSequencia;
    }

    public void afterSave(ModeloBoletoSequencia entity, Authentication authentication) {
        this.removerSequence();
        this.criarSequence();
    }

    public void delete(ModeloBoletoSequencia entity, Authentication authentication) {
        this.modeloBoletoSequenciaRepository.deleteById((Object)entity.getId());
        this.reordernarSequencia();
        this.removerSequence();
        this.criarSequence();
    }

    public void reordernarSequencia() {
        List modeloBoletoSequenciasOrdenado = this.modeloBoletoSequenciaRepository.findAllByOrderByIdAsc();
        if (!modeloBoletoSequenciasOrdenado.isEmpty()) {
            AtomicLong novaSequencia = new AtomicLong(1L);
            modeloBoletoSequenciasOrdenado.stream().forEach(modeloBoletoSequencia -> modeloBoletoSequencia.setSequencia(Long.valueOf(novaSequencia.getAndIncrement())));
            this.modeloBoletoSequenciaRepository.saveAll((Iterable)modeloBoletoSequenciasOrdenado);
        }
    }

    public void removerSequence() {
        Boolean sequenceExists = this.sequenceGeneratorRepository.sequenceExistsBySequenceName(SEQUENCE_MODELO_BLOQUETO_SEQUENCE);
        if (sequenceExists.booleanValue()) {
            this.sequenceGeneratorRepository.dropSequence(SEQUENCE_MODELO_BLOQUETO_SEQUENCE);
        }
    }

    public void criarSequence() {
        if (this.modeloBoletoSequenciaRepository.count() > 1L) {
            boolean isCurrentSequenceValid;
            Boolean sequenceExists = this.sequenceGeneratorRepository.sequenceExistsBySequenceName(SEQUENCE_MODELO_BLOQUETO_SEQUENCE);
            Long currentSequenceValue = sequenceExists != false ? this.sequenceGeneratorRepository.getNextVal(SEQUENCE_MODELO_BLOQUETO_SEQUENCE) : null;
            boolean bl = isCurrentSequenceValid = sequenceExists != false && currentSequenceValue != null && currentSequenceValue >= 1L && currentSequenceValue <= this.modeloBoletoSequenciaRepository.count();
            if (!isCurrentSequenceValid) {
                this.sequenceGeneratorRepository.createSequenceWithCycle(SEQUENCE_MODELO_BLOQUETO_SEQUENCE, Integer.valueOf(1), Integer.valueOf((int)this.modeloBoletoSequenciaRepository.count()));
            }
        }
    }

    public Optional<ModeloBoletoSequencia> recuperarSequenciaModeloBloqueto(Long sequencia) {
        return this.modeloBoletoSequenciaRepository.findBySequencia(sequencia);
    }

    public Long retonarSequenciaAtual() {
        boolean isCurrentSequenceValid;
        if (this.modeloBoletoSequenciaRepository.count() == 1L) {
            return 1L;
        }
        Boolean sequenceExists = this.sequenceGeneratorRepository.sequenceExistsBySequenceName(SEQUENCE_MODELO_BLOQUETO_SEQUENCE);
        Long currentSequenceValue = sequenceExists != false ? this.sequenceGeneratorRepository.getNextVal(SEQUENCE_MODELO_BLOQUETO_SEQUENCE) : null;
        boolean bl = isCurrentSequenceValid = sequenceExists != false && currentSequenceValue != null && currentSequenceValue >= 1L && currentSequenceValue <= this.modeloBoletoSequenciaRepository.count();
        if (isCurrentSequenceValid) {
            return currentSequenceValue;
        }
        throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel recuperar a sequ\u00eancia para a gera\u00e7\u00e3o do boleto %s", isCurrentSequenceValid));
    }

    @Generated
    public ModeloBoletoSequenciaService(ModeloBoletoSequenciaRepository modeloBoletoSequenciaRepository, SequenceGeneratorRepository sequenceGeneratorRepository) {
        this.modeloBoletoSequenciaRepository = modeloBoletoSequenciaRepository;
        this.sequenceGeneratorRepository = sequenceGeneratorRepository;
    }
}

