/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.LogradouroTrecho;
import br.com.elotech.tributos.domain.inscricaocadastral.ConfiguracaoInscricaoCadastral;
import br.com.elotech.tributos.dto.LogradouroTrechoDTO;
import br.com.elotech.tributos.repository.LogradouroTrechoRepository;
import br.com.elotech.tributos.service.ConfiguracaoInscricaoCadastralService;
import br.com.elotech.tributos.service.LogradouroTestadaService;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class LogradouroTrechoService
extends CrudService<LogradouroTrecho, Long> {
    private final LogradouroTestadaService logradouroTestadaService;
    private final LogradouroTrechoRepository logradouroTrechoRepository;
    private final ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService;

    public LogradouroTrecho saveDto(LogradouroTrechoDTO dto) {
        this.validaConflito(dto);
        LogradouroTrecho novoTrecho = new LogradouroTrecho();
        LogradouroTrecho logradouroTrecho = dto.toEntity(novoTrecho);
        return (LogradouroTrecho)this.save((EloEntity)logradouroTrecho, null);
    }

    public LogradouroTrecho updateDto(Long id, LogradouroTrechoDTO dto) {
        LogradouroTrecho trecho = (LogradouroTrecho)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar um logradouro trecho com o id %d.", id)));
        if (trecho.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O logradouro trecho com o id %d j\u00e1 est\u00e1 em exclus\u00e3o l\u00f3gica e n\u00e3o pode ser editado.", id));
        }
        this.validaConflito(dto);
        LogradouroTrecho logradouroTrecho = dto.toEntity(trecho);
        return (LogradouroTrecho)this.save((EloEntity)logradouroTrecho, null);
    }

    private void validaConflito(LogradouroTrechoDTO logradouroTrecho) {
        if (this.logradouroTrechoRepository.existeLogradouroTrechoConflito(logradouroTrecho.getId(), logradouroTrecho.getSetor().getId(), logradouroTrecho.getLogradouroTrecho(), logradouroTrecho.getLogradouro().getCidade().getId()).booleanValue()) {
            ConfiguracaoInscricaoCadastral configuracaoInscricao = this.configuracaoInscricaoCadastralService.getConfiguracao();
            String mensagem = String.format("%s: %s, %s: %s, c\u00f3digo trecho: %d, cidade: %s", configuracaoInscricao.getDistrito().getDescricao(), logradouroTrecho.getDistrito().getDescricao(), configuracaoInscricao.getSetor().getDescricao(), logradouroTrecho.getSetor().getSetor(), logradouroTrecho.getLogradouroTrecho(), logradouroTrecho.getLogradouro().getCidade().getDescricao());
            throw new EloValidationException(String.format("J\u00e1 existe um logradouro trecho cadastrado com os seguintes dados: %n %s.", mensagem));
        }
    }

    public LogradouroTrecho marcarComoExclusaoLogica(Long id) {
        LogradouroTrecho logradouroTrecho = (LogradouroTrecho)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar um logradouro trecho com o id %d.", id)));
        if (logradouroTrecho.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O logradouro trecho com o id %d j\u00e1 est\u00e1 em exclus\u00e3o l\u00f3gica.", id));
        }
        List testadasComVinculo = this.logradouroTestadaService.findVinculosByLogradouroTrecho(id);
        if (!testadasComVinculo.isEmpty()) {
            String mensagem = testadasComVinculo.stream().map(Object::toString).collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel excluir o logradouro trecho com o id %d, pois est\u00e1 vinculado \u00e0s seguintes testadas:%n %s.", id, mensagem));
        }
        logradouroTrecho.setExclusaoLogica(Boolean.valueOf(true));
        return (LogradouroTrecho)this.save((EloEntity)logradouroTrecho, null);
    }

    public LogradouroTrecho desfazerExclusaoLogica(Long id) {
        LogradouroTrecho logradouroTrecho = (LogradouroTrecho)this.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar um logradouro trecho com o id %d.", id)));
        if (!logradouroTrecho.getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O logradouro trecho com o id %d n\u00e3o est\u00e1 em exclus\u00e3o l\u00f3gica.", id));
        }
        logradouroTrecho.setExclusaoLogica(Boolean.valueOf(false));
        return (LogradouroTrecho)this.save((EloEntity)logradouroTrecho, null);
    }

    @Generated
    public LogradouroTrechoService(LogradouroTestadaService logradouroTestadaService, LogradouroTrechoRepository logradouroTrechoRepository, ConfiguracaoInscricaoCadastralService configuracaoInscricaoCadastralService) {
        this.logradouroTestadaService = logradouroTestadaService;
        this.logradouroTrechoRepository = logradouroTrechoRepository;
        this.configuracaoInscricaoCadastralService = configuracaoInscricaoCadastralService;
    }
}

