/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.atendimento.Atendimento;
import br.com.elotech.tributos.domain.atendimento.HistoricoAtendimento;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.repository.atendimento.AtendimentoRepository;
import br.com.elotech.tributos.repository.atendimento.HistoricoAtendimentoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import java.time.LocalDateTime;
import java.util.Optional;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class HistoricoAtendimentoService
extends CrudService<HistoricoAtendimento, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HistoricoAtendimentoService.class);
    private final AtendimentoRepository atendimentoRepository;
    private final HistoricoAtendimentoRepository historicoAtendimentoRepository;
    private final EntityManager entityManager;

    public Page<HistoricoAtendimento> findHistoricoAtendimentosByCadastro(Long id, Pageable pageable) {
        return this.historicoAtendimentoRepository.findHistoricoAtendimento(id, pageable);
    }

    public void createHistoricoAtendimento(String obs, TipoAcaoAtendimento tipoAcaoAtendimento) {
        try {
            String headerAtendimento = this.getHeaderAtendimento();
            if (StringUtils.isEmpty((CharSequence)headerAtendimento)) {
                return;
            }
            Atendimento atendimento = (Atendimento)this.atendimentoRepository.findById((Object)Long.valueOf(headerAtendimento)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar atendimento com id %s", headerAtendimento)));
            HistoricoAtendimento historicoAtendimento = this.createHistoricoAtendimento(atendimento, tipoAcaoAtendimento, obs);
            this.historicoAtendimentoRepository.save((Object)historicoAtendimento);
        }
        catch (Exception ex) {
            log.error("Erro ao gerar historico de atendimento %s ", (Throwable)ex);
        }
    }

    public void createHistoricoAtendimento(String obs, TipoAcaoAtendimento tipoAcaoAtendimento, String headerAtendimento) {
        try {
            if (StringUtils.isEmpty((CharSequence)headerAtendimento)) {
                return;
            }
            Atendimento atendimento = (Atendimento)this.atendimentoRepository.findById((Object)Long.valueOf(headerAtendimento)).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar atendimento com id %s", headerAtendimento)));
            HistoricoAtendimento historicoAtendimento = this.createHistoricoAtendimento(atendimento, tipoAcaoAtendimento, obs);
            this.historicoAtendimentoRepository.save((Object)historicoAtendimento);
        }
        catch (Exception ex) {
            log.error("Erro ao gerar historico de atendimento %s ", (Throwable)ex);
        }
    }

    public void createHistoricoInicioAtendimento(Atendimento atendimento) {
        try {
            HistoricoAtendimento historicoAtendimento = this.createHistoricoAtendimento(atendimento, TipoAcaoAtendimento.ABERTURA, "Iniciou Atendimento");
            this.historicoAtendimentoRepository.save((Object)historicoAtendimento);
        }
        catch (Exception ex) {
            log.error("Erro ao gerar historico de atendimento %s ", (Throwable)ex);
        }
    }

    public String getHeaderAtendimento() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(ServletRequestAttributes.class::cast).map(ServletRequestAttributes::getRequest).map(req -> req.getHeader("atendimento")).orElse(null);
    }

    private HistoricoAtendimento createHistoricoAtendimento(Atendimento atendimento, TipoAcaoAtendimento tipoAcaoAtendimento, String observacao) {
        HistoricoAtendimento historicoAtendimento = new HistoricoAtendimento();
        historicoAtendimento.setAtendimento(atendimento);
        historicoAtendimento.setHorario(LocalDateTime.now());
        historicoAtendimento.setAcao(tipoAcaoAtendimento);
        historicoAtendimento.setObservacao(observacao);
        historicoAtendimento.setUsuario(SecurityUtils.getUserAise());
        return historicoAtendimento;
    }

    @Generated
    public HistoricoAtendimentoService(AtendimentoRepository atendimentoRepository, HistoricoAtendimentoRepository historicoAtendimentoRepository, EntityManager entityManager) {
        this.atendimentoRepository = atendimentoRepository;
        this.historicoAtendimentoRepository = historicoAtendimentoRepository;
        this.entityManager = entityManager;
    }
}

