/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.LivroRegistro;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.SituacaoLegal;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.dividaativa.GeraLivroDebitoParcelaTributoDTO;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GeraLivroDividaAtivaEnglobadoService {
    private final CalculoAcrescimoService calculaAcrescimosService;
    private final GeraDebitoService geraDebitoService;
    private final ParametroGeralService parametroGeralService;

    public GeraLivroDividaAtivaEnglobadoService(CalculoAcrescimoService calculaAcrescimosService, GeraDebitoService geraDebitoService, ParametroGeralService parametroGeralService) {
        this.calculaAcrescimosService = calculaAcrescimosService;
        this.geraDebitoService = geraDebitoService;
        this.parametroGeralService = parametroGeralService;
    }

    @Transactional
    public List<GeraLivroDebitoParcelaTributoDTO> geraDebitoEnglobadoAndRateia(LivroRegistro livroRegistro, List<GeraLivroDebitoParcelaTributoDTO> listaDebitoParcelaTributo, FormaPagamento formaPagamento) {
        DebitoManualDTO debitoEnglobadoDTO = this.geraDebitoEnglobado(livroRegistro, listaDebitoParcelaTributo);
        List acrescimos = debitoEnglobadoDTO.getTributos().stream().map(tributo -> AcrescimoDTO.of((DebitoManualDTO)debitoEnglobadoDTO, (DebitoManualTributoDTO)tributo, (Long)formaPagamento.getId(), (Long)livroRegistro.getId().getLivro().getId().getEntidade())).collect(Collectors.toList());
        List debitosComAcrescimos = this.calculaAcrescimosService.calculaAcrescimos(acrescimos);
        Map<String, List<GeraLivroDebitoParcelaTributoDTO>> debitoOrigemPorTributo = listaDebitoParcelaTributo.stream().collect(Collectors.groupingBy(GeraLivroDebitoParcelaTributoDTO::getTributo));
        debitoOrigemPorTributo.forEach((tributo, listaDebitoParcelaTributoDTO) -> listaDebitoParcelaTributoDTO.stream().min(Comparator.comparing(GeraLivroDebitoParcelaTributoDTO::getParcela)).ifPresent(primeiraParcelaDesteTributo -> {
            BigDecimal diferencaValorJuros = this.diferencaValorJurosDebitoEnglobadoComOrigemDoTributo(tributo, debitosComAcrescimos, listaDebitoParcelaTributoDTO);
            BigDecimal diferencaValorMulta = this.diferencaValorMultaDebitoEnglobadoComOrigemDoTributo(tributo, debitosComAcrescimos, listaDebitoParcelaTributoDTO);
            BigDecimal diferencaValorCorrecao = this.diferencaValorCorrecaoDebitoEnglobadoComOrigemDoTributo(tributo, debitosComAcrescimos, listaDebitoParcelaTributoDTO);
            primeiraParcelaDesteTributo.setValorJuros(primeiraParcelaDesteTributo.getValorJuros().add(diferencaValorJuros));
            primeiraParcelaDesteTributo.setValorMulta(primeiraParcelaDesteTributo.getValorMulta().add(diferencaValorMulta));
            primeiraParcelaDesteTributo.setValorCorrecao(primeiraParcelaDesteTributo.getValorCorrecao().add(diferencaValorCorrecao));
        }));
        listaDebitoParcelaTributo.forEach(geraLivroDebitoParcelaTributoDTO -> geraLivroDebitoParcelaTributoDTO.setNovaSubDivida(debitoEnglobadoDTO.getSubDivida()));
        return listaDebitoParcelaTributo;
    }

    private BigDecimal diferencaValorJurosDebitoEnglobadoComOrigemDoTributo(String tributo, List<AcrescimoDTO> debitosEnglobado, List<GeraLivroDebitoParcelaTributoDTO> debitosOrigem) {
        BigDecimal valorJurosDebitoEnglobado = debitosEnglobado.stream().filter(acrescimoTributo -> acrescimoTributo.getTributo().equals(tributo)).map(AcrescimoDTO::getValorJuros).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorJurosDebitoOrigem = debitosOrigem.stream().map(GeraLivroDebitoParcelaTributoDTO::getValorJuros).reduce(BigDecimal.ZERO, BigDecimal::add);
        return valorJurosDebitoEnglobado.subtract(valorJurosDebitoOrigem);
    }

    private BigDecimal diferencaValorMultaDebitoEnglobadoComOrigemDoTributo(String tributo, List<AcrescimoDTO> debitosEnglobado, List<GeraLivroDebitoParcelaTributoDTO> debitosOrigem) {
        BigDecimal valorMultaDebitoEnglobado = debitosEnglobado.stream().filter(acrescimoTributo -> acrescimoTributo.getTributo().equals(tributo)).map(AcrescimoDTO::getValorMulta).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorMultaDebitoOrigem = debitosOrigem.stream().map(GeraLivroDebitoParcelaTributoDTO::getValorMulta).reduce(BigDecimal.ZERO, BigDecimal::add);
        return valorMultaDebitoEnglobado.subtract(valorMultaDebitoOrigem);
    }

    private BigDecimal diferencaValorCorrecaoDebitoEnglobadoComOrigemDoTributo(String tributo, List<AcrescimoDTO> debitosEnglobado, List<GeraLivroDebitoParcelaTributoDTO> debitosOrigem) {
        BigDecimal valorCorrecaoDebitoEnglobado = debitosEnglobado.stream().filter(acrescimoTributo -> acrescimoTributo.getTributo().equals(tributo)).map(AcrescimoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valorCorrecaoDebitoOrigem = debitosOrigem.stream().map(GeraLivroDebitoParcelaTributoDTO::getValorCorrecao).reduce(BigDecimal.ZERO, BigDecimal::add);
        return valorCorrecaoDebitoEnglobado.subtract(valorCorrecaoDebitoOrigem);
    }

    protected DebitoManualDTO geraDebitoEnglobado(LivroRegistro livroRegistro, List<GeraLivroDebitoParcelaTributoDTO> listaDebitoParcelaTributo) {
        String parametroInscricaoPorParcela = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.TIPO_INSCRICAO_DIVIDA_ATIVA, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (parametroInscricaoPorParcela.equals("D")) {
            listaDebitoParcelaTributo.forEach(geraLivro -> geraLivro.setParcelado(Boolean.valueOf(false)));
        }
        DebitoManualDTO debitoEnglobadoDTO = DebitoManualDTO.getDebitoNaoValidaPermissaoDivida();
        LocalDate dataVencimentoPrimeiraParcelaNovoDebito = listaDebitoParcelaTributo.stream().min(Comparator.comparing(GeraLivroDebitoParcelaTributoDTO::getParcela)).map(this.geraDebitoLivroDividaAtiva(debitoEnglobadoDTO, listaDebitoParcelaTributo)).map(GeraLivroDebitoParcelaTributoDTO::getDataVencimento).orElseThrow(() -> new EloValidationException("Data de vencimento da primeira parcela n\u00e3o encontrada."));
        BigDecimal valorTotal = listaDebitoParcelaTributo.stream().map(GeraLivroDebitoParcelaTributoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
        debitoEnglobadoDTO.setDataLancamento(livroRegistro.getDataInscricao());
        debitoEnglobadoDTO.getParcelas().add(this.getDebitoParcelaLivroDividaAtiva(livroRegistro, dataVencimentoPrimeiraParcelaNovoDebito, valorTotal));
        AtomicLong ordemTributo = new AtomicLong();
        Map<String, List<GeraLivroDebitoParcelaTributoDTO>> debitosPorTributo = listaDebitoParcelaTributo.stream().collect(Collectors.groupingBy(GeraLivroDebitoParcelaTributoDTO::getTributo));
        debitosPorTributo.forEach((tributo, listaDebitoParcelaTributoDTO) -> {
            BigDecimal somaPorTributo = listaDebitoParcelaTributoDTO.stream().map(GeraLivroDebitoParcelaTributoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add);
            DebitoManualTributoDTO debitoTributoEnglobadoDTO = new DebitoManualTributoDTO();
            debitoTributoEnglobadoDTO.setOrdem(Long.valueOf(ordemTributo.getAndIncrement()));
            debitoTributoEnglobadoDTO.setTributo(tributo);
            debitoTributoEnglobadoDTO.setValorTributo(somaPorTributo);
            debitoEnglobadoDTO.getTributos().add(debitoTributoEnglobadoDTO);
        });
        DebitoIdDTO debitoIdDTO = this.geraDebitoService.geraDebitoManual(debitoEnglobadoDTO);
        debitoEnglobadoDTO.setSubDivida(debitoIdDTO.getSubDivida());
        return debitoEnglobadoDTO;
    }

    private DebitoManualParcelaDTO getDebitoParcelaLivroDividaAtiva(LivroRegistro livroRegistro, LocalDate dataVencimentoPrimeiraParcelaNovoDebito, BigDecimal valorTotal) {
        DebitoManualParcelaDTO debitoParcelaEnglobadoDTO = new DebitoManualParcelaDTO();
        debitoParcelaEnglobadoDTO.setParcela(Long.valueOf(1L));
        debitoParcelaEnglobadoDTO.setSituacaoLegal(Long.valueOf(SituacaoLegal.DIVIDA_ATIVA.getValue().intValue()));
        debitoParcelaEnglobadoDTO.setLivro(livroRegistro.getId().getLivro().getId().getLivro());
        debitoParcelaEnglobadoDTO.setExercicioLivro(livroRegistro.getId().getLivro().getId().getExercicio());
        debitoParcelaEnglobadoDTO.setNumeroInscricao(livroRegistro.getNumeroInscricao());
        debitoParcelaEnglobadoDTO.setNumeroFolha(livroRegistro.getNumeroFolha());
        debitoParcelaEnglobadoDTO.setDataVencimento(dataVencimentoPrimeiraParcelaNovoDebito);
        debitoParcelaEnglobadoDTO.setDataSituacao(livroRegistro.getDataInscricao());
        debitoParcelaEnglobadoDTO.setDataDividaAtiva(livroRegistro.getDataInscricao());
        debitoParcelaEnglobadoDTO.setValor(valorTotal);
        return debitoParcelaEnglobadoDTO;
    }

    private Function<GeraLivroDebitoParcelaTributoDTO, GeraLivroDebitoParcelaTributoDTO> geraDebitoLivroDividaAtiva(DebitoManualDTO debitoEnglobadoDTO, List<GeraLivroDebitoParcelaTributoDTO> listaDebitoParcelaTributo) {
        return livroDebitoParcelaTributo -> {
            debitoEnglobadoDTO.setExercicio(livroDebitoParcelaTributo.getExercicio());
            debitoEnglobadoDTO.setTipoCadastro(TipoCadastro.fromValue((Long)livroDebitoParcelaTributo.getTipoCadastro()));
            debitoEnglobadoDTO.setCadastroGeral(livroDebitoParcelaTributo.getCadastroGeral());
            debitoEnglobadoDTO.setDivida(livroDebitoParcelaTributo.getDivida());
            debitoEnglobadoDTO.setSubDivida(null);
            debitoEnglobadoDTO.setDataLancamento(livroDebitoParcelaTributo.getDataLancamento());
            debitoEnglobadoDTO.setFormaCorrecao(livroDebitoParcelaTributo.getFormaCorrecao());
            debitoEnglobadoDTO.setPrograma("Livro D\u00edvida Ativa");
            String parcelasString = listaDebitoParcelaTributo.stream().map(GeraLivroDebitoParcelaTributoDTO::getParcela).map(Object::toString).distinct().collect(Collectors.joining(", "));
            debitoEnglobadoDTO.getObservacoes().add(DebitoManualObservacaoDTO.of((String)String.format("D\u00e9bito gerado pela inscri\u00e7\u00e3o em d\u00edvida ativa da subdivida: %d, Parcelas: %s", livroDebitoParcelaTributo.getSubDivida(), parcelasString)));
            return livroDebitoParcelaTributo;
        };
    }
}

