/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.BoletoException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Convenio;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.DividaFormaPagamento;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.MotivoDeducao;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicio;
import br.com.elotech.tributos.domain.ParametroEntidadeExercicioEnum;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.dto.AgrupamentoTributosDTO;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.CodigoBarrasDTO;
import br.com.elotech.tributos.dto.DadosCriaBoletoAgrupadoDTO;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.DebitoPagamentoNegociadoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.DividaFormaPagamentoConvenioDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.StatusPagamentoNegociado;
import br.com.elotech.tributos.dto.acrescimo.CalculaAcrescimoBaseDTO;
import br.com.elotech.tributos.repository.BoletoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoEmAbertoService;
import br.com.elotech.tributos.service.DebitoParcelaTributoService;
import br.com.elotech.tributos.service.DividaFormaPagamentoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.MotivoDeducaoService;
import br.com.elotech.tributos.service.ParametroEntidadeExercicioService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.ValidaEmissaoBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.CodigoBarrasException;
import br.com.elotech.tributos.service.exception.ConvenioBoletoNotFoundException;
import br.com.elotech.tributos.service.exception.DividaFormaPagamentoException;
import br.com.elotech.tributos.service.exception.FormaPagamentoPadraoNotFoundException;
import br.com.elotech.tributos.service.exception.GeraBoletoException;
import br.com.elotech.tributos.service.exception.ModeloBoletoNotFoundException;
import br.com.elotech.tributos.service.exception.NossoNumeroException;
import br.com.elotech.tributos.service.exception.TipoCodigoBarrasBoletoNotFoundException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoBoletoRegistradoReceiver;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoPixReceiver;
import br.com.elotech.tributos.service.ws.AisePdfService;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional
public class GeraBoletoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeraBoletoService.class);
    private final BoletoRepository boletoRepository;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final ParametroEntidadeExercicioService parametroEntidadeExercicioService;
    private final ContextService contextService;
    private final CadastroGeralService cadastroGeralService;
    private final DividaFormaPagamentoService dividaFormaPagamentoService;
    private final ValidaEmissaoBoletoService validaEmissaoBoletoService;
    private final DebitoEmAbertoService debitoEmAbertoService;
    private final DebitoParcelaTributoService debitoParcelaTributoService;
    private final MotivoDeducaoService motivoDeducaoService;
    private final ParametroGeralService parametroGeralService;
    private final IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver;
    private final IntegracaoPixReceiver integracaoPixReceiver;
    private final PessoaService pessoaService;
    private final EntityManager em;
    private final ProtestoService protestoService;
    private final AisePdfService aisePdfService;
    private final ModeloBoletoService modeloBoletoService;

    public List<Bloqueto> geraBoleto(GeraBoletoDTO geraBoletoDTO) {
        return this.geraBoleto(geraBoletoDTO, this.getFormaPagamento(), geraBoletoDTO.getSomenteConstituidos());
    }

    public List<Bloqueto> geraBoleto(GeraBoletoDTO geraBoletoDTO, Consumer<Bloqueto> customizer) {
        return this.geraBoleto(geraBoletoDTO, this.getFormaPagamento(), geraBoletoDTO.getSomenteConstituidos(), null, customizer);
    }

    private void verificaDataReferenciaGuiaAgrupada(GeraBoletoDTO geraBoletoDTO) {
        Boolean utilizaDataReferencia = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.DATA_REFERENCIA_GUIA_AGRUPADA);
        if (Boolean.TRUE.equals(geraBoletoDTO.getImpressaoCarne()) || !utilizaDataReferencia.booleanValue() && Objects.isNull(geraBoletoDTO.getDataReferencia())) {
            geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        }
        if (Objects.nonNull(geraBoletoDTO.getDataReferencia()) && geraBoletoDTO.getDataReferencia().isBefore(this.contextService.getDataAtual())) {
            throw GeraBoletoException.dataReferenciaMenor();
        }
    }

    @Transactional(noRollbackFor={Exception.class})
    public List<Bloqueto> geraBoletoCarneCalculo(GeraBoletoDTO geraBoletoDTO, Long formaPagamento, Boolean somenteDebitosConstituidos, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos) {
        return this.geraBoleto(geraBoletoDTO, formaPagamento, somenteDebitosConstituidos, parametrosAcrescimos, null);
    }

    public List<Bloqueto> geraBoleto(GeraBoletoDTO geraBoletoDTO, Long formaPagamento, Boolean somenteDebitosConstituidos) {
        return this.geraBoleto(geraBoletoDTO, formaPagamento, somenteDebitosConstituidos, null, null);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public List<Bloqueto> geraBoleto(GeraBoletoDTO geraBoletoDTO, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos) {
        return this.geraBoleto(geraBoletoDTO, this.getFormaPagamento(), geraBoletoDTO.getSomenteConstituidos(), parametrosAcrescimos, null);
    }

    public List<Bloqueto> geraBoleto(GeraBoletoDTO geraBoletoDTO, Long formaPagamento, Boolean somenteDebitosConstituidos, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos) {
        return this.geraBoleto(geraBoletoDTO, formaPagamento, somenteDebitosConstituidos, parametrosAcrescimos, null);
    }

    public List<Bloqueto> geraBoleto(GeraBoletoDTO geraBoletoDTO, Long formaPagamento, Boolean somenteDebitosConstituidos, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos, Consumer<Bloqueto> customizer) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("gerarBoleto() - Verificando data de refer\u00eancia de guia agrupada.");
        this.verificaDataReferenciaGuiaAgrupada(geraBoletoDTO);
        log.debug("gerarBoleto() - verifica\u00e7\u00e3o de data de refer\u00eancia levou {}.", (Object)stopwatch);
        stopwatch.reset().start();
        log.debug("gerarBoleto() - Carregando debitos em aberto.");
        List listDebitoEmAberto = this.debitoEmAbertoService.loadDebitoEmAberto(this.mountFiltro(geraBoletoDTO.getDebitos()), somenteDebitosConstituidos);
        log.debug("gerarBoleto() - Carregar debitos em aberto levou {}.", (Object)stopwatch);
        Long exercicioBoleto = Objects.nonNull(geraBoletoDTO.getExercicio()) ? geraBoletoDTO.getExercicio() : this.contextService.getExercicioAtual();
        this.validaEmissaoBoleto(exercicioBoleto, formaPagamento, listDebitoEmAberto);
        stopwatch.reset().start();
        log.debug("gerarBoleto() - Agregar debitos por tipo parcela.");
        List geracaoBoleto = this.agregaDebitoPorTipoBoleto(geraBoletoDTO.getTipoBoleto(), listDebitoEmAberto);
        log.debug("gerarBoleto() - Agregar debitos por tipo parcela levou {}.", (Object)stopwatch.stop());
        Boolean reaproveitaBoleto = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.REAPROVEITA_BOLETO);
        return geracaoBoleto.stream().map(debitos -> {
            if (Boolean.TRUE.equals(reaproveitaBoleto)) {
                List boletos = this.getBoletos(debitos, geraBoletoDTO.getDataReferencia());
                Optional<Bloqueto> boleto = boletos.stream().filter(blt -> blt.getDebitos().size() == debitos.size()).findFirst();
                return boleto.orElseGet(() -> this.createBoleto(geraBoletoDTO, exercicioBoleto, formaPagamento, debitos, Boolean.FALSE, parametrosAcrescimos, customizer));
            }
            return this.createBoleto(geraBoletoDTO, exercicioBoleto, formaPagamento, debitos, Boolean.FALSE, parametrosAcrescimos, customizer);
        }).collect(Collectors.toList());
    }

    public List<Bloqueto> geraBoletoAgrupado(GeraBoletoDTO geraBoletoDTO, Long formaPagamento, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos, List<List<DebitoEmAbertoDTO>> geracaoBoleto, DadosCriaBoletoAgrupadoDTO dadosCriaBoletoAgrupadoDTO) {
        return geracaoBoleto.stream().map(debitos -> this.createBoletoAgrupado(geraBoletoDTO, formaPagamento, debitos, parametrosAcrescimos, dadosCriaBoletoAgrupadoDTO)).collect(Collectors.toList());
    }

    public List<Bloqueto> geraBoletoSuperSimples(GeraBoletoDTO geraBoletoDTO) {
        Long formaPagamento = this.getFormaPagamento();
        Long exercicioAtual = this.contextService.getExercicioAtual();
        Boolean somenteConstituidos = Boolean.FALSE;
        if (Boolean.FALSE.equals(geraBoletoDTO.getUsaExercicioEspecificado())) {
            geraBoletoDTO.setDataReferencia(this.contextService.getDataAtual());
        }
        List listDebitoEmAberto = this.debitoEmAbertoService.loadDebitoEmAberto(this.mountFiltro(geraBoletoDTO.getDebitos()), somenteConstituidos);
        if (Boolean.TRUE.equals(geraBoletoDTO.getEmiteBoletoFintel())) {
            listDebitoEmAberto.forEach(debito -> debito.setEmiteBoleto(Boolean.valueOf(true)));
        }
        this.validaEmissaoBoleto(exercicioAtual, formaPagamento, listDebitoEmAberto);
        List geracaoBoleto = this.agregaDebitoPorTipoBoleto(geraBoletoDTO.getTipoBoleto(), listDebitoEmAberto);
        return geracaoBoleto.stream().map(debitos -> this.createBoleto(geraBoletoDTO, exercicioAtual, formaPagamento, debitos, Boolean.TRUE, null, null)).collect(Collectors.toList());
    }

    @Transactional(noRollbackFor={Exception.class})
    public List<Bloqueto> geraBoletoSanepar(GeraBoletoDTO geraBoletoDTO) {
        return this.geraBoletoSuperSimples(geraBoletoDTO);
    }

    public void validaEmissaoBoleto(Long exercicioAtual, Long formaPagamento, List<DebitoEmAbertoDTO> listaDebitosBoletoDTO) {
        if (listaDebitosBoletoDTO.isEmpty()) {
            throw GeraBoletoException.debitoNaoEmiteBoleto();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("Carregando divida, forma de pagamento e convenio.");
        List listDividaFormaPagamentoConvenio = this.dividaFormaPagamentoService.findDividaFormaPagamentoByIdDebitoAndFormaPagamentoAndExercicio(listaDebitosBoletoDTO.stream().map(CalculaAcrescimoBaseDTO::getIdDebito).collect(Collectors.toList()), formaPagamento, exercicioAtual);
        log.debug("Carregar divida, forma de pagamento e convenio levou {}", (Object)stopwatch);
        stopwatch.reset().start();
        log.debug("Iniciando a valida\u00e7\u00e3o de forma de pagamento.");
        this.validaFormaPagamento(listDividaFormaPagamentoConvenio, formaPagamento);
        log.debug("Valida\u00e7\u00e3o de forma de pagamento levou {}.", (Object)stopwatch);
        stopwatch.reset().start();
        log.debug("Iniciando a valida\u00e7\u00e3o de convenio.");
        this.validaConvenio(listDividaFormaPagamentoConvenio);
        log.debug("Valida\u00e7\u00e3o de convenio levou {}.", (Object)stopwatch);
        stopwatch.reset().start();
        log.debug("Iniciando a valida\u00e7\u00e3o de emiss\u00e3o de boleto.");
        this.validaEmissaoBoletoService.validaEmissaoBoleto(listaDebitosBoletoDTO);
        log.debug("Valida\u00e7\u00e3o de emiss\u00e3o de boleto levou {}.", (Object)stopwatch.stop());
    }

    private List<Bloqueto> getBoletos(List<DebitoEmAbertoDTO> debitos, LocalDate dataReferencia) {
        List ids = debitos.stream().map(DebitoEmAbertoDTO::getIdDebitoParcelaReceita).filter(Objects::nonNull).collect(Collectors.toList());
        return this.boletoRepository.findByListIdDebitoParcelaReceitaAndNaoVencido(ids, dataReferencia);
    }

    private Bloqueto createBoletoAgrupado(GeraBoletoDTO geraBoletoDTO, Long formaPagamento, List<DebitoEmAbertoDTO> debitos, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos, DadosCriaBoletoAgrupadoDTO dadosCriaBoletoAgrupadoDTO) {
        log.debug("Inicio da gera\u00e7\u00e3o do boleto");
        ModeloBoleto modeloBoleto = Optional.ofNullable(geraBoletoDTO.getModeloBoleto()).isEmpty() ? this.recuperarModeloBoletoImpressao(geraBoletoDTO, geraBoletoDTO.getExercicio(), formaPagamento, dadosCriaBoletoAgrupadoDTO.getDividaFormaPagamento(), dadosCriaBoletoAgrupadoDTO.getDebitoEmAbertoDTO()) : geraBoletoDTO.getModeloBoleto();
        Bloqueto boleto = new Bloqueto();
        OrigemEmissao origemEmissao = Optional.ofNullable(geraBoletoDTO.getOrigemEmissao()).orElse(OrigemEmissao.AISE);
        boleto.setOrigemEmissao(origemEmissao);
        boleto.setEntidade(this.contextService.getEntidadePrincipal());
        boleto.setExercicioBloqueto(geraBoletoDTO.getExercicio());
        boleto.setTipoBloqueto(geraBoletoDTO.getTipoBoleto());
        boleto.setDataEmissao(this.contextService.getDataAtual());
        boleto.setDireitoDescontoCotaUnica(Boolean.FALSE);
        boleto.setUtilizaValorBloqueto(Boolean.FALSE);
        if (TipoBloqueto.COTA_UNICA.equals((Object)geraBoletoDTO.getTipoBoleto())) {
            boleto.setDataVencimento(dadosCriaBoletoAgrupadoDTO.getDividaFormaPagamento().getVencimento());
            boleto.setDataLimitePagamento(dadosCriaBoletoAgrupadoDTO.getDividaFormaPagamento().getVencimento());
        } else {
            LocalDate menorDataVencimento = debitos.stream().map(CalculaAcrescimoBaseDTO::getDataVencimento).min(Comparator.comparing(LocalDate::toEpochDay)).orElseThrow(BoletoException::debitoBoletoNotFound);
            boleto.setDataVencimento(this.calcularDataVencimento(geraBoletoDTO.getDataReferencia(), menorDataVencimento));
            boleto.setDataLimitePagamento(this.getDataLimiteVencimento(geraBoletoDTO.getTipoBoleto(), boleto.getDataVencimento(), dadosCriaBoletoAgrupadoDTO.getDividaFormaPagamento()));
        }
        String usuario = Optional.ofNullable(geraBoletoDTO.getUsuario()).filter(StringUtils::isNotBlank).orElseGet(SecurityUtils::getUserAise);
        boleto.setUsuario(usuario);
        boleto.setFormaPagamento(formaPagamento);
        boleto.setModeloBloqueto(modeloBoleto);
        boleto.setObservacao(geraBoletoDTO.getObservacao());
        GeraBoletoService.verificarModeloBoletoSequencia((Bloqueto)boleto);
        boleto.setCadastroGeral(dadosCriaBoletoAgrupadoDTO.getCadastroGeral());
        this.adicionaPessoaAoBoleto(geraBoletoDTO, dadosCriaBoletoAgrupadoDTO.getCadastroGeral(), boleto);
        this.boletoRepository.geraCodigoBoleto(boleto);
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("createBoletoAgrupado() - calculo acrescimos.");
        List debitosEmAberto = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento, this.resolveDataReferencia(geraBoletoDTO, boleto), parametrosAcrescimos);
        log.debug("createBoletoAgrupado() - calculo acrescimos levou {}.", (Object)stopwatch);
        this.adicionaDebitosBoletoAgrupado(debitosEmAberto, dadosCriaBoletoAgrupadoDTO.getDebitoParcelaTributoList(), boleto);
        boleto.atualizaValoresBoleto();
        this.validaMotivoDesconto(geraBoletoDTO.getExercicio(), formaPagamento, boleto, dadosCriaBoletoAgrupadoDTO.getDividaFormaPagamento(), dadosCriaBoletoAgrupadoDTO.getDebitoEmAbertoDTO());
        Convenio convenio = modeloBoleto.getConvenio();
        CodigoBarrasDTO codigoBarrasDTO = this.geraCodigoBarrasDTO(convenio, boleto, Boolean.FALSE);
        this.validaDadosCodigoBarras(codigoBarrasDTO);
        boleto.setCodigoBarras(codigoBarrasDTO);
        boleto.setNossoNumero(codigoBarrasDTO.getNossoNumero());
        boleto.setDvNossoNumero(codigoBarrasDTO.getDvNossoNumero());
        stopwatch.reset().start();
        log.debug("createBoletoAgrupado() - Salvando o boleto");
        Bloqueto boletoSalvo = (Bloqueto)this.boletoRepository.save((Object)boleto);
        log.debug("createBoletoAgrupado() - Salvando o boleto levou {}", (Object)stopwatch);
        boletoSalvo = this.geraQrCodePix(boletoSalvo, Boolean.FALSE);
        log.debug("Fim da gera\u00e7\u00e3o do boleto - identifica\u00e7\u00e3o boleto {}.", (Object)boleto.getBloqueto());
        return boletoSalvo;
    }

    private ModeloBoleto validaModeloBoleto(Long exercicioAtual, Long formaPagamento, DividaFormaPagamento dividaFormaPagamento, DebitoEmAbertoDTO debitoEmAbertoDTO) {
        ModeloBoleto modeloBoleto = Optional.ofNullable(dividaFormaPagamento.getModeloBoleto()).orElseThrow(() -> new ModeloBoletoNotFoundException(debitoEmAbertoDTO.getEntidade(), exercicioAtual, debitoEmAbertoDTO.getDivida(), formaPagamento));
        if (Optional.ofNullable(modeloBoleto.getConvenio()).isEmpty()) {
            throw new ConvenioBoletoNotFoundException(modeloBoleto.getId());
        }
        if (Optional.ofNullable(modeloBoleto.getConvenio().getTipoCodigoBarras()).isEmpty()) {
            throw new TipoCodigoBarrasBoletoNotFoundException(modeloBoleto.getConvenio().getId());
        }
        return modeloBoleto;
    }

    private CodigoBarrasDTO geraCodigoBarrasDTO(Convenio convenio, Bloqueto boleto, Boolean isSimplesOrSanepar) {
        CodigoBarrasDTO codigoBarrasDTO;
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (Boolean.TRUE.equals(convenio.getRegistraBoletoOnline()) && Boolean.FALSE.equals(isSimplesOrSanepar)) {
            log.debug("createBoleto() - Integra\u00e7\u00e3o c\u00f3digo de barras.");
            codigoBarrasDTO = this.integracaoBoletoRegistradoReceiver.receiveRequest(boleto);
            log.debug("createBoleto() - Integra\u00e7\u00e3o c\u00f3digo de barras levou {}.", (Object)stopwatch.stop());
        } else {
            log.debug("createBoleto() - gerando c\u00f3digo de barras...");
            codigoBarrasDTO = convenio.getTipoCodigoBarras().getNossoNumero().gerar(boleto);
            log.debug("createBoleto() - gerando c\u00f3digo de barras levou {}.", (Object)stopwatch.stop());
        }
        return codigoBarrasDTO;
    }

    private Bloqueto createBoleto(GeraBoletoDTO geraBoletoDTO, Long exercicioAtual, Long formaPagamento, List<DebitoEmAbertoDTO> debitos, Boolean isSimplesOrSanepar, ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos, Consumer<Bloqueto> customizer) {
        log.debug("Inicio da gera\u00e7\u00e3o do boleto");
        DebitoEmAbertoDTO debitoEmAbertoDTO = (DebitoEmAbertoDTO)debitos.stream().findFirst().orElseThrow(BoletoException::debitoBoletoNotFound);
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("createBoleto() - Carregando cadastro geral.");
        CadastroGeral cadastroGeral = this.getCadastroGeral(debitoEmAbertoDTO.getTipoCadastro(), debitoEmAbertoDTO.getCadastroGeral());
        log.debug("createBoleto() - Carregando cadastro geral levou {}.", (Object)stopwatch);
        stopwatch.reset().start();
        log.debug("createBoleto() - Carregando DividaFormaPagamento.");
        DividaFormaPagamento dividaFormaPagamento = this.dividaFormaPagamentoService.findByEntidadeAndExercicioAndDividaAndFormaPagamentoId(debitoEmAbertoDTO.getEntidade(), exercicioAtual, debitoEmAbertoDTO.getDivida(), formaPagamento);
        log.debug("createBoleto() - Carregando DividaFormaPagamento levou {}.", (Object)stopwatch);
        ModeloBoleto modeloBoleto = Optional.ofNullable(geraBoletoDTO.getModeloBoleto()).orElseGet(() -> this.recuperarModeloBoletoImpressao(geraBoletoDTO, exercicioAtual, formaPagamento, dividaFormaPagamento, debitoEmAbertoDTO));
        if (geraBoletoDTO.getCodigoModeloBloquetoSemRegistro() != null && geraBoletoDTO.getCodigoModeloBloquetoSemRegistro() > 0L) {
            modeloBoleto = (ModeloBoleto)this.modeloBoletoService.findOne((Serializable)geraBoletoDTO.getCodigoModeloBloquetoSemRegistro());
        }
        Bloqueto boleto = new Bloqueto();
        OrigemEmissao origemEmissao = Optional.ofNullable(geraBoletoDTO.getOrigemEmissao()).orElse(OrigemEmissao.AISE);
        boleto.setOrigemEmissao(origemEmissao);
        boleto.setEntidade(this.contextService.getEntidadePrincipal());
        boleto.setTipoBloqueto(geraBoletoDTO.getTipoBoleto());
        boleto.setDireitoDescontoCotaUnica(Boolean.FALSE);
        boleto.setUtilizaValorBloqueto(Boolean.FALSE);
        if (Boolean.TRUE.equals(geraBoletoDTO.getUsaExercicioEspecificado())) {
            boleto.setExercicioBloqueto(geraBoletoDTO.getExercicio());
            boleto.setDataEmissao(geraBoletoDTO.getDataReferencia());
        } else {
            boleto.setExercicioBloqueto(exercicioAtual);
            boleto.setDataEmissao(this.contextService.getDataAtual());
        }
        LocalDate menorDataVencimento = debitos.stream().map(CalculaAcrescimoBaseDTO::getDataVencimento).min(Comparator.comparing(LocalDate::toEpochDay)).orElseThrow(BoletoException::debitoBoletoNotFound);
        if (TipoBloqueto.COTA_UNICA.equals((Object)geraBoletoDTO.getTipoBoleto())) {
            this.resolveDataVencimentoCotaUnica(geraBoletoDTO, boleto, dividaFormaPagamento, menorDataVencimento);
            if (Boolean.TRUE.equals(geraBoletoDTO.getRecalculo())) {
                boleto.setDataVencimento(menorDataVencimento);
                boleto.setDataLimitePagamento(menorDataVencimento);
                debitos.forEach(db -> db.setAplicaDescontoCotaUnica(Boolean.TRUE));
            }
        } else if (isSimplesOrSanepar.booleanValue()) {
            boleto.setDataVencimento(menorDataVencimento);
            boleto.setDataLimitePagamento(menorDataVencimento);
        } else {
            boleto.setDataVencimento(this.calcularDataVencimento(geraBoletoDTO.getDataReferencia(), menorDataVencimento));
            boleto.setDataLimitePagamento(this.getDataLimiteVencimento(geraBoletoDTO.getTipoBoleto(), boleto.getDataVencimento(), dividaFormaPagamento));
        }
        String usuario = Optional.ofNullable(geraBoletoDTO.getUsuario()).filter(StringUtils::isNotBlank).orElseGet(SecurityUtils::getUserAise);
        boleto.setUsuario(usuario);
        boleto.setFormaPagamento(formaPagamento);
        boleto.setModeloBloqueto(modeloBoleto);
        boleto.setObservacao(geraBoletoDTO.getObservacao());
        boleto.setCadastroGeral(cadastroGeral);
        this.adicionaPessoaAoBoleto(geraBoletoDTO, cadastroGeral, boleto);
        GeraBoletoService.verificarModeloBoletoSequencia((Bloqueto)boleto);
        if (Objects.nonNull(geraBoletoDTO.getMotivoDeducao())) {
            stopwatch.reset().start();
            log.debug("createBoleto() - Carregando MotivoDeducao.");
            MotivoDeducao motivoDeducao = (MotivoDeducao)this.motivoDeducaoService.findById((Serializable)geraBoletoDTO.getMotivoDeducao()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o motivo dedu\u00e7\u00e3o %d.", geraBoletoDTO.getMotivoDeducao().intValue())));
            log.debug("createBoleto() - Carregando MotivoDeducao levou {}.", (Object)stopwatch);
            boleto.setMotivoDeducao(motivoDeducao);
        }
        this.boletoRepository.geraCodigoBoleto(boleto);
        boolean deveCalcularAcrescimos = isSimplesOrSanepar == false;
        stopwatch.reset().start();
        log.debug("createBoleto() - deve calcular acrescimos ? {}.", (Object)deveCalcularAcrescimos);
        List debitosEmAberto = deveCalcularAcrescimos ? this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento, this.resolveDataReferencia(geraBoletoDTO, boleto), parametrosAcrescimos) : debitos;
        log.debug("createBoleto() - calculo acrescimos levou {}.", (Object)stopwatch);
        List ids = debitosEmAberto.stream().filter(dto -> Objects.nonNull(dto.getIdDebitoParcelaReceita())).map(DebitoEmAbertoDTO::getIdDebitoParcelaReceita).collect(Collectors.toList());
        Map debitoParcelasTributos = this.loadDebitoParcelasTributos(ids);
        this.adicionaDebitosBoleto(debitosEmAberto, debitoParcelasTributos, boleto);
        if (Objects.nonNull(customizer)) {
            log.debug("createBoleto() - aplicando o customizer de boleto");
            customizer.accept(boleto);
            log.debug("createBoleto() - finalizou o customizer de boleto");
        }
        boleto.atualizaValoresBoleto();
        this.validaMotivoDesconto(exercicioAtual, formaPagamento, boleto, dividaFormaPagamento, debitoEmAbertoDTO);
        this.verificaRegerarCotaUnicaVencida(geraBoletoDTO, boleto);
        Convenio convenio = modeloBoleto.getConvenio();
        CodigoBarrasDTO codigoBarrasDTO = this.geraCodigoBarrasDTO(convenio, boleto, isSimplesOrSanepar);
        this.validaDadosCodigoBarras(codigoBarrasDTO);
        boleto.setCodigoBarras(codigoBarrasDTO);
        boleto.setNossoNumero(codigoBarrasDTO.getNossoNumero());
        boleto.setDvNossoNumero(codigoBarrasDTO.getDvNossoNumero());
        stopwatch.reset().start();
        log.debug("createBoleto() - Salvando o boleto");
        Bloqueto boletoSalvo = (Bloqueto)this.boletoRepository.save((Object)boleto);
        log.debug("createBoleto() - Salvando o boleto levou {}", (Object)stopwatch);
        boletoSalvo = this.geraQrCodePix(boletoSalvo, isSimplesOrSanepar);
        log.debug("Fim da gera\u00e7\u00e3o do boleto");
        return boletoSalvo;
    }

    private ModeloBoleto recuperarModeloBoletoImpressao(GeraBoletoDTO geraBoletoDTO, Long exercicioAtual, Long formaPagamento, DividaFormaPagamento dividaFormaPagamento, DebitoEmAbertoDTO debitoEmAbertoDTO) {
        if (geraBoletoDTO.getImpressaoCarne().booleanValue()) {
            return this.validaModeloBoleto(exercicioAtual, formaPagamento, dividaFormaPagamento, debitoEmAbertoDTO);
        }
        return Optional.ofNullable(this.modeloBoletoService.retornarConfiguracaoModeloBoletoSequencia()).orElseGet(() -> this.validaModeloBoleto(exercicioAtual, formaPagamento, dividaFormaPagamento, debitoEmAbertoDTO));
    }

    private void resolveDataVencimentoCotaUnica(GeraBoletoDTO geraBoletoDTO, Bloqueto boleto, DividaFormaPagamento dividaFormaPagamento, LocalDate menorDataVencimento) {
        if (Boolean.TRUE.equals(dividaFormaPagamento.getUtilizaVencimentoMenorParcela())) {
            boleto.setDataVencimento(menorDataVencimento);
            boleto.setDataLimitePagamento(menorDataVencimento);
            return;
        }
        boleto.setDataVencimento(dividaFormaPagamento.getVencimento());
        boleto.setDataLimitePagamento(dividaFormaPagamento.getVencimento());
    }

    private void verificaRegerarCotaUnicaVencida(GeraBoletoDTO geraBoletoDTO, Bloqueto boleto) {
        if (TipoBloqueto.COTA_UNICA.equals((Object)geraBoletoDTO.getTipoBoleto()) && geraBoletoDTO.getRegerarCotaUnicaVencida().equals(Boolean.TRUE)) {
            boleto.setDataVencimento(geraBoletoDTO.getDataVencimento());
            boleto.setDataLimitePagamento(geraBoletoDTO.getDataVencimento());
            boleto.setParcelaCotaUnica(Long.valueOf(1L));
            boleto.setAnoProcesso(geraBoletoDTO.getAnoProcesso());
            boleto.setNumeroProcesso(geraBoletoDTO.getNumeroProcesso());
            if (Objects.nonNull(boleto.getMotivoDeducao())) {
                boleto.setDireitoDescontoCotaUnica(Boolean.TRUE);
            }
            boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        }
    }

    private void adicionaPessoaAoBoleto(GeraBoletoDTO geraBoletoDTO, CadastroGeral cadastroGeral, Bloqueto boleto) {
        Pessoa pessoa = Optional.ofNullable(geraBoletoDTO.getPessoa()).map(arg_0 -> this.getPessoa(arg_0)).orElseGet(() -> this.getPessoaBoleto(cadastroGeral));
        boleto.setPessoa(pessoa);
    }

    public Map<Long, List<DebitoParcelaTributo>> loadDebitoParcelasTributos(List<Long> ids) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("createBoleto() - Carregando Mapa de DebitoParcelaTributo.");
        Map<Long, List<DebitoParcelaTributo>> debitoParcelasTributos = this.debitoParcelaTributoService.findByIds(ids).stream().collect(Collectors.groupingBy(DebitoParcelaTributo::getId));
        log.debug("createBoleto() - Carregar Mapa de DebitoParcelaTributo levou {}.", (Object)stopwatch.stop());
        return debitoParcelasTributos;
    }

    private void validaMotivoDesconto(Long exercicioAtual, Long formaPagamento, Bloqueto boleto, DividaFormaPagamento dividaFormaPagamento, DebitoEmAbertoDTO debitoEmAbertoDTO) {
        if (boleto.getValorDesconto().compareTo(BigDecimal.ZERO) > 0 && Objects.isNull(boleto.getMotivoDeducao())) {
            if (Objects.isNull(dividaFormaPagamento.getMotivoDeducao())) {
                throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel gerar o boleto, pois este possui valor de desconto mas n\u00e3o possui motivo de desconto configurado. Forma pagamento %d, d\u00edvida %d, exerc\u00edcio de %d.", formaPagamento, debitoEmAbertoDTO.getDivida(), exercicioAtual));
            }
            boleto.setMotivoDeducao(dividaFormaPagamento.getMotivoDeducao());
        }
    }

    private Bloqueto geraQrCodePix(Bloqueto boletoSalvo, Boolean isSimplesOrSanepar) {
        try {
            if (Boolean.TRUE.equals(boletoSalvo.getModeloBloqueto().getConvenio().getUtilizaPix()) && Boolean.FALSE.equals(isSimplesOrSanepar)) {
                Stopwatch stopwatch = Stopwatch.createStarted();
                log.debug("createBoleto() - Gerando QrCode PIX.");
                boletoSalvo = this.integracaoPixReceiver.gerarQrCodePix(boletoSalvo);
                boletoSalvo = (Bloqueto)this.boletoRepository.save((Object)boletoSalvo);
                log.debug("createBoleto() - Gerando QrCode PIX.", (Object)stopwatch.stop());
            }
        }
        catch (Exception e) {
            log.error("Erro ao gerar o codigo qrcode do pix", (Throwable)e);
        }
        return boletoSalvo;
    }

    private void adicionaDebitosBoletoAgrupado(List<DebitoEmAbertoDTO> debitosEmAberto, List<DebitoParcelaTributo> debitoParcelaTributos, Bloqueto boleto) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("createBoletoAgrupado() - Adicionando debitos ao boleto.");
        debitosEmAberto.stream().map(boletoDebitoDTO -> {
            DebitoParcelaTributo debitoParcelaTributo = debitoParcelaTributos.stream().filter(debitoParcela -> boletoDebitoDTO.getIdDebitoParcelaReceita().equals(debitoParcela.getId())).findFirst().orElseThrow(() -> new EloValidationException(String.format("Debito Parcela Tributo %d n\u00e3o encontrado.", boletoDebitoDTO.getIdDebitoParcelaReceita())));
            return BoletoDebito.of((Bloqueto)boleto, (DebitoParcelaTributo)debitoParcelaTributo, (DebitoEmAbertoDTO)boletoDebitoDTO);
        }).forEach(boleto.getDebitos()::add);
        log.debug("createBoletoAgrupado() - Adicionando debitos ao boleto levou {}.", (Object)stopwatch);
    }

    private void adicionaDebitosBoleto(List<DebitoEmAbertoDTO> debitosEmAberto, Map<Long, List<DebitoParcelaTributo>> debitoParcelasTributos, Bloqueto boleto) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.debug("createBoleto() - Adicionando debitos ao boleto.");
        Integer diasBloqueioDebitoProtesto = this.parametroGeralService.getParamValueAsInteger(ParametroGeralEnum.DIAS_BLOQ_DEB_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        debitosEmAberto.stream().map(boletoDebitoDTO -> {
            List debitoParcelaTributos = Optional.ofNullable((List)debitoParcelasTributos.get(boletoDebitoDTO.getIdDebitoParcelaReceita())).orElseThrow(() -> new EloValidationException(String.format("Debito Parcela Tributo %d n\u00e3o encontrado.", boletoDebitoDTO.getIdDebitoParcelaReceita())));
            DebitoParcelaTributo debitoParcelaTributo = (DebitoParcelaTributo)debitoParcelaTributos.stream().findAny().orElseThrow();
            this.protestoService.validaDebitoProtestado(debitoParcelaTributo.getDebitoParcela(), diasBloqueioDebitoProtesto);
            return BoletoDebito.of((Bloqueto)boleto, (DebitoParcelaTributo)debitoParcelaTributo, (DebitoEmAbertoDTO)boletoDebitoDTO);
        }).forEach(boleto.getDebitos()::add);
        log.debug("createBoleto() - Adicionando debitos ao boleto levou {}.", (Object)stopwatch);
    }

    private LocalDate resolveDataReferencia(GeraBoletoDTO geraBoletoDTO, Bloqueto boleto) {
        return geraBoletoDTO.getImpressaoCarne() != false ? geraBoletoDTO.getDataReferencia() : boleto.getDataVencimento();
    }

    public Bloqueto createBoletoForPagamentoNegociado(List<DebitoPagamentoNegociadoDTO> debitos, MotivoDeducao motivoDeducao, CadastroGeral cadastroGeral) {
        DebitoPagamentoNegociadoDTO primeiroDebito = (DebitoPagamentoNegociadoDTO)debitos.stream().findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o foram encontrados d\u00e9bitos para abater no pagamento negociado"));
        Long formaPagamentoPadrao = Long.valueOf(Optional.ofNullable(this.getFormaPagamentoParametroPagamentoNegociado()).orElseThrow(FormaPagamentoPadraoNotFoundException::new).getValor());
        DividaFormaPagamento dividaFormaPagamento = Optional.ofNullable(this.dividaFormaPagamentoService.findByEntidadeAndExercicioAndDividaAndFormaPagamentoId(primeiroDebito.getEntidade(), primeiroDebito.getExercicio(), primeiroDebito.getDivida(), formaPagamentoPadrao)).orElseThrow(() -> new DividaFormaPagamentoException(primeiroDebito.getDivida(), formaPagamentoPadrao));
        ModeloBoleto modeloBoleto = Optional.ofNullable(dividaFormaPagamento.getModeloBoleto()).orElseThrow(() -> new ModeloBoletoNotFoundException(primeiroDebito.getEntidade(), primeiroDebito.getExercicio(), primeiroDebito.getDivida(), formaPagamentoPadrao));
        Bloqueto boleto = new Bloqueto();
        boleto.setOrigemEmissao(OrigemEmissao.AISE_WEB);
        boleto.setEntidade(this.contextService.getEntidadePrincipal());
        boleto.setExercicioBloqueto(this.contextService.getExercicioAtual());
        boleto.setTipoBloqueto(TipoBloqueto.AGRUPADO);
        boleto.setDataEmissao(this.contextService.getDataAtual());
        boleto.setDireitoDescontoCotaUnica(Boolean.FALSE);
        boleto.setUtilizaValorBloqueto(Boolean.TRUE);
        boleto.setUsuario(SecurityUtils.getUserAise());
        boleto.setFormaPagamento(formaPagamentoPadrao);
        boleto.setDataVencimento(this.contextService.getDataAtual());
        boleto.setModeloBloqueto(modeloBoleto);
        boleto.setCadastroGeral(cadastroGeral);
        boleto.setPessoa(this.getPessoaBoleto(cadastroGeral));
        boleto.setMotivoDeducao(motivoDeducao);
        this.boletoRepository.geraCodigoBoleto(boleto);
        boleto.setDebitos(new ArrayList());
        debitos.stream().forEach(debito -> {
            BigDecimal percentualBaixaParcial = debito.getPercentualBaixaParcial();
            AtomicReference<BigDecimal> valorRateado = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            if (debito.getTributosAgrupados().isEmpty()) {
                BoletoDebito boletoDebito = BoletoDebito.of((Bloqueto)boleto, (DebitoPagamentoNegociadoDTO)debito, (BigDecimal)percentualBaixaParcial);
                valorRateado.set(valorRateado.get().add(boletoDebito.getValorTotal()));
                BigDecimal diferencaRateio = this.getDiferencaRateio(debito, valorRateado);
                if (diferencaRateio.compareTo(BigDecimal.ZERO) != 0) {
                    boletoDebito.setValorPrincipal(boletoDebito.getValorPrincipal().add(diferencaRateio));
                }
                boleto.getDebitos().add(boletoDebito);
            } else {
                for (AgrupamentoTributosDTO tributo : debito.getTributosAgrupados()) {
                    BoletoDebito boletoDebito = BoletoDebito.of((Bloqueto)boleto, (AgrupamentoTributosDTO)tributo, (BigDecimal)percentualBaixaParcial);
                    boleto.getDebitos().add(boletoDebito);
                    valorRateado.set(valorRateado.get().add(boletoDebito.getValorTotal()));
                }
                BigDecimal diferencaRateio = this.getDiferencaRateio(debito, valorRateado);
                if (diferencaRateio.compareTo(BigDecimal.ZERO) != 0) {
                    boleto.getDebitos().stream().max(Comparator.comparing(BoletoDebito::getValorPrincipal)).ifPresent(receita -> receita.setValorPrincipal(receita.getValorPrincipal().add(diferencaRateio)));
                }
            }
        });
        boleto.atualizaValoresBoleto();
        CodigoBarrasDTO codigoBarrasDTO = modeloBoleto.getConvenio().getTipoCodigoBarras().getNossoNumero().gerar(boleto);
        this.validaDadosCodigoBarras(codigoBarrasDTO);
        boleto.setCodigoBarras(codigoBarrasDTO);
        boleto.setNossoNumero(codigoBarrasDTO.getNossoNumero());
        boleto.setDvNossoNumero("0");
        return boleto;
    }

    private BigDecimal getDiferencaRateio(DebitoPagamentoNegociadoDTO debito, AtomicReference<BigDecimal> valorRateado) {
        if (StatusPagamentoNegociado.TOTAL.equals((Object)debito.getStatus())) {
            return BigDecimal.ZERO;
        }
        return debito.getValorAbatido().subtract(valorRateado.get());
    }

    private CadastroGeral getCadastroGeral(Long tipoCadastro, Long cadastroGeral) {
        return (CadastroGeral)this.cadastroGeralService.findByTipoCadastroAndCadastroGeral(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral).orElseThrow(() -> new CadastroNaoEncontradoException(TipoCadastro.fromValue((Long)tipoCadastro), cadastroGeral));
    }

    public void validaConvenio(List<DividaFormaPagamentoConvenioDTO> listDividaFormaPagamentoConvenio) {
        listDividaFormaPagamentoConvenio.stream().filter(Predicates.not(DividaFormaPagamentoConvenioDTO::hasConvenio)).findAny().ifPresent(debito -> {
            throw new GeraBoletoException(String.format("N\u00e3o h\u00e1 conv\u00eanio configurado para d\u00edvida %d.", debito.getDivida()));
        });
        if (listDividaFormaPagamentoConvenio.stream().collect(Collectors.groupingBy(DividaFormaPagamentoConvenioDTO::getConvenio)).size() > 1) {
            throw new GeraBoletoException("As d\u00edvidas selecionadas s\u00e3o de conv\u00eanios diferentes.");
        }
    }

    public List<List<DebitoEmAbertoDTO>> agregaDebitoPorTipoBoleto(TipoBloqueto tipoBoleto, List<DebitoEmAbertoDTO> listaDebitosBoletoDTO) {
        ArrayList<List<DebitoEmAbertoDTO>> debitosAgrupadosPorBoleto = new ArrayList<List<DebitoEmAbertoDTO>>();
        if (TipoBloqueto.PARCELADO.equals((Object)tipoBoleto)) {
            Map<Long, Map<Long, List<DebitoEmAbertoDTO>>> debitosAgrupadosPorParcela = listaDebitosBoletoDTO.stream().collect(Collectors.groupingBy(CalculaAcrescimoBaseDTO::getIdDebito, Collectors.groupingBy(CalculaAcrescimoBaseDTO::getParcela)));
            debitosAgrupadosPorParcela.forEach((idDebito, parcelas) -> parcelas.forEach((parcela, values) -> debitosAgrupadosPorBoleto.add((List<DebitoEmAbertoDTO>)values)));
            return debitosAgrupadosPorBoleto;
        }
        if (TipoBloqueto.COTA_UNICA.equals((Object)tipoBoleto)) {
            Map<Long, List<DebitoEmAbertoDTO>> debitosAgrupadosPorDebito = listaDebitosBoletoDTO.stream().collect(Collectors.groupingBy(CalculaAcrescimoBaseDTO::getIdDebito));
            debitosAgrupadosPorDebito.forEach((idDebito, debito) -> debitosAgrupadosPorBoleto.add((List<DebitoEmAbertoDTO>)debito));
            return debitosAgrupadosPorBoleto;
        }
        debitosAgrupadosPorBoleto.add(listaDebitosBoletoDTO);
        return debitosAgrupadosPorBoleto;
    }

    public LocalDate getDataLimiteVencimentoBoletoEspecial(Bloqueto boleto, Long divida, Long formaPagamento) {
        if (TipoBloqueto.PARCELADO.equals((Object)boleto.getTipoBloqueto())) {
            DividaFormaPagamento dividaFormaPagamento = this.dividaFormaPagamentoService.findByEntidadeAndExercicioAndDividaAndFormaPagamentoId(boleto.getEntidade(), boleto.getExercicioBloqueto(), divida, formaPagamento);
            return Optional.ofNullable(dividaFormaPagamento).map(DividaFormaPagamento::getValidade).map(validade -> boleto.getDataVencimento().plusDays((long)validade)).orElse(boleto.getDataVencimento());
        }
        return boleto.getDataVencimento();
    }

    public LocalDate getDataLimiteVencimento(TipoBloqueto tipoBloqueto, LocalDate dataVencimento, DividaFormaPagamento dividaFormaPagamento) {
        if (TipoBloqueto.PARCELADO.equals((Object)tipoBloqueto) && Objects.nonNull(dividaFormaPagamento.getValidade())) {
            return dataVencimento.plusDays(dividaFormaPagamento.getValidade());
        }
        return dataVencimento;
    }

    public Long getFormaPagamento() {
        return Long.valueOf(Optional.ofNullable(this.parametroEntidadeExercicioService.findByModuloAndParametro(ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.FORMA_PAGAMENTO_PADRAO.getValue())).orElseThrow(FormaPagamentoPadraoNotFoundException::new).getValor());
    }

    public ParametroEntidadeExercicio getFormaPagamentoParametroPagamentoNegociado() {
        return Optional.ofNullable(this.parametroEntidadeExercicioService.findByKeyAndValorNotEmpty(ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.FORMA_PAGAMENTO_PADRAO_NEGOCIADO.getValue())).orElse(this.parametroEntidadeExercicioService.findByKeyAndValorNotEmpty(ModuloEnum.MODULO_TRIBUTARIO.getValue(), ParametroEntidadeExercicioEnum.FORMA_PAGAMENTO_PADRAO.getValue()));
    }

    private LocalDate calcularDataVencimento(LocalDate dataReferencia, LocalDate dataVencimentoParcela) {
        return Objects.isNull(dataReferencia) || dataVencimentoParcela.isAfter(dataReferencia) ? dataVencimentoParcela : dataReferencia;
    }

    public void validaFormaPagamento(List<DividaFormaPagamentoConvenioDTO> listDividaFormaPagamentoConvenio, Long formaPagamento) {
        listDividaFormaPagamentoConvenio.stream().filter(Predicates.not(DividaFormaPagamentoConvenioDTO::hasFormaPagamento)).findAny().ifPresent(debito -> {
            throw new DividaFormaPagamentoException(debito.getDivida(), formaPagamento);
        });
    }

    public void validaDadosCodigoBarras(CodigoBarrasDTO dto) {
        if (!Optional.ofNullable(dto.getNossoNumero()).isPresent() || dto.getNossoNumero().isEmpty()) {
            throw new NossoNumeroException();
        }
        if (!Optional.ofNullable(dto.getCodigoBarras()).isPresent() || dto.getCodigoBarras().isEmpty()) {
            throw new CodigoBarrasException();
        }
        if (!Optional.ofNullable(dto.getLinhaDigitavel()).isPresent() || dto.getLinhaDigitavel().isEmpty()) {
            throw NossoNumeroException.linhaDigitavelNotFound();
        }
    }

    private Pessoa getPessoa(Long pessoa) {
        return (Pessoa)this.pessoaService.findById(pessoa).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar pessoa com o id %d", pessoa)));
    }

    public Pessoa getPessoaBoleto(CadastroGeral cadastroGeral) {
        if (cadastroGeral.getTipoCadastro().isMobiliario().booleanValue()) {
            return cadastroGeral.getPessoa();
        }
        Optional<Proprietario> proprietario = cadastroGeral.getProprietarios().stream().filter(prop -> Boolean.TRUE.equals(prop.getCoResponsavelPrincipal()) && Objects.nonNull(prop.getVinculo()) && TipoVinculo.CORESPONSAVEL.equals((Object)prop.getVinculo().getTipoVinculo())).findFirst();
        if (proprietario.isPresent()) {
            return proprietario.get().getPessoa();
        }
        proprietario = cadastroGeral.getProprietarios().stream().filter(prop -> Boolean.TRUE.equals(prop.getPrincipal()) && Objects.nonNull(prop.getVinculo()) && TipoVinculo.PRINCIPAL.equals((Object)prop.getVinculo().getTipoVinculo())).findFirst();
        if (proprietario.isPresent()) {
            return proprietario.get().getPessoa();
        }
        return cadastroGeral.getPessoa();
    }

    public String mountFiltro(List<DebitoParcelaDTO> parcelas) {
        return parcelas.stream().map(parcela -> String.format(" (tribdebito.iddebito = %d  and tribdebitoparcela.parcela = %d) ", parcela.getIdDebito(), parcela.getParcela())).collect(Collectors.joining(" or "));
    }

    public void validaModeloBoleto(ModeloBoleto modeloBoleto) {
        if (!Optional.ofNullable(modeloBoleto.getConvenio()).isPresent()) {
            throw new ConvenioBoletoNotFoundException(modeloBoleto.getId());
        }
        if (!Optional.ofNullable(modeloBoleto.getConvenio().getTipoCodigoBarras()).isPresent()) {
            throw new TipoCodigoBarrasBoletoNotFoundException(modeloBoleto.getConvenio().getId());
        }
    }

    public List<BloquetoDTO> resolveUrlImpressaoBoleto(List<BloquetoDTO> boletosDTO, Boolean porContribuinte) {
        if (boletosDTO.size() > 1) {
            this.setUrlImpressaoParcelado(boletosDTO);
            return boletosDTO;
        }
        if (Boolean.TRUE.equals(porContribuinte)) {
            return this.setUrlImpressaoPorContribuinte(boletosDTO);
        }
        return this.setUrlImpressao(boletosDTO);
    }

    private List<BloquetoDTO> setUrlImpressao(List<BloquetoDTO> boletosDTO) {
        return boletosDTO.stream().map(boleto -> {
            boleto.setUrlImpressao(this.aisePdfService.fetchBloquetoByExercicio(boleto.getBloqueto(), boleto.getExercicioBloqueto()));
            return boleto;
        }).collect(Collectors.toList());
    }

    private void setUrlImpressaoParcelado(List<BloquetoDTO> boletosDTO) {
        String urlImpressao = this.getUrlImpressaoParcelado(boletosDTO);
        boletosDTO.forEach(boletoDTO -> boletoDTO.setUrlImpressao(urlImpressao));
    }

    private List<BloquetoDTO> setUrlImpressaoPorContribuinte(List<BloquetoDTO> boletosDTO) {
        Long parametroBloquetoPorContribuinte = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.RELATORIOBLOQUETOCADDIFERENTE, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (Objects.nonNull(parametroBloquetoPorContribuinte)) {
            String urlImpressao = this.getUrlImpressaoAgrupadoContribuinte(boletosDTO, parametroBloquetoPorContribuinte);
            return boletosDTO.stream().map(dto -> {
                dto.setUrlImpressao(urlImpressao);
                return dto;
            }).collect(Collectors.toList());
        }
        return this.setUrlImpressao(boletosDTO);
    }

    public String getUrlImpressaoAgrupadoContribuinte(List<BloquetoDTO> boletosDTO, Long relatorio) {
        List value = boletosDTO.stream().map(BloquetoDTO::getBloqueto).collect(Collectors.toList());
        Long exercicioBloqueto = boletosDTO.stream().map(BloquetoDTO::getExercicioBloqueto).findFirst().orElse(this.contextService.getExercicioAtual());
        return this.aisePdfService.fetchBloquetoParceladoByExercicio(value, exercicioBloqueto, relatorio);
    }

    public String getUrlImpressaoParcelado(List<BloquetoDTO> boletosDTO) {
        Long modeloRelatorio = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.RELATORIO_BLOQUETO_PARCELADO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        List value = boletosDTO.stream().map(BloquetoDTO::getBloqueto).collect(Collectors.toList());
        Long exercicioBloqueto = boletosDTO.stream().map(BloquetoDTO::getExercicioBloqueto).findFirst().orElse(this.contextService.getEntidadePrincipal());
        return this.aisePdfService.fetchBloquetoParceladoByExercicio(value, exercicioBloqueto, modeloRelatorio);
    }

    private static ModeloBoleto verificarModeloBoletoSequencia(Bloqueto bloqueto) {
        return Optional.of(bloqueto.getModeloBloqueto()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi informado o modelo bloqueto para o bloqueto.", new Object[0])));
    }

    @Generated
    public GeraBoletoService(BoletoRepository boletoRepository, CalculoAcrescimoService calculoAcrescimoService, ParametroEntidadeExercicioService parametroEntidadeExercicioService, ContextService contextService, CadastroGeralService cadastroGeralService, DividaFormaPagamentoService dividaFormaPagamentoService, ValidaEmissaoBoletoService validaEmissaoBoletoService, DebitoEmAbertoService debitoEmAbertoService, DebitoParcelaTributoService debitoParcelaTributoService, MotivoDeducaoService motivoDeducaoService, ParametroGeralService parametroGeralService, IntegracaoBoletoRegistradoReceiver integracaoBoletoRegistradoReceiver, IntegracaoPixReceiver integracaoPixReceiver, PessoaService pessoaService, EntityManager em, ProtestoService protestoService, AisePdfService aisePdfService, ModeloBoletoService modeloBoletoService) {
        this.boletoRepository = boletoRepository;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.parametroEntidadeExercicioService = parametroEntidadeExercicioService;
        this.contextService = contextService;
        this.cadastroGeralService = cadastroGeralService;
        this.dividaFormaPagamentoService = dividaFormaPagamentoService;
        this.validaEmissaoBoletoService = validaEmissaoBoletoService;
        this.debitoEmAbertoService = debitoEmAbertoService;
        this.debitoParcelaTributoService = debitoParcelaTributoService;
        this.motivoDeducaoService = motivoDeducaoService;
        this.parametroGeralService = parametroGeralService;
        this.integracaoBoletoRegistradoReceiver = integracaoBoletoRegistradoReceiver;
        this.integracaoPixReceiver = integracaoPixReceiver;
        this.pessoaService = pessoaService;
        this.em = em;
        this.protestoService = protestoService;
        this.aisePdfService = aisePdfService;
        this.modeloBoletoService = modeloBoletoService;
    }
}

