/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliarioProfissional;
import br.com.elotech.tributos.dto.CadastroGeralEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.CadastroGeralMobiliarioEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.dto.ProfissionalEdicaoEmMassaDTO;
import br.com.elotech.tributos.enums.TipoEdicaoEmMassa;
import br.com.elotech.tributos.repository.EdicaoEmMassaRepository;
import br.com.elotech.tributos.repository.mobiliario.MobiliarioProfissionalRepository;
import br.com.elotech.tributos.service.batch.EdicaoEmMassaJobStarter;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class EdicaoEmMassaService {
    private final EdicaoEmMassaRepository edicaoEmMassaRepository;
    private final EdicaoEmMassaJobStarter edicaoEmMassaJobStarter;
    private final MobiliarioProfissionalRepository mobiliarioProfissionalRepository;

    public Page<CadastroGeralEdicaoEmMassaDTO> findCadastrosImobiliriosWithFilter(EdicaoEmMassaFiltroDTO filtro, Pageable pageable) {
        String sql = this.edicaoEmMassaRepository.generateSql(filtro, TipoEdicaoEmMassa.IMOBILIARIO);
        Long total = this.edicaoEmMassaRepository.getTotalCadastrosWithFilter(sql);
        return new PageImpl(this.edicaoEmMassaRepository.findCadastrosImobiliariosWithFilter(filtro, pageable), pageable, total.longValue());
    }

    public Page<CadastroGeralMobiliarioEdicaoEmMassaDTO> findCadastrosMobiliriosWithFilter(EdicaoEmMassaFiltroDTO filtro, Pageable pageable) {
        String sql = this.edicaoEmMassaRepository.generateSql(filtro, TipoEdicaoEmMassa.MOBILIARIO);
        Long total = this.edicaoEmMassaRepository.getTotalCadastrosWithFilter(sql);
        List mobiliarios = this.edicaoEmMassaRepository.findCadastrosMobiliariosWithFilter(filtro, pageable);
        List ids = mobiliarios.stream().map(CadastroGeralMobiliarioEdicaoEmMassaDTO::getIdCadastro).collect(Collectors.toList());
        Map<Long, List<ProfissionalEdicaoEmMassaDTO>> profissionaisByCadastro = this.mobiliarioProfissionalRepository.findByCadastroMobiliarioIdIn(ids).stream().map(CadastroMobiliarioProfissional::toProfissionalEdicaoEmMassaDTO).collect(Collectors.groupingBy(ProfissionalEdicaoEmMassaDTO::getIdCadastro));
        mobiliarios.forEach(m -> m.setProfissionais((List)profissionaisByCadastro.get(m.getIdCadastro())));
        return new PageImpl(mobiliarios, pageable, total.longValue());
    }

    public void updateCadastros(EdicaoEmMassaFiltroDTO filtro, TipoEdicaoEmMassa tipo) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        this.edicaoEmMassaJobStarter.startJob(filtro, tipo);
    }

    @Generated
    public EdicaoEmMassaService(EdicaoEmMassaRepository edicaoEmMassaRepository, EdicaoEmMassaJobStarter edicaoEmMassaJobStarter, MobiliarioProfissionalRepository mobiliarioProfissionalRepository) {
        this.edicaoEmMassaRepository = edicaoEmMassaRepository;
        this.edicaoEmMassaJobStarter = edicaoEmMassaJobStarter;
        this.mobiliarioProfissionalRepository = mobiliarioProfissionalRepository;
    }
}

