/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.response.ArquivoUrl;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CertidaoDividaAtivaService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.documento.peticao.LotePeticaoService;
import br.com.elotech.tributos.service.exception.EnvioArquivoProcuradoriaException;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Transactional;
import lombok.Generated;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.tomcat.util.http.fileupload.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DocumentoUnificadoPeticaoCdaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentoUnificadoPeticaoCdaService.class);
    private final TarefaAssincronaService tarefaAssincronaService;
    private final LotePeticaoService lotePeticaoService;
    private final CertidaoDividaAtivaService certidaoDividaAtivaService;
    private final DocumentoService documentoService;
    private final NotificacaoService notificacaoService;
    private final ResolversHandler resolversHandler;

    @Async
    @Transactional
    public void gerarArquivoUnificadoEmLote(List<Long> idsPeticoes) {
        LOGGER.info("Validando a possibilidade de iniciar processo ass\u00edncrono de gera\u00e7\u00e3o de arquivos unificado. ");
        this.validateIniciarTarefaGeracaoArquivo(idsPeticoes);
        LOGGER.info("Iniciando gera\u00e7\u00e3o de arquivos unifados Peti\u00e7\u00e3o + CDA. IDS Peti\u00e7\u00e3o: {}", idsPeticoes);
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaGeracaoArquivoUnificadoPeticaoCda(idsPeticoes);
        Long tarefa = execucao.getTarefaAssincrona().getId();
        UserSecurityDTO userSecurityDTO = SecurityUtils.getUserSecurityDTO();
        Optional notificacaoId = this.notificacaoService.send("Iniciando Gera\u00e7\u00e3o Peti\u00e7\u00f5es em Lote", String.format("Iniciando a gera\u00e7\u00e3o do PDF das Peti\u00e7\u00f5es em Lote %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        try {
            byte[] zip = this.generateArquivoUnificadoEAgrupar(idsPeticoes);
            Arquivo arquivo = this.generateArquivoZipado(zip);
            TarefaAssincrona tarefaAssincrona = this.finalizarTarefaEAtualizarParametro(tarefa, arquivo, execucao);
            this.notificacaoService.send("Finalizada gera\u00e7\u00e3o de PDF de CDA em lote", String.format("Finalizada com sucesso a gera\u00e7\u00e3o do PDF do Lote CDA da tarefa %s", tarefa), tarefaAssincrona, notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
            LOGGER.info("Finalizado o agrupamento dos arquivos unificados de Peti\u00e7\u00e3o + CDA e disponibilizado no S3. Peti\u00e7\u00f5es: {}", idsPeticoes);
        }
        catch (Exception e) {
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, e.getMessage());
            LOGGER.error("Erro ao agrupar arquivos unificados de Peti\u00e7\u00e3o + CDA {} ", (Object)e.getMessage(), (Object)e);
            this.notificacaoService.send("Finalizado o agrupamento dos arquivos unificados de Peti\u00e7\u00e3o + CDA", String.format("Ocorreu um erro na gera\u00e7\u00e3o do PDF do Lote CDA da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
        }
    }

    public TarefaAssincrona finalizarTarefaEAtualizarParametro(Long tarefa, Arquivo arquivo, TarefaAssincronaExecucao execucao) {
        TarefaAssincrona tarefaAssincrona = this.tarefaAssincronaService.findOne(tarefa);
        if (tarefaAssincrona.getParametros().isEmpty()) {
            throw new IllegalArgumentException("Tarefa n\u00e3o possui par\u00e2metros para atualizar!");
        }
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)arquivo.getFullPath());
        ArquivoUrl url = this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest);
        TarefaAssincrona tarefaAtualizada = this.tarefaAssincronaService.updateTarefaComParametroUrlArquivo(tarefaAssincrona, url.getUrlAssinada());
        this.tarefaAssincronaService.finalizarExecucao(execucao);
        return tarefaAtualizada;
    }

    public byte[] generateArquivoUnificadoEAgrupar(List<Long> idsPeticoes) {
        Map arquivosUnificados = idsPeticoes.stream().flatMap(idPeticao -> {
            try {
                return Stream.of(this.buildDocumentoUnificado(idPeticao));
            }
            catch (IOException e) {
                LOGGER.error("Erro ao gerar arquivo unificado para a peti\u00e7\u00e3o: {}", idPeticao, (Object)e);
                return Stream.empty();
            }
        }).collect(Collectors.toMap(ArquivoNovoRequest::getFileName, Function.identity()));
        return FileUtils.zipBytes(arquivosUnificados);
    }

    public Arquivo generateArquivoZipado(byte[] zip) {
        LOGGER.info("Salvando arquivo agrupado no S3");
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(this.createNomeArquivoUnificadoZip()).content((InputStream)new ByteArrayInputStream(zip)).contentType(ContentType.APPLICATION_ZIP).build();
        return this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
    }

    private String createNomeArquivoUnificadoZip() {
        return String.format("arquivos_unifacados_%s.zip", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss")));
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    private void validateIniciarTarefaGeracaoArquivo(List<Long> idsPeticoes) {
        this.validateIdsPeticoes(idsPeticoes);
        this.validateTarefaEmExecucaoGeracaoArquivoUnificado(idsPeticoes);
    }

    private void validateTarefaEmExecucaoGeracaoArquivoUnificado(List<Long> idsPeticoes) {
        Boolean existeProcessoEmExecucao = this.tarefaAssincronaService.existsProcessoEmExecucao(TipoTarefaAssincrona.GERACAO_ARQUIVO_UNIFICADO_PETICAO_CDA, "CHAVE_URL_ARQUIVO_UNIFICADO_ZIP", idsPeticoes.toString());
        if (Boolean.TRUE.equals(existeProcessoEmExecucao)) {
            throw new IllegalArgumentException(String.format("J\u00e1 existe um processo em execu\u00e7\u00e3o para gera\u00e7\u00e3o de arquivo unificado! Parametros: %s", idsPeticoes));
        }
    }

    private void validateIdsPeticoes(List<Long> idsPeticoes) {
        if (Objects.isNull(idsPeticoes) || idsPeticoes.isEmpty()) {
            throw new IllegalArgumentException("Lista de ids de peti\u00e7\u00f5es n\u00e3o pode estar vazia para gerar arquivo unificado!");
        }
    }

    public ArquivoNovoRequest buildDocumentoUnificado(Long idPeticao) throws IOException {
        PDDocument document = new PDDocument();
        Documento documento = (Documento)this.documentoService.findOne((Serializable)idPeticao);
        if (Boolean.TRUE.equals(documento.getEnviadoProcuradoria())) {
            throw new EnvioArquivoProcuradoriaException(String.format("A Peti\u00e7\u00e3o %d j\u00e1 foi enviado para Procuradoria!", idPeticao));
        }
        LOGGER.info("Iniciando impress\u00e3o do documento da Peti\u00e7\u00e3o: {}", (Object)idPeticao);
        byte[] peticaoInfo = this.lotePeticaoService.printPeticao(idPeticao);
        this.mergeInfoToDocument(document, peticaoInfo);
        LOGGER.info("Iniciando impress\u00e3o do documento das CDA da Peti\u00e7\u00e3o: {}", (Object)idPeticao);
        for (Documento documentoCda : documento.getCertidoesDividaAtivaPeticao()) {
            byte[] certidaoDividaAtivaInfo = this.certidaoDividaAtivaService.printCertidaoDividaAtiva(documentoCda.getId());
            this.mergeInfoToDocument(document, certidaoDividaAtivaInfo);
        }
        documento.setDataArquivoUnificadoGerado(LocalDateTime.now());
        this.documentoService.update(documento);
        return this.createNewFileRequest(documento.getDocumento(), documento.getExercicio(), this.saveDocument(document));
    }

    private void mergeInfoToDocument(PDDocument document, byte[] infoToAppendDocumento) throws IOException {
        PDFMergerUtility pdfMerge = new PDFMergerUtility();
        this.appendInfoToDocument(document, pdfMerge, infoToAppendDocumento);
    }

    private void appendInfoToDocument(PDDocument document, PDFMergerUtility pdfMerge, byte[] info) throws IOException {
        PDDocument pdfDocument = PDDocument.load((byte[])info);
        pdfMerge.appendDocument(document, pdfDocument);
        pdfDocument.close();
    }

    private InputStream saveDocument(PDDocument document) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save((OutputStream)byteArrayOutputStream);
        document.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private ArquivoNovoRequest createNewFileRequest(Long idPeticao, Long exercicioPeticao, InputStream inputStream) {
        String nomeArquivo = String.format("[%s]%d_%d.pdf", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss")), exercicioPeticao, idPeticao);
        return ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(nomeArquivo).content(inputStream).contentType(ContentType.APPLICATION_PDF).build();
    }

    @Generated
    public DocumentoUnificadoPeticaoCdaService(TarefaAssincronaService tarefaAssincronaService, LotePeticaoService lotePeticaoService, CertidaoDividaAtivaService certidaoDividaAtivaService, DocumentoService documentoService, NotificacaoService notificacaoService, ResolversHandler resolversHandler) {
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.lotePeticaoService = lotePeticaoService;
        this.certidaoDividaAtivaService = certidaoDividaAtivaService;
        this.documentoService = documentoService;
        this.notificacaoService = notificacaoService;
        this.resolversHandler = resolversHandler;
    }
}

