/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.tributos.domain.DocumentoFinalidade;
import br.com.elotech.tributos.domain.DocumentoTipo;
import br.com.elotech.tributos.domain.EntidadeTributacao;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoValidadeDocumento;
import br.com.elotech.tributos.dto.DocumentoFinalidadeDTO;
import br.com.elotech.tributos.dto.DocumentoFinalidadeTributosDTO;
import br.com.elotech.tributos.dto.DocumentoTipoAssinaturaDTO;
import br.com.elotech.tributos.dto.DocumentoTipoDTO;
import br.com.elotech.tributos.repository.DocumentoTipoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DocumentoFinalidadeService;
import br.com.elotech.tributos.service.DocumentoTipoService;
import br.com.elotech.tributos.service.EntidadeTributacaoService;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.util.ListUtils;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class DocumentoTipoService {
    private final DocumentoTipoRepository documentoTipoRepository;
    private final EntityManager em;
    private final ContextService contextService;
    private final DocumentoFinalidadeService documentoFinalidadeService;
    private final EntidadeTributacaoService entidadeTributacaoService;

    public DocumentoTipoService(DocumentoTipoRepository documentoTipoRepository, EntityManager em, ContextService contextService, DocumentoFinalidadeService documentoFinalidadeService, EntidadeTributacaoService entidadeTributacaoService) {
        this.documentoTipoRepository = documentoTipoRepository;
        this.em = em;
        this.contextService = contextService;
        this.documentoFinalidadeService = documentoFinalidadeService;
        this.entidadeTributacaoService = entidadeTributacaoService;
    }

    public List<DocumentoTipo> findByRsql(Optional<String> search) {
        if (search.isPresent()) {
            Specification specification = Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.em, DocumentoTipo.class, (String)search.get(), Optional.empty()));
            return this.documentoTipoRepository.findAll(specification);
        }
        return this.documentoTipoRepository.findAll();
    }

    public Page<DocumentoTipo> findByRsqlPaged(String search, Pageable pageable) {
        if (StringUtils.isBlank((CharSequence)search)) {
            return this.documentoTipoRepository.findAll(pageable);
        }
        Specification specification = Specification.where((Specification)RsqlUtils.createSpecFrom((EntityManager)this.em, DocumentoTipo.class, (String)search, Optional.empty()));
        return this.documentoTipoRepository.findAll(specification, pageable);
    }

    public DocumentoTipo findById(Long id) {
        return (DocumentoTipo)this.documentoTipoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado o tipo documento %d", id)));
    }

    public DocumentoTipoDTO findByTipoDocumento(Long id) {
        DocumentoTipoDTO documentoTipoDTO = DocumentoTipoDTO.of((DocumentoTipo)this.findById(id));
        documentoTipoDTO.setFinalidades(this.documentoFinalidadeService.findByEntidadeAndExercicioAndTipoDocumentoId(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual(), id).stream().map(DocumentoFinalidadeTributosDTO::from).sorted(Comparator.comparing(DocumentoFinalidadeDTO::getDescricao)).collect(Collectors.toList()));
        return documentoTipoDTO;
    }

    public List<DocumentoTipoDTO> findPermitidos(Long tipoCadastro) {
        String usuario = Optional.ofNullable(SecurityUtils.getUserAise()).orElseThrow(() -> new RestException(HttpStatus.FORBIDDEN, "Necess\u00e1rio vincular um usu\u00e1rio aise ao usu\u00e1rio logado."));
        return this.documentoTipoRepository.findPermitidos(this.contextService.getEntidadePrincipal(), usuario, TipoCadastro.fromValue((Long)tipoCadastro)).stream().map(DocumentoTipoDTO::of).collect(Collectors.toList());
    }

    public List<DocumentoTipoDTO> findDocumentosProjeto() {
        String usuario = Optional.ofNullable(SecurityUtils.getUserAise()).orElseThrow(() -> new RestException(HttpStatus.FORBIDDEN, "Necess\u00e1rio vincular um usu\u00e1rio aise ao usu\u00e1rio logado."));
        return this.documentoTipoRepository.findDocumentosProjeto(this.contextService.getEntidadePrincipal(), usuario).stream().map(DocumentoTipoDTO::of).collect(Collectors.toList());
    }

    public List<TipoCadastro> findTiposCadastroDisponiveisEmissao(Long tipoDocumento) {
        DocumentoTipo documentoTipo = this.findById(tipoDocumento);
        return documentoTipo.getTiposCadastro();
    }

    public DocumentoTipo update(Long id, DocumentoTipoDTO dto) {
        EntidadeTributacao entidadeTributacao = this.entidadeTributacaoService.findByEntidadeIdAndExercicio(this.contextService.getEntidadePrincipal(), this.contextService.getExercicioAtual());
        if (Objects.isNull(entidadeTributacao) || Objects.isNull(entidadeTributacao.getExercicio())) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel carregar os par\u00e2metros da entidade/tributa\u00e7\u00e3o para o exerc\u00edcio atual.");
        }
        if (Objects.isNull(dto)) {
            throw new EloValidationException("A atualiza\u00e7\u00e3o do tipo do documento requer que seja informado as novas informa\u00e7\u00f5es.");
        }
        DocumentoTipo entity = (DocumentoTipo)this.documentoTipoRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar o tipo do documento %d.", id)));
        this.validaTipoDocumento(entidadeTributacao.getExercicio(), dto);
        entity.setDescricao(dto.getDescricao());
        Optional.ofNullable(dto.getImpressaoWeb()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setImpressaoWeb(arg_0));
        Optional.ofNullable(dto.getPorCadastroGeral()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setPorCadastroGeral(arg_0));
        Optional.ofNullable(dto.getAtivo()).ifPresent(ativo -> entity.setInativo(Boolean.valueOf(ativo == false)));
        Optional.ofNullable(dto.getExigeProcesso()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setExigeProcesso(arg_0));
        Optional.ofNullable(dto.getPossuiCabecalho()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setPossuiCabecalho(arg_0));
        Optional.ofNullable(dto.getPossuiRodape()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setPossuiRodape(arg_0));
        Optional.ofNullable(dto.getPossuiObservacao()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setPossuiObservacao(arg_0));
        Optional.ofNullable(dto.getPossuiHistorico()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setPossuiHistorico(arg_0));
        Optional.ofNullable(dto.getArmazenarComoPdf()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setArmazenarComoPdf(arg_0));
        Optional.ofNullable(dto.getMaisDeUmLayout()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setMaisDeUmLayout(arg_0));
        Optional.ofNullable(dto.getVerificaDebitoPendente()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setVerificaDebitoPendente(arg_0));
        Optional.ofNullable(dto.getVerificaAssinaturaDigital()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setVerificaAssinaturaDigital(arg_0));
        Optional.ofNullable(dto.getExigeProjeto()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setExigeProjeto(arg_0));
        entity.setAssunto(dto.getAssunto());
        Optional.ofNullable(dto.getGeraDocumentoCentral()).ifPresent(arg_0 -> ((DocumentoTipo)entity).setGeraDocumentoCentral(arg_0));
        entity.setValidade(Optional.ofNullable(dto.getValidade()).map(TipoValidadeDocumento::fromValue).orElse(TipoValidadeDocumento.NAO_POSSUI));
        entity.setValidadeDia((Integer)Optional.ofNullable(dto.getValidadeDia()).map(Long::intValue).orElse(null));
        entity.setValidadeData((LocalDate)Optional.ofNullable(dto.getValidadeData()).orElse(null));
        entity.setRelatorio(dto.getRelatorio());
        List finalidades = this.mergeFinalidades(entidadeTributacao, entity, dto.getFinalidades());
        entity.getFinalidades().clear();
        entity.getFinalidades().addAll(finalidades);
        List assinaturas = entity.mergeAssinaturas(dto.getAssinaturas());
        entity.getAssinaturas().clear();
        entity.getAssinaturas().addAll(assinaturas);
        entity.getTiposCadastro().clear();
        entity.getTiposCadastro().addAll(dto.getTiposCadastro());
        entity.getRelatorios().clear();
        entity.getRelatorios().addAll(dto.getRelatorios());
        entity.getGruposDocumento().clear();
        entity.getGruposDocumento().addAll(dto.getGruposDocumento());
        return (DocumentoTipo)this.documentoTipoRepository.save((Object)entity);
    }

    private void validaTipoDocumento(Long exercicioAtual, DocumentoTipoDTO dto) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$TipoValidadeDocumento[TipoValidadeDocumento.fromValue((String)dto.getValidade()).ordinal()]) {
            case 1: {
                if (this.checkPorTipoDocumentoCamposNulos(dto)) {
                    throw new EloValidationException("Para tipo de validade 'Por Tipo Documento', o campo 'Validade na Data' ou 'Validade em Dias' deve ser configurado.");
                }
                if (!this.checkPorTipoDocumentoAmbosCamposPreenchidos(dto)) break;
                throw new EloValidationException("Para tipo de validade 'Por Tipo Documento', apenas um dos campos 'Validade na Data' e 'Validade em Dias' podem estar preenchidos.");
            }
            case 2: {
                if (this.checkPeloMenosUmCampoValidadePreenchido(dto)) {
                    throw new EloValidationException("Para o tipo de validade diferente de 'Por Tipo Documento', os campos referente a validade (Validade na Data e Validade em Dias) n\u00e3o devem estar preenchidos.");
                }
                if (!dto.getFinalidades().isEmpty()) break;
                throw new EloValidationException("Para o tipo de validade 'Por Finalidade' \u00e9 necess\u00e1rio cadastrar ao menos uma finalidade.");
            }
            case 3: {
                if (!this.checkPeloMenosUmCampoValidadePreenchido(dto)) break;
                throw new EloValidationException("Para o tipo de validade diferente de 'Por Tipo Documento', os campos referente a validade (Validade na Data e Validade em Dias) n\u00e3o devem estar preenchidos.");
            }
        }
        if (Objects.nonNull(dto.getFinalidades())) {
            this.validaFinalidadesIdsDuplicados(dto.getFinalidades());
            if (dto.getFinalidades().stream().anyMatch(finalidade -> Objects.isNull(finalidade.getExercicio()))) {
                throw new EloValidationException("Existe finalidade sem exerc\u00edcio configurado.");
            }
            if (dto.getFinalidades().stream().anyMatch(finalidade -> !exercicioAtual.equals(finalidade.getExercicio()))) {
                throw new EloValidationException("Somente ser\u00e1 poss\u00edvel atualizar as finalidades do mesmo exerc\u00edcio.");
            }
        }
        this.verifyDatasAssinaturas(dto.getAssinaturas());
    }

    private void verifyDatasAssinaturas(List<DocumentoTipoAssinaturaDTO> assinaturas) {
        assinaturas.forEach(assinatura -> {
            if (Objects.isNull(assinatura.getSequencia()) && assinatura.getPeriodoInicial().isBefore(LocalDate.now())) {
                throw new EloValidationException("A Data Inicial n\u00e3o pode ser anterior \u00e0 data de hoje.");
            }
            if (Objects.nonNull(assinatura.getPeriodoFinal()) && assinatura.getPeriodoFinal().isBefore(assinatura.getPeriodoInicial())) {
                throw new EloValidationException(String.format("A Data Final n\u00e3o pode ser anterior \u00e0 Data Inicial: \"%s\".", DateUtils.localDateToStringFormatoBrasileiro((LocalDate)assinatura.getPeriodoInicial())));
            }
        });
    }

    private boolean checkPorTipoDocumentoCamposNulos(DocumentoTipoDTO dto) {
        return Objects.isNull(dto.getValidadeData()) && ((Long)ObjectUtils.defaultIfNull((Object)dto.getValidadeDia(), (Object)0L)).compareTo(0L) <= 0;
    }

    private boolean checkPorTipoDocumentoAmbosCamposPreenchidos(DocumentoTipoDTO dto) {
        return Objects.nonNull(dto.getValidadeData()) && ((Long)ObjectUtils.defaultIfNull((Object)dto.getValidadeDia(), (Object)0L)).compareTo(0L) > 0;
    }

    private boolean checkPeloMenosUmCampoValidadePreenchido(DocumentoTipoDTO dto) {
        return Objects.nonNull(dto.getValidadeData()) || ((Long)ObjectUtils.defaultIfNull((Object)dto.getValidadeDia(), (Object)0L)).compareTo(0L) > 0;
    }

    private List<DocumentoFinalidade> mergeFinalidades(EntidadeTributacao entidadeTributacao, DocumentoTipo documentoTipo, List<DocumentoFinalidadeDTO> finalidadesDTO) {
        List finalidades = this.mergeFinalidadesExercicioAtual(entidadeTributacao, documentoTipo, finalidadesDTO);
        finalidades.addAll(documentoTipo.getFinalidadesForaDoExercicio(entidadeTributacao.getExercicio()));
        return finalidades.stream().sorted(Comparator.comparing(DocumentoFinalidade::getExercicio).thenComparing(DocumentoFinalidade::getSequencia)).collect(Collectors.toList());
    }

    private List<DocumentoFinalidade> mergeFinalidadesExercicioAtual(EntidadeTributacao entidadeTributacao, DocumentoTipo documentoTipo, List<DocumentoFinalidadeDTO> finalidadesDTO) {
        List finalidadesFromDTO = finalidadesDTO.stream().map(finalidadeDTO -> DocumentoFinalidade.from((DocumentoFinalidadeDTO)finalidadeDTO, (EntidadeTributacao)entidadeTributacao, (DocumentoTipo)documentoTipo)).collect(Collectors.toList());
        List documentoFinalidades = ListUtils.merge((List)documentoTipo.getFinalidades(), finalidadesFromDTO, DocumentoFinalidade::getId, DocumentoFinalidade::merge);
        AtomicLong sequencia = new AtomicLong(this.getNextFinalidadeSequencia(documentoTipo.getFinalidades(), entidadeTributacao.getExercicio()));
        documentoFinalidades.forEach(finalidade -> finalidade.setSequencia(Long.valueOf(Objects.isNull(finalidade.getSequencia()) ? sequencia.getAndIncrement() : finalidade.getSequencia().longValue())));
        return documentoFinalidades;
    }

    private void validaFinalidadesIdsDuplicados(List<DocumentoFinalidadeDTO> finalidadesDTO) {
        List idsDuplicados = ListUtils.findDuplicateItems(finalidadesDTO.stream().filter(finalidadeDTO -> Objects.nonNull(finalidadeDTO.getId())).map(DocumentoFinalidadeDTO::getId).collect(Collectors.toList()));
        if (!idsDuplicados.isEmpty()) {
            throw new EloValidationException("Existem finalidades com ID's duplicados.");
        }
    }

    private Long getNextFinalidadeSequencia(List<DocumentoFinalidade> finalidades, Long exercicio) {
        return finalidades.stream().filter(item -> Objects.nonNull(item.getSequencia()) && exercicio.equals(item.getExercicio())).map(DocumentoFinalidade::getSequencia).max(Long::compare).map(max -> max + 1L).orElse(1L);
    }
}

