/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DebitoParcelaTributo;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtiva;
import br.com.elotech.tributos.domain.DocumentoItemDividaAtivaId;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.SituacaoDocumento;
import br.com.elotech.tributos.domain.TipoDocumentoEnum;
import br.com.elotech.tributos.domain.documento.cda.LoteCdaItemDetalhe;
import br.com.elotech.tributos.dto.DocumentoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoCdaDTO;
import br.com.elotech.tributos.dto.acrescimo.AcrescimoDTO;
import br.com.elotech.tributos.dto.documento.cda.AtualizaItensParcelasDTO;
import br.com.elotech.tributos.dto.documento.cda.DeleteCDAItemDTO;
import br.com.elotech.tributos.repository.DebitoParcelaTributoRepository;
import br.com.elotech.tributos.repository.DocumentoItemDividaAtivaRepository;
import br.com.elotech.tributos.repository.DocumentoRepository;
import br.com.elotech.tributos.service.CertidaoDividaAtivaHistoricoService;
import br.com.elotech.tributos.service.DocumentoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.documento.cda.LoteCdaItemDetalheService;
import br.com.elotech.tributos.service.exception.DocumentoNotFoundException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class DocumentoItemDividaAtivaService
extends CrudService<DocumentoItemDividaAtiva, DocumentoItemDividaAtivaId> {
    private final DocumentoItemDividaAtivaRepository documentoItemDividaAtivaRepository;
    private final DocumentoService documentoService;
    private final DocumentoRepository documentoRepository;
    private final FormaPagamentoService formaPagamentoService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService;
    private final DebitoParcelaTributoRepository debitoParcelaTributoRepository;
    private final LoteCdaItemDetalheService loteCdaItemDetalheService;
    private final ParametroGeralService parametroGeralService;

    public Documento removerVinculo(DeleteCDAItemDTO deleteCDAItemDTO) {
        Documento documento = Optional.ofNullable((Documento)this.documentoService.findOne((Serializable)deleteCDAItemDTO.getIdDocumento())).orElseThrow(() -> new DocumentoNotFoundException(deleteCDAItemDTO.getIdDocumento()));
        if (documento.getCadastroGeral().getExclusaoLogica().booleanValue()) {
            throw new EloValidationException(String.format("O cadastro %d-%d est\u00e1 em exclus\u00e3o l\u00f3gica.", documento.getCadastroGeral().getTipoCadastro().getValue(), documento.getCadastroGeral().getCadastroGeral()));
        }
        DocumentoDTO documentoDTO = DocumentoDTO.fromWithDocumentoItemDividaAtivas((Documento)documento);
        List documentosItemDividaAtivaParaRemover = this.documentoItemDividaAtivaRepository.findByDebitoParcela(deleteCDAItemDTO.getEntidade(), deleteCDAItemDTO.getExercicio(), deleteCDAItemDTO.getTipoCadastro(), deleteCDAItemDTO.getCadastroGeral(), deleteCDAItemDTO.getDivida(), deleteCDAItemDTO.getSubDivida(), deleteCDAItemDTO.getParcela());
        List documentoDividaAtivaAgrupados = documentoDTO.agruparDocumentosDividaAtivaPorParcela(deleteCDAItemDTO.getEntidade());
        if (documentoDividaAtivaAgrupados.size() <= 1) {
            throw new EloValidationException("N\u00e3o \u00e9 poss\u00edvel remover o v\u00ednculo se houver apenas uma parcela");
        }
        documentosItemDividaAtivaParaRemover.forEach(itemDividaAtiva -> {
            this.documentoItemDividaAtivaRepository.deleteDocumentoItemPeticaoByDocumentoItemDividaAtivaId(itemDividaAtiva.getId().getEntidade(), itemDividaAtiva.getId().getExercicio(), itemDividaAtiva.getId().getTipoDocumento(), itemDividaAtiva.getId().getDocumento(), itemDividaAtiva.getId().getSequenciaItem());
            this.certidaoDividaAtivaHistoricoService.salvaHistoricoOperacaoRemocaoDebito(documento, itemDividaAtiva);
        });
        documento.getDocumentoItemDividaAtivas().removeAll(documentosItemDividaAtivaParaRemover);
        return (Documento)this.documentoService.save((EloEntity)documento, null);
    }

    public Documento atualizaItensParcelas(Long idDocumento, AtualizaItensParcelasDTO dto) {
        return this.atualizaItensParcelas(idDocumento, dto, null);
    }

    public Documento atualizaItensParcelas(Long idDocumento, AtualizaItensParcelasDTO dto, ListasNecessariasCalculaAcrescimoDTO necessariasCalculaAcrescimo) {
        Documento documento = this.findDocumentoById(idDocumento);
        documento = this.removeParcelasDiferenteDeAbertoMedianteParametro(documento, dto);
        if (!(documento = this.cancelaDocumentoCasoNaoTenhaParcelaVinculada(documento)).isCancelado()) {
            documento = this.atualizarParcelasDoDocumento(documento, dto, necessariasCalculaAcrescimo);
        }
        return (Documento)this.documentoRepository.saveAndFlush((Object)documento);
    }

    private LoteCdaItemDetalhe getLoteCdaItemDetalheComValoresAtualizados(DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        LoteCdaItemDetalhe loteCdaItemDetalhe = this.loteCdaItemDetalheService.findByDocumentoItemDividaAtiva(documentoItemDividaAtiva);
        if (Objects.nonNull(loteCdaItemDetalhe)) {
            loteCdaItemDetalhe.setValor(documentoItemDividaAtiva.getValor());
            loteCdaItemDetalhe.setValorMulta(documentoItemDividaAtiva.getValorMulta());
            loteCdaItemDetalhe.setValorCorrecao(documentoItemDividaAtiva.getValorCorrecao());
            loteCdaItemDetalhe.setValorJuros(documentoItemDividaAtiva.getValorJuros());
        }
        return loteCdaItemDetalhe;
    }

    private Optional<DebitoParcelaTributo> getParcelaSeTemCancelamento(Documento documento, DocumentoItemDividaAtiva documentoItemDividaAtiva) {
        return this.debitoParcelaTributoRepository.getDebitoParcelaComCancelamento(documento.getEntidade(), documentoItemDividaAtiva.getExercicioDebito(), documentoItemDividaAtiva.getTipoCadastro(), documentoItemDividaAtiva.getCadastroGeral(), documentoItemDividaAtiva.getCodigoDivida(), documentoItemDividaAtiva.getSubDivida(), documentoItemDividaAtiva.getParcela(), documentoItemDividaAtiva.getTributo());
    }

    private AcrescimoDTO getAcrescimoDaParcela(AtualizaItensParcelasDTO dto, Long sequenciaItem) {
        Long entidade = dto.getEntidade();
        Long exercicio = dto.getExercicio();
        Long idDocumento = dto.getDocumento();
        LocalDate dataReferencia = dto.getDataReferencia();
        AcrescimoCdaDTO acrescimoCdaDTO = this.documentoItemDividaAtivaRepository.findAcrescimosCdaItem(entidade, exercicio, idDocumento, sequenciaItem);
        FormaPagamento formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty());
        return AcrescimoDTO.of((AcrescimoCdaDTO)acrescimoCdaDTO, (Long)formaPagamento.getId(), (LocalDate)dataReferencia);
    }

    public List<DocumentoItemDividaAtiva> findByDocumentoId(Long idDocumento) {
        return this.documentoItemDividaAtivaRepository.findByDocumentoId(idDocumento);
    }

    public Documento removeParcelasDiferenteDeAbertoMedianteParametro(Documento documento, AtualizaItensParcelasDTO dto) {
        boolean isRetiraParcelaComStatusDiferenteDeAberto = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.DELETEDEBITOSPAGOSECANCCDA);
        if (isRetiraParcelaComStatusDiferenteDeAberto) {
            List idItensDiferentesDeAberto = this.findItensDiferentesDeAberto(dto);
            documento.getDocumentoItemDividaAtivas().removeIf(item -> idItensDiferentesDeAberto.contains(item.getId()));
        }
        return documento;
    }

    public Documento cancelaDocumentoCasoNaoTenhaParcelaVinculada(Documento documento) {
        if (documento.getDocumentoItemDividaAtivas().isEmpty()) {
            documento.setCancelado(Boolean.TRUE);
            documento.setSituacao(SituacaoDocumento.cancelado());
        }
        return documento;
    }

    private Documento findDocumentoById(Long id) {
        return this.documentoService.findDocumentoDomainById(id);
    }

    private List<DocumentoItemDividaAtivaId> findItensDiferentesDeAberto(AtualizaItensParcelasDTO dto) {
        return this.documentoItemDividaAtivaRepository.findIdsDiferentesDeAberto(dto.getEntidade(), dto.getExercicio(), dto.getDocumento());
    }

    public Documento atualizarParcelasDoDocumento(Documento documento, AtualizaItensParcelasDTO dto, ListasNecessariasCalculaAcrescimoDTO necessariasCalculaAcrescimo) {
        ListasNecessariasCalculaAcrescimoDTO listasNecessarias = Optional.ofNullable(necessariasCalculaAcrescimo).orElse(this.calculoAcrescimoService.createNecessariasCalculaAcrescimo());
        ArrayList<LoteCdaItemDetalhe> loteCdaItemDetalhes = new ArrayList<LoteCdaItemDetalhe>();
        for (DocumentoItemDividaAtiva item : documento.getDocumentoItemDividaAtivas()) {
            this.atualizaItemComDadosParcelaCancelada(item);
            this.atualizarValoresItem(dto, item, listasNecessarias);
            LoteCdaItemDetalhe loteCdaItemDetalhe = this.getLoteCdaItemDetalheComValoresAtualizados(item);
            if (!Objects.nonNull(loteCdaItemDetalhe)) continue;
            loteCdaItemDetalhes.add(loteCdaItemDetalhe);
        }
        this.loteCdaItemDetalheService.saveAll(loteCdaItemDetalhes);
        return documento;
    }

    private void atualizaItemComDadosParcelaCancelada(DocumentoItemDividaAtiva item) {
        Documento documento = item.getDocumento();
        Optional parcelaComCancelamento = this.getParcelaSeTemCancelamento(documento, item);
        parcelaComCancelamento.ifPresent(parcela -> item.setValor(parcela.getValor()));
    }

    private void atualizarValoresItem(AtualizaItensParcelasDTO dto, DocumentoItemDividaAtiva item, ListasNecessariasCalculaAcrescimoDTO listasNecessarias) {
        Long sequenciaItem = item.getId().getSequenciaItem();
        Documento documento = item.getDocumento();
        AcrescimoDTO acrescimoDaParcela = this.getAcrescimoDaParcela(dto, sequenciaItem);
        acrescimoDaParcela.setValor(item.getValor());
        AcrescimoDTO acrescimoDTO = this.calculoAcrescimoService.calculaAcrescimos(acrescimoDaParcela, Optional.of(listasNecessarias));
        item.setValorMulta(acrescimoDTO.getValorMulta());
        item.setValorCorrecao(acrescimoDTO.getValorCorrecao());
        item.setValorJuros(acrescimoDTO.getValorJuros());
        this.certidaoDividaAtivaHistoricoService.salvaHistoricoOperacaoAtualizacaoValor(documento, item, acrescimoDTO);
    }

    private void validarCdaExercicio(Long cda, Long exercicio) {
        if (Objects.isNull(cda)) {
            throw new EloValidationException("N\u00e3o foi encontrado valor da CDA");
        }
        if (Objects.isNull(exercicio)) {
            throw new EloValidationException("N\u00e3o foi encontrado valor do exerc\u00edcio");
        }
    }

    public BigDecimal getValorTotalCdaByDocumentoExercicio(Long cda, Long exercicio) {
        this.validarCdaExercicio(cda, exercicio);
        try {
            return this.documentoItemDividaAtivaRepository.findValorTotalPorCda(cda, exercicio, TipoDocumentoEnum.CERTIDAO_DIVIDA_ATIVA.getCodigo());
        }
        catch (Exception e) {
            throw new EloValidationException("Erro ao somar valor total: " + e.getMessage());
        }
    }

    @Generated
    public DocumentoItemDividaAtivaService(DocumentoItemDividaAtivaRepository documentoItemDividaAtivaRepository, DocumentoService documentoService, DocumentoRepository documentoRepository, FormaPagamentoService formaPagamentoService, CalculoAcrescimoService calculoAcrescimoService, CertidaoDividaAtivaHistoricoService certidaoDividaAtivaHistoricoService, DebitoParcelaTributoRepository debitoParcelaTributoRepository, LoteCdaItemDetalheService loteCdaItemDetalheService, ParametroGeralService parametroGeralService) {
        this.documentoItemDividaAtivaRepository = documentoItemDividaAtivaRepository;
        this.documentoService = documentoService;
        this.documentoRepository = documentoRepository;
        this.formaPagamentoService = formaPagamentoService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.certidaoDividaAtivaHistoricoService = certidaoDividaAtivaHistoricoService;
        this.debitoParcelaTributoRepository = debitoParcelaTributoRepository;
        this.loteCdaItemDetalheService = loteCdaItemDetalheService;
        this.parametroGeralService = parametroGeralService;
    }
}

