/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaGrupoVencimento;
import br.com.elotech.tributos.domain.DividaGrupoVencimentoId;
import br.com.elotech.tributos.repository.DividaGrupoVencimentoRepository;
import br.com.elotech.tributos.repository.DividaRepository;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class DividaGrupoVencimentoService
extends CrudService<DividaGrupoVencimento, DividaGrupoVencimentoId> {
    private final DividaGrupoVencimentoRepository dividaGrupoVencimentoRepository;
    private final DividaRepository dividaRepository;

    public DividaGrupoVencimentoService(DividaGrupoVencimentoRepository dividaGrupoVencimentoRepository, DividaRepository dividaRepository) {
        this.dividaGrupoVencimentoRepository = dividaGrupoVencimentoRepository;
        this.dividaRepository = dividaRepository;
    }

    public List<DividaGrupoVencimento> findByDividaId(Long id) {
        return this.dividaGrupoVencimentoRepository.findByDividaIdOrderByIdGrupoVencimentoAsc(id);
    }

    public DividaGrupoVencimento save(Long idDivida, DividaGrupoVencimento dividaGrupoVencimento) {
        Divida divida = (Divida)this.dividaRepository.findById((Object)idDivida).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar a d\u00edvida com o id %d.", idDivida)));
        this.validaParcela(dividaGrupoVencimento);
        dividaGrupoVencimento.setDivida(divida);
        dividaGrupoVencimento.getId().setDivida(divida.getDivida());
        dividaGrupoVencimento.getId().setGrupoVencimento(dividaGrupoVencimento.getProximoNumeroVencimento());
        dividaGrupoVencimento.setDividaTributoParcelaId();
        return (DividaGrupoVencimento)this.save((EloEntity)dividaGrupoVencimento, null);
    }

    public DividaGrupoVencimento update(DividaGrupoVencimento dividaGrupoVencimentoAtualizado) {
        DividaGrupoVencimento dividaGrupoVencimento = (DividaGrupoVencimento)this.dividaGrupoVencimentoRepository.findById((Object)dividaGrupoVencimentoAtualizado.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u0101o foi poss\u00edvel encontrar o grupo de vencimento %d na d\u00edvida %d para exerc\u00edcio %d.", dividaGrupoVencimentoAtualizado.getId().getGrupoVencimento(), dividaGrupoVencimentoAtualizado.getId().getDivida(), dividaGrupoVencimentoAtualizado.getId().getExercicio())));
        this.validaParcela(dividaGrupoVencimentoAtualizado);
        dividaGrupoVencimento.setDataBase(dividaGrupoVencimentoAtualizado.getDataBase());
        dividaGrupoVencimento.setNumeroParcelas(dividaGrupoVencimentoAtualizado.getNumeroParcelas());
        dividaGrupoVencimento.mergeParcelas(dividaGrupoVencimentoAtualizado.getParcelas());
        return (DividaGrupoVencimento)this.save((EloEntity)dividaGrupoVencimento, null);
    }

    private void validaParcela(DividaGrupoVencimento dividaGrupoVencimento) {
        if (dividaGrupoVencimento.getParcelas().isEmpty()) {
            throw new EloValidationException("Necess\u00e1rio ter parcela(s) gerada(s) para salvar o grupo de vencimento.");
        }
        if (!dividaGrupoVencimento.getNumeroParcelas().equals(dividaGrupoVencimento.getParcelas().size())) {
            throw new EloValidationException("Necess\u00e1rio que a quantidade de parcela(s) gerada(s) seja igual ao n\u00famero de parcelas.");
        }
    }

    public void delete(DividaGrupoVencimentoId id) {
        this.dividaGrupoVencimentoRepository.deleteById((Object)id);
    }
}

