/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.DividaFormaPagamento;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.dto.DividaFormaPagamentoConvenioDTO;
import br.com.elotech.tributos.repository.DividaFormaPagamentoRepository;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class DividaFormaPagamentoService
extends CrudService<DividaFormaPagamento, Long> {
    private final DividaFormaPagamentoRepository dividaFormaPagamentoRepository;

    public DividaFormaPagamentoService(DividaFormaPagamentoRepository dividaFormaPagamentoRepository) {
        this.dividaFormaPagamentoRepository = dividaFormaPagamentoRepository;
    }

    public DividaFormaPagamento findByEntidadeAndExercicioAndDividaAndFormaPagamentoId(Long entidade, Long exercicio, Long divida, Long formaPagamento) {
        return this.dividaFormaPagamentoRepository.findByEntidadeAndExercicioAndGuiaRecolhimentoAndFormaPagamentoId(entidade, exercicio, divida, formaPagamento);
    }

    public List<DividaFormaPagamentoConvenioDTO> findDividaFormaPagamentoByIdDebitoAndFormaPagamentoAndExercicio(List<Long> debitos, Long formaPagamento, Long exercicio) {
        return this.dividaFormaPagamentoRepository.findDividaFormaPagamentoByIdDebitoAndFormaPagamentoAndExercicio(debitos, formaPagamento, exercicio);
    }

    public Page<FormaPagamento> findFormasPagamentoByDividaIdAndRsql(Long id, String search, Pageable pageable) {
        return this.findByDividaIdAndRsql(id, search, pageable).map(DividaFormaPagamento::getFormaPagamento);
    }

    private Page<DividaFormaPagamento> findByDividaIdAndRsql(Long id, String search, Pageable pageable) {
        String finalRsql = String.format("divida.id == %d %s", id, StringUtils.isBlank((String)search) ? "" : "and (" + search + ")");
        return this.findByRsql(finalRsql, pageable);
    }
}

